/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.io.hook;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.swt.win32.extension.io.listener.CDDriveChangeListener;
import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.callback.WNDCallback;
import org.sf.feeling.swt.win32.internal.extension.callback.WNDCallbackManager;

public class CDDriveMsgHook {
    private static final int WM_DEVICECHANGE = 537;
    private int oldAddress;
    private Shell shell;
    private Callback windowMsgCallback;
    private int newAddress;
    private WNDCallback callback;
    private List listeners;

    public CDDriveMsgHook(Shell shell) {
        this.shell = shell;
    }

    public void installHook() {
        if (this.callback == null) {
            this.windowMsgCallback = new Callback((Object)this, "WindowMsgProc", 4);
            this.newAddress = this.windowMsgCallback.getAddress();
            this.oldAddress = Extension.SetWindowLong((int)this.shell.handle, (int)-4, (int)this.newAddress);
            this.callback = new WNDCallback(this.shell, this.oldAddress, this.newAddress){

                public void dispose() {
                    CDDriveMsgHook.this.disposeCallback();
                }
            };
            WNDCallbackManager.addCallback(this.shell, this.callback);
            this.shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    CDDriveMsgHook.this.unInstallHook();
                }
            });
        }
    }

    public void unInstallHook() {
        if (this.callback != null) {
            WNDCallbackManager.disposeCallback(this.shell, this.callback);
        }
    }

    private void disposeCallback() {
        if (this.callback != null) {
            Extension.SetWindowLong((int)this.shell.handle, (int)-4, (int)this.callback.getOldAddress());
            this.windowMsgCallback.dispose();
            this.windowMsgCallback = null;
            this.newAddress = 0;
            this.callback = null;
        }
    }

    int WindowMsgProc(int n, int n2, int n3, int n4) {
        if (n2 == 537) {
            Event event = new Event();
            event.type = n3;
            event.detail = n4;
            event.widget = this.shell;
            event.time = Extension.GetTickCount();
            this.fireChangedEvent(event);
        }
        return Extension.CallWindowProc((int)this.oldAddress, (int)n, (int)n2, (int)n3, (int)n4);
    }

    public void addChangeListener(CDDriveChangeListener cDDriveChangeListener) {
        if (cDDriveChangeListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(cDDriveChangeListener)) {
            this.listeners.add(cDDriveChangeListener);
        }
    }

    public void removeChangeListener(CDDriveChangeListener cDDriveChangeListener) {
        if (cDDriveChangeListener == null) {
            return;
        }
        if (this.listeners != null) {
            this.listeners.remove(cDDriveChangeListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    void fireChangedEvent(final Event event) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                final CDDriveChangeListener cDDriveChangeListener = (CDDriveChangeListener)this.listeners.get(i);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (event.type == 32768) {
                            cDDriveChangeListener.driveLoaded(event);
                        } else if (event.type == 32772) {
                            cDDriveChangeListener.driveEjected(event);
                        }
                    }
                });
            }
        }
    }
}

