/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.datatype;

import org.sf.feeling.swt.win32.extension.jna.Machine;
import org.sf.feeling.swt.win32.extension.jna.datatype.AbstractBasicData;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;

public class INT
extends AbstractBasicData {
    public INT(int n) {
        super(new Integer(n));
        try {
            this.createPointer();
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
    }

    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(INT.sizeOf()));
        this.pointer.setIntAt(0, (Integer)this.mValue);
        return this.pointer;
    }

    public Object getValueFromPointer() throws NativeException {
        this.mValue = new Integer(this.pointer.getAsInt(0));
        return this.mValue;
    }

    public int getSizeOf() {
        return INT.sizeOf();
    }

    public void setValue(int n) throws NativeException {
        this.mValue = new Integer(n);
        this.pointer.setIntAt(0, n);
    }

    public int getValue() {
        try {
            return (Integer)this.getValueFromPointer();
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
    }

    public static int sizeOf() {
        return Machine.SIZE * 4;
    }
}

