/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.ptr;

import java.io.UnsupportedEncodingException;
import org.sf.feeling.swt.win32.extension.jna.Native;
import org.sf.feeling.swt.win32.extension.jna.StructConverter;
import org.sf.feeling.swt.win32.extension.jna.datatype.LONG;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.NullPointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlock;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.NativeMemoryBlock;
import org.sf.feeling.swt.win32.internal.extension.Extension;

public class Pointer {
    private MemoryBlock mem;

    public Pointer(MemoryBlock memoryBlock) {
        this.mem = memoryBlock;
    }

    public static Pointer createPointerFromString(String string) throws NativeException {
        if (string == null) {
            return NullPointer.NULL;
        }
        Pointer pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(string.length() + 1));
        pointer.setStringAt(0, string);
        return pointer;
    }

    public static Pointer createPointerFromString(String string, boolean bl) throws NativeException {
        if (!bl) {
            return Pointer.createPointerFromString(string);
        }
        if (string == null) {
            return NullPointer.NULL;
        }
        Pointer pointer = new Pointer(MemoryBlockFactory.createMemoryBlock((string.length() + 1) * 2));
        Extension.MoveMemory((int)pointer.getPointer(), (char[])(string + "\u0000").toCharArray(), (int)pointer.getSize());
        return pointer;
    }

    public static Pointer createPointerFromString(String string, String string2) throws NativeException, UnsupportedEncodingException {
        if (string == null) {
            return NullPointer.NULL;
        }
        byte[] byArray = string.getBytes(string2);
        Pointer pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(byArray.length + 1));
        pointer.setMemory(byArray);
        return pointer;
    }

    public static Pointer createPointer(int n) throws NativeException {
        if (n <= 0) {
            return NullPointer.NULL;
        }
        return new Pointer(MemoryBlockFactory.createMemoryBlock(n));
    }

    public static Pointer createPointerToNativeMemory(int n, int n2) throws NativeException {
        if (n == 0 || n2 <= 0) {
            return NullPointer.NULL;
        }
        return new Pointer(new NativeMemoryBlock(n, n2));
    }

    public void dispose() throws NativeException {
        this.mem.dispose();
    }

    public int getPointer() {
        return this.mem.getPointer();
    }

    public int getSize() {
        return this.mem.getSize();
    }

    public void setMemory(String string) throws NativeException, ArrayIndexOutOfBoundsException {
        if (string.length() > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This string is bigger than the current memory addressed by my pointer : " + string.length() + ">" + this.mem.getSize());
        }
        Native.setMemory(this.mem.getPointer(), string);
    }

    public void setMemory(byte[] byArray) throws NativeException {
        if (byArray.length > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This buffer is bigger than the current memory addressed by my pointer : " + byArray.length + ">" + this.mem.getSize());
        }
        Native.setMemory(this.mem.getPointer(), byArray);
    }

    public int setByteAt(int n, byte by) throws NativeException {
        if (n > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + n + ">" + this.mem.getSize());
        }
        byte[] byArray = new byte[]{by};
        Native.setMemory(this.mem.getPointer(), byArray, n, 1);
        return 1;
    }

    public int setShortAt(int n, short s) throws NativeException {
        if (n + 2 > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (n + 2) + ">" + this.mem.getSize());
        }
        byte[] byArray = new byte[2];
        StructConverter.shortIntoBytes(s, byArray, 0);
        Native.setMemory(this.mem.getPointer(), byArray, n, 2);
        return 2;
    }

    public int setIntAt(int n, int n2) throws NativeException {
        if (n + 4 > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (n + 4) + ">" + this.mem.getSize());
        }
        byte[] byArray = new byte[4];
        StructConverter.intIntoBytes(n2, byArray, 0);
        Native.setMemory(this.mem.getPointer(), byArray, n, 4);
        return 4;
    }

    public int setLongAt(int n, long l) throws NativeException {
        if (n + 8 > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (n + 8) + ">" + this.mem.getSize());
        }
        byte[] byArray = new byte[8];
        StructConverter.longIntoBytes(l, byArray, 0);
        Native.setMemory(this.mem.getPointer(), byArray, n, 8);
        return 8;
    }

    public int setFloatAt(int n, float f) throws NativeException {
        if (n + 4 > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (n + 8) + ">" + this.mem.getSize());
        }
        byte[] byArray = new byte[8];
        StructConverter.floatIntoBytes(f, byArray, 0);
        Native.setMemory(this.mem.getPointer(), byArray, n, 8);
        return 8;
    }

    public int setDoubleAt(int n, double d) throws NativeException {
        if (n + 8 > this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (n + 8) + ">" + this.mem.getSize());
        }
        byte[] byArray = new byte[8];
        StructConverter.doubleIntoBytes(d, byArray, 0);
        Native.setMemory(this.mem.getPointer(), byArray, n, 8);
        return 8;
    }

    public int setStringAt(int n, String string) throws NativeException {
        int n2 = string.getBytes().length;
        if (n + n2 >= this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (n + n2) + ">" + this.mem.getSize());
        }
        Native.setMemory(this.mem.getPointer(), string.getBytes(), n, n2);
        return n2;
    }

    public int setStringAt(int n, String string, boolean bl) throws NativeException {
        if (!bl) {
            return this.setStringAt(n, string);
        }
        int n2 = string.length() * 2;
        if (n + n2 >= this.mem.getSize()) {
            throw new ArrayIndexOutOfBoundsException("This data is bigger than the current memory addressed by my pointer : " + (n + n2) + ">" + this.mem.getSize());
        }
        Extension.MoveMemory((int)this.mem.getPointer(), (char[])string.toCharArray(), (int)n2);
        return n2;
    }

    public void zeroMemory() throws NativeException {
        this.setMemory(new byte[this.mem.getSize()]);
    }

    public byte[] getMemory() throws NativeException {
        return Native.getMemory(this.mem.getPointer(), this.mem.getSize());
    }

    public String getAsString() throws NativeException {
        return Native.getMemoryAsString(this.mem.getPointer(), this.mem.getSize());
    }

    public String getAsString(boolean bl) throws NativeException {
        if (!bl) {
            return this.getAsString();
        }
        int n = Extension.wcslen((int)this.mem.getPointer());
        char[] cArray = new char[n];
        Extension.MoveMemory((char[])cArray, (int)this.mem.getPointer(), (int)(n * 2));
        return new String(cArray, 0, n);
    }

    public byte getAsByte(int n) throws NativeException {
        return Native.getMemory(this.mem.getPointer(), this.mem.getSize())[n];
    }

    public short getAsShort(int n) throws NativeException {
        return StructConverter.bytesIntoShort(Native.getMemory(this.mem.getPointer(), this.mem.getSize()), n);
    }

    public int getAsInt(int n) throws NativeException {
        return StructConverter.bytesIntoInt(Native.getMemory(this.mem.getPointer(), this.mem.getSize()), n);
    }

    public long getAsLong(int n) throws NativeException {
        return StructConverter.bytesIntoLong(Native.getMemory(this.mem.getPointer(), this.mem.getSize()), n);
    }

    public float getAsFloat(int n) throws NativeException {
        return StructConverter.bytesIntoFloat(Native.getMemory(this.mem.getPointer(), this.mem.getSize()), n);
    }

    public double getAsDouble(int n) throws NativeException {
        return StructConverter.bytesIntoDouble(Native.getMemory(this.mem.getPointer(), this.mem.getSize()), n);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isNull() {
        return this.mem == null || this.mem.getPointer() == 0;
    }

    public LONG asLONG() {
        return new LONG(this.getPointer());
    }
}

