/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;

public class FILEINFO
extends Structure {
    public static final int MAX_PATH = 256;

    public FILEINFO() {
        try {
            this.createPointer();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        return this.pointer;
    }

    public int getSizeOf() {
        return 384;
    }

    public Object getValueFromPointer() throws NativeException {
        return this;
    }

    public FILEINFO getValue() {
        return this;
    }

    public int getIcon() throws NativeException {
        return this.pointer.getAsInt(0);
    }

    public int getIndex() throws NativeException {
        return this.pointer.getAsInt(4);
    }

    public String getDisplayName() throws NativeException {
        byte[] byArray = new byte[256];
        for (int i = 0; i < 244; ++i) {
            byArray[i] = this.pointer.getAsByte(i + 12);
        }
        return new String(byArray).trim();
    }

    public String getTypeName() throws NativeException {
        byte[] byArray = new byte[80];
        for (int i = 0; i < 80; ++i) {
            byArray[i] = this.pointer.getAsByte(i + 12 + 256);
        }
        return new String(byArray).trim();
    }
}

