/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.NativeMemoryBlock;

public class IP_ADDR_STRING
extends Structure {
    int next;
    String IpAddress;
    String IpMask;
    int Context;

    protected IP_ADDR_STRING() {
        try {
            this.createPointer();
        }
        catch (NativeException nativeException) {
            throw new RuntimeException(nativeException);
        }
    }

    private IP_ADDR_STRING(int n) {
        this.pointer = new Pointer(new NativeMemoryBlock(n, this.getSizeOf()));
    }

    private IP_ADDR_STRING(Pointer pointer) {
        this.pointer = pointer;
    }

    public static IP_ADDR_STRING fromAddress(int n) throws NativeException {
        return new IP_ADDR_STRING(n).getValue();
    }

    public static IP_ADDR_STRING fromPointer(Pointer pointer) throws NativeException {
        return new IP_ADDR_STRING(pointer).getValue();
    }

    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        return this.pointer;
    }

    public int getSizeOf() {
        return 40;
    }

    private String getString(byte[] byArray, int n, int n2) {
        String string = new String(byArray, n, n2);
        int n3 = string.indexOf(0);
        if (n != -1) {
            string = string.substring(0, n3);
        }
        return string;
    }

    public Object getValueFromPointer() throws NativeException {
        this.next = this.pointer.getAsInt(0);
        byte[] byArray = this.pointer.getMemory();
        this.IpAddress = this.getString(byArray, 4, 16);
        this.IpMask = this.getString(byArray, 20, 16);
        this.Context = this.pointer.getAsInt(36);
        return this;
    }

    public IP_ADDR_STRING getValue() throws NativeException {
        return (IP_ADDR_STRING)this.getValueFromPointer();
    }

    public int getNext() {
        return this.next;
    }

    public String getIpAddress() {
        return this.IpAddress;
    }

    public String getIpMask() {
        return this.IpMask;
    }

    public int getContext() {
        return this.Context;
    }
}

