/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.sf.feeling.swt.win32.extension.jna.Native;
import org.sf.feeling.swt.win32.extension.jna.datatype.LONG;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.HANDLE;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.NullPointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.GlobalMemoryBlock;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.HKEY;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.HWND;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.ITEMID;

public class SHELLEXECUTEINFO
extends Structure {
    public static final int SEE_MASK_CLASSKEY = 3;
    public static final int SEE_MASK_CLASSNAME = 1;
    public static final int SEE_MASK_CONNECTNETDRV = 128;
    public static final int SEE_MASK_DOENVSUBST = 512;
    public static final int SEE_MASK_FLAG_DDEWAIT = 256;
    public static final int SEE_MASK_FLAG_NO_UI = 1024;
    public static final int SEE_MASK_HOTKEY = 32;
    public static final int SEE_MASK_ICON = 16;
    public static final int SEE_MASK_IDLIST = 4;
    public static final int SEE_MASK_INVOKEIDLIST = 12;
    public static final int SEE_MASK_NOCLOSEPROCESS = 64;
    public static final int SE_ERR_ACCESSDENIED = 5;
    public static final int SE_ERR_ASSOCINCOMPLETE = 27;
    public static final int SE_ERR_DDEBUSY = 30;
    public static final int SE_ERR_DDEFAIL = 29;
    public static final int SE_ERR_DDETIMEOUT = 28;
    public static final int SE_ERR_DLLNOTFOUND = 32;
    public static final int SE_ERR_FNF = 2;
    public static final int SE_ERR_NOASSOC = 31;
    public static final int SE_ERR_OOM = 8;
    public static final int SE_ERR_PNF = 3;
    public static final int SE_ERR_SHARE = 26;
    public static final int INFINITE = 65535;
    public static final int WAIT_ABANDONED = 128;
    public static final int WAIT_FAILED = -1;
    public static final int WAIT_OBJECT_0 = 0;
    public static final int WAIT_TIMEOUT = 258;
    public int fMask;
    public HWND hwnd;
    public String lpVerb;
    public String lpFile;
    public String lpParameters;
    public String lpDirectory;
    public int nShow;
    public LONG hInstApp;
    public ITEMID lpIDList;
    public String lpClass;
    public HKEY hkeyClass;
    public int dwHotKey;
    public int union;
    public HANDLE hProcess;
    private final Pointer lpVerbPointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));
    private final Pointer lpFilePointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));
    private final Pointer lpParametersPointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));
    private final Pointer lpDirectoryPointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));
    private final Pointer lpClassPointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));

    private void toPointer() throws NativeException {
        this.lpVerbPointer.zeroMemory();
        if (this.lpVerb != null) {
            this.lpVerbPointer.setStringAt(0, this.lpVerb);
        }
        this.lpFilePointer.zeroMemory();
        if (this.lpFile != null) {
            this.lpFilePointer.setStringAt(0, this.lpFile);
        }
        this.lpParametersPointer.zeroMemory();
        if (this.lpParameters != null) {
            this.lpParametersPointer.setStringAt(0, this.lpParameters);
        }
        this.lpDirectoryPointer.zeroMemory();
        if (this.lpDirectory != null) {
            this.lpDirectoryPointer.setStringAt(0, this.lpDirectory);
        }
        this.lpClassPointer.zeroMemory();
        if (this.lpClass != null) {
            this.lpClassPointer.setStringAt(0, this.lpClass);
        }
        this.offset = 0;
        this.offset += this.pointer.setIntAt(this.offset, this.getSizeOf());
        this.offset += this.pointer.setIntAt(this.offset, this.fMask);
        this.offset += this.pointer.setIntAt(this.offset, this.hwnd == null ? NullPointer.NULL.getPointer() : this.hwnd.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.lpVerb == null ? NullPointer.NULL.getPointer() : this.lpVerbPointer.getPointer());
        this.offset += this.pointer.setIntAt(this.offset, this.lpFile == null ? NullPointer.NULL.getPointer() : this.lpFilePointer.getPointer());
        this.offset += this.pointer.setIntAt(this.offset, this.lpParameters == null ? NullPointer.NULL.getPointer() : this.lpParametersPointer.getPointer());
        this.offset += this.pointer.setIntAt(this.offset, this.lpDirectory == null ? NullPointer.NULL.getPointer() : this.lpDirectoryPointer.getPointer());
        this.offset += this.pointer.setIntAt(this.offset, this.nShow);
        this.offset += this.pointer.setIntAt(this.offset, this.hInstApp == null ? NullPointer.NULL.getPointer() : this.hInstApp.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.lpIDList == null ? NullPointer.NULL.getPointer() : Integer.parseInt(this.lpIDList.getSpecialPath()));
        this.offset += this.pointer.setIntAt(this.offset, this.lpClass == null ? NullPointer.NULL.getPointer() : this.lpClassPointer.getPointer());
        this.offset += this.pointer.setIntAt(this.offset, this.hkeyClass == null ? NullPointer.NULL.getPointer() : this.hkeyClass.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.dwHotKey);
        this.offset += this.pointer.setIntAt(this.offset, this.union);
        this.pointer.setIntAt(this.offset, this.hProcess == null ? NullPointer.NULL.getPointer() : this.hProcess.getValue());
        this.offset = 0;
    }

    private void fromPointer() throws NativeException {
        this.getNextInt();
        this.fMask = this.getNextInt();
        this.hwnd = new HWND(this.getNextInt());
        int n = this.getNextInt();
        if (n != 0) {
            this.lpVerb = Native.getMemoryAsString(n, 256);
        }
        if ((n = this.getNextInt()) != 0) {
            this.lpFile = Native.getMemoryAsString(n, 256);
        }
        if ((n = this.getNextInt()) != 0) {
            this.lpParameters = Native.getMemoryAsString(n, 256);
        }
        if ((n = this.getNextInt()) != 0) {
            this.lpDirectory = Native.getMemoryAsString(n, 256);
        }
        this.nShow = this.getNextInt();
        this.hInstApp = new LONG(this.getNextInt());
        this.lpIDList = new ITEMID();
        this.lpIDList.setData(Native.getMemory(this.getNextInt(), 5));
        n = this.getNextInt();
        if (n != 0) {
            this.lpClass = Native.getMemoryAsString(n, 256);
        }
        this.hkeyClass = new HKEY(this.getNextInt());
        this.dwHotKey = this.getNextInt();
        this.union = this.getNextInt();
        this.hProcess = new HANDLE(this.getNextInt());
    }

    public Pointer createPointer() throws NativeException {
        if (this.pointer == null) {
            this.pointer = new Pointer(new GlobalMemoryBlock(this.getSizeOf()));
        }
        this.toPointer();
        return this.pointer;
    }

    public int getSizeOf() {
        return SHELLEXECUTEINFO.sizeOf();
    }

    public static int sizeOf() {
        return 60;
    }

    public Object getValueFromPointer() throws NativeException {
        this.fromPointer();
        return this;
    }

    public SHELLEXECUTEINFO getValue() throws NativeException {
        return (SHELLEXECUTEINFO)this.getValueFromPointer();
    }
}

