/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.sf.feeling.swt.win32.extension.jna.Native;
import org.sf.feeling.swt.win32.extension.jna.datatype.SHORT;
import org.sf.feeling.swt.win32.extension.jna.datatype.UINT;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.BOOL;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.NullPointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.GlobalMemoryBlock;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.HWND;

public class SHFILEOPSTRUCT
extends Structure {
    public static final int FO_MOVE = 1;
    public static final int FO_COPY = 2;
    public static final int FO_DELETE = 3;
    public static final int FO_RENAME = 4;
    public HWND hwnd;
    public UINT wFunc;
    public String pFrom;
    public String pTo;
    public SHORT fFlags;
    public BOOL fAnyOperationsAborted;
    public UINT hNameMappings;
    public String lpszProgressTitle;
    public Pointer lpszProgressTitlePointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));
    public Pointer pFromPointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));
    public Pointer pToPointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));

    private void toPointer() throws NativeException {
        this.pFromPointer.zeroMemory();
        if (this.pFrom != null) {
            this.pFromPointer.setStringAt(0, this.pFrom, false);
        }
        this.pToPointer.zeroMemory();
        if (this.pTo != null) {
            this.pToPointer.setStringAt(0, this.pTo, false);
        }
        this.lpszProgressTitlePointer.zeroMemory();
        if (this.lpszProgressTitle != null) {
            this.lpszProgressTitlePointer.setStringAt(0, this.lpszProgressTitle);
        }
        this.offset = 0;
        this.offset += this.pointer.setIntAt(this.offset, this.hwnd == null ? 0 : this.hwnd.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.wFunc == null ? 0 : this.wFunc.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.pFrom == null ? NullPointer.NULL.getPointer() : this.pFromPointer.getPointer());
        this.offset += this.pointer.setIntAt(this.offset, this.pTo == null ? NullPointer.NULL.getPointer() : this.pToPointer.getPointer());
        this.offset += this.pointer.setShortAt(this.offset, this.fFlags == null ? (short)0 : this.fFlags.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.fAnyOperationsAborted == null ? 0 : this.fAnyOperationsAborted.getValue());
        this.offset += this.pointer.setIntAt(this.offset, NullPointer.NULL.getPointer());
        this.offset += this.pointer.setIntAt(this.offset, this.lpszProgressTitle == null ? NullPointer.NULL.getPointer() : this.lpszProgressTitlePointer.getPointer());
        this.offset = 0;
    }

    public int getSizeOf() {
        return 32;
    }

    public Pointer createPointer() throws NativeException {
        if (this.pointer == null) {
            this.pointer = new Pointer(new GlobalMemoryBlock(this.getSizeOf()));
        }
        this.toPointer();
        return this.pointer;
    }

    public Object getValueFromPointer() throws NativeException {
        this.fromPointer();
        return this;
    }

    private void fromPointer() throws NativeException {
        this.offset = 0;
        this.hwnd = new HWND(this.getNextInt());
        this.wFunc = new UINT(this.getNextInt());
        int n = this.getNextInt();
        if (n != 0) {
            this.pFrom = Native.getMemoryAsString(n, 256);
        }
        if ((n = this.getNextInt()) != 0) {
            this.pTo = Native.getMemoryAsString(n, 256);
        }
        this.fFlags = new SHORT(this.getNextShort());
        this.fAnyOperationsAborted = new BOOL(this.getNextInt());
        this.hNameMappings = new UINT(this.getNextInt());
        n = this.getNextInt();
        if (n != 0) {
            this.lpszProgressTitle = Native.getMemoryAsString(n, 256);
        }
    }

    public SHFILEOPSTRUCT getValue() throws NativeException {
        return (SHFILEOPSTRUCT)this.getValueFromPointer();
    }

    public static interface FILEOP_FLAGS {
        public static final short FOF_MULTIDESTFILES = 1;
        public static final short FOF_CONFIRMMOUSE = 2;
        public static final short FOF_SILENT = 4;
        public static final short FOF_RENAMEONCOLLISION = 8;
        public static final short FOF_NOCONFIRMATION = 16;
        public static final short FOF_WANTMAPPINGHANDLE = 32;
        public static final short FOF_ALLOWUNDO = 64;
        public static final short FOF_FILESONLY = 128;
        public static final short FOF_SIMPLEPROGRESS = 256;
        public static final short FOF_NOCONFIRMMKDIR = 512;
        public static final short FOF_NOERRORUI = 1024;
        public static final short FOF_NOCOPYSECURITYATTRIBS = 2048;
    }
}

