/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.jna.win32.structure;

import org.sf.feeling.swt.win32.extension.jna.Native;
import org.sf.feeling.swt.win32.extension.jna.datatype.LONG;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.Structure;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.ptr.NullPointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.Pointer;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.GlobalMemoryBlock;
import org.sf.feeling.swt.win32.extension.jna.ptr.memory.MemoryBlockFactory;

public class WNDCLASSEX
extends Structure {
    private LONG style = new LONG(0);
    private LONG lpfnWndProc = new LONG(0);
    private int cbClsExtra = 0;
    private int cbWndExtra = 0;
    private LONG hInstance = new LONG(0);
    private LONG hIcon = new LONG(0);
    private LONG hCursor = new LONG(0);
    private LONG hbrBackground = new LONG(0);
    private String lpszMenuName = null;
    private String lpszClassName = null;
    private LONG hIconSm = new LONG(0);
    private final Pointer lpszMenuNamePointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));
    private final Pointer lpszClassNamePointer = new Pointer(MemoryBlockFactory.createMemoryBlock(256));

    public WNDCLASSEX() throws NativeException {
        this(null);
    }

    protected WNDCLASSEX(WNDCLASSEX wNDCLASSEX) throws NativeException {
        super(wNDCLASSEX);
    }

    private void toPointer() throws NativeException {
        this.offset = 0;
        this.offset += this.pointer.setIntAt(this.offset, this.getSizeOf());
        this.offset += this.pointer.setIntAt(this.offset, this.style.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.lpfnWndProc.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.cbClsExtra);
        this.offset += this.pointer.setIntAt(this.offset, this.cbWndExtra);
        this.offset += this.pointer.setIntAt(this.offset, this.hInstance.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.hIcon.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.hCursor.getValue());
        this.offset += this.pointer.setIntAt(this.offset, this.hbrBackground.getValue());
        this.lpszClassNamePointer.zeroMemory();
        if (this.lpszClassName != null) {
            this.lpszClassNamePointer.setStringAt(0, this.lpszClassName);
        }
        this.lpszMenuNamePointer.zeroMemory();
        if (this.lpszMenuName != null) {
            this.lpszMenuNamePointer.setStringAt(0, this.lpszMenuName);
        }
        this.offset += this.pointer.setIntAt(this.offset, this.lpszMenuName == null ? NullPointer.NULL.getPointer() : this.lpszMenuNamePointer.getPointer());
        this.offset += this.pointer.setIntAt(this.offset, this.lpszClassName == null ? NullPointer.NULL.getPointer() : this.lpszClassNamePointer.getPointer());
        this.pointer.setIntAt(this.offset, this.hIconSm.getValue());
        this.offset = 0;
    }

    private void fromPointer() throws NativeException {
        this.getNextInt();
        this.style = new LONG(this.getNextInt());
        this.lpfnWndProc = new LONG(this.getNextInt());
        this.cbClsExtra = this.getNextInt();
        this.cbWndExtra = this.getNextInt();
        this.hInstance = new LONG(this.getNextInt());
        this.hIcon = new LONG(this.getNextInt());
        this.hCursor = new LONG(this.getNextInt());
        this.hbrBackground = new LONG(this.getNextInt());
        int n = this.getNextInt();
        if (n != 0) {
            this.lpszMenuName = Native.getMemoryAsString(n, 256);
        }
        if ((n = this.getNextInt()) != 0) {
            this.lpszClassName = Native.getMemoryAsString(n, 256);
        }
        this.hIconSm = new LONG(this.getNextInt());
    }

    public String toString() {
        String string = "style: " + this.style + "\n";
        string = string + "lpfnWndProc: " + this.lpfnWndProc + "\n";
        string = string + "cbClsExtra: " + this.cbClsExtra + "\n";
        string = string + "cbWndExtra: " + this.cbWndExtra + "\n";
        string = string + "hInstance: " + this.hInstance + "\n";
        string = string + "hIcon: " + this.hIcon + "\n";
        string = string + "hCursor: " + this.hCursor + "\n";
        string = string + "hbrBackground: " + this.hbrBackground + "\n";
        string = string + "lpszMenuName: " + this.lpszMenuName + "\n";
        string = string + "lpszClassName: " + this.lpszClassName + "\n";
        string = string + "hIconSm: " + this.hIconSm + "\n";
        return string;
    }

    public Pointer createPointer() throws NativeException {
        if (this.pointer == null) {
            this.pointer = new Pointer(new GlobalMemoryBlock(this.getSizeOf()));
        }
        this.toPointer();
        return this.pointer;
    }

    public int getSizeOf() {
        return 48;
    }

    public Object getValueFromPointer() throws NativeException {
        this.fromPointer();
        return this;
    }

    public WNDCLASSEX getValue() throws NativeException {
        return (WNDCLASSEX)this.getValueFromPointer();
    }

    public int getCbClsExtra() {
        return this.cbClsExtra;
    }

    public void setCbClsExtra(int n) {
        this.cbClsExtra = n;
    }

    public int getCbWndExtra() {
        return this.cbWndExtra;
    }

    public void setCbWndExtra(int n) {
        this.cbWndExtra = n;
    }

    public LONG getHbrBackground() {
        return this.hbrBackground;
    }

    public void setHbrBackground(LONG lONG) {
        this.hbrBackground = lONG;
    }

    public LONG getHCursor() {
        return this.hCursor;
    }

    public void setHCursor(LONG lONG) {
        this.hCursor = lONG;
    }

    public LONG getHIcon() {
        return this.hIcon;
    }

    public void setHIcon(LONG lONG) {
        this.hIcon = lONG;
    }

    public LONG getHInstance() {
        return this.hInstance;
    }

    public void setHInstance(LONG lONG) {
        this.hInstance = lONG;
    }

    public LONG getLpfnWndProc() {
        return this.lpfnWndProc;
    }

    public void setLpfnWndProc(LONG lONG) {
        this.lpfnWndProc = lONG;
    }

    public String getLpszClassName() {
        return this.lpszClassName;
    }

    public void setLpszClassName(String string) {
        this.lpszClassName = string;
    }

    public String getLpszMenuName() {
        return this.lpszMenuName;
    }

    public void setLpszMenuName(String string) {
        this.lpszMenuName = string;
    }

    public LONG getStyle() {
        return this.style;
    }

    public void setStyle(LONG lONG) {
        this.style = lONG;
    }
}

