/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.ole;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Display;
import org.sf.feeling.swt.win32.extension.hook.data.struct.Msg;
import org.sf.feeling.swt.win32.extension.ole.OleContainer;
import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.util.LONG;

public class OleMsgHook {
    private int procHandle;
    private OleContainer container;
    private Callback oleMsgCallback;
    private int oleMsgProcAddress;
    private final String HHOOK;
    private final String HHOOKMSG;

    public OleMsgHook(OleContainer oleContainer) {
        this.container = oleContainer;
        this.HHOOK = oleContainer.getControl().handle + "_" + oleContainer.hashCode() + "_" + "_HHOOK";
        this.HHOOKMSG = oleContainer.getControl().handle + "_" + oleContainer.hashCode() + "_" + "_HHOOK_MSG";
    }

    public void installHook() {
        if (this.oleMsgCallback == null) {
            this.oleMsgCallback = new Callback((Object)this, "OleMsgProc", 3);
            this.oleMsgProcAddress = this.oleMsgCallback.getAddress();
            if (this.oleMsgProcAddress == 0) {
                SWT.error((int)3);
            }
            int n = Extension.GetCurrentThreadId();
            this.procHandle = Extension.SetWindowsHookEx((int)3, (int)this.oleMsgProcAddress, (int)0, (int)n);
            Display.getDefault().setData(this.HHOOK, (Object)new LONG(this.procHandle));
            Display.getDefault().setData(this.HHOOKMSG, (Object)new MSG());
        }
    }

    public void unInstallHook() {
        if (this.oleMsgCallback != null) {
            Extension.UnhookWindowsHookEx((int)this.procHandle);
            this.oleMsgCallback.dispose();
            this.oleMsgCallback = null;
            this.oleMsgProcAddress = 0;
        }
    }

    int OleMsgProc(int n, int n2, int n3) {
        LONG lONG = (LONG)Display.getDefault().getData(this.HHOOK);
        if (lONG == null) {
            return 0;
        }
        if (n < 0) {
            return OS.CallNextHookEx((int)lONG.value, (int)n, (int)n2, (int)n3);
        }
        MSG mSG = (MSG)Display.getDefault().getData(this.HHOOKMSG);
        OS.MoveMemory((MSG)mSG, (int)n3, (int)MSG.sizeof);
        if (!this.container.getControl().isDisposed() && this.container.getHookInterceptor() != null) {
            Msg msg = new Msg(mSG);
            if (this.container.getHookInterceptor().intercept(msg, n, n2, n3)) {
                msg.setMessage(0);
                msg.setLParam(0);
                msg.setWParam(0);
                msg.saveToPoint(n3);
                return 0;
            }
        }
        return Extension.CallNextHookEx((int)lONG.value, (int)n, (int)n2, (int)n3);
    }
}

