/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.registry;

import org.sf.feeling.swt.win32.extension.registry.ValueType;

public class RegistryValue {
    private String name = "";
    private ValueType type = ValueType.REG_SZ;
    private Object data = null;

    public RegistryValue() {
    }

    public RegistryValue(Object object) {
        this.data = object;
    }

    public RegistryValue(String string, Object object) {
        this.name = string;
        this.data = object;
    }

    public RegistryValue(String string, ValueType valueType, Object object) {
        this.name = string;
        this.type = valueType;
        this.data = object;
    }

    public RegistryValue(String string, boolean bl) {
        this(string, ValueType.REG_DWORD, new Boolean(bl));
    }

    public RegistryValue(String string, byte by) {
        this(string, ValueType.REG_BINARY, new Byte(by));
    }

    public RegistryValue(String string, int n) {
        this(string, ValueType.REG_DWORD, new Integer(n));
    }

    public RegistryValue(String string, long l) {
        this(string, ValueType.REG_DWORD, new Long(l));
    }

    public RegistryValue(String string, float f) {
        this(string, ValueType.REG_BINARY, new Float(f));
    }

    public RegistryValue(String string, double d) {
        this(string, ValueType.REG_BINARY, new Double(d));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ValueType getType() {
        return this.type;
    }

    public void setType(ValueType valueType) {
        this.type = valueType;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public void setData(byte by) {
        this.setData(new Byte(by));
    }

    public void setData(boolean bl) {
        this.setData(new Boolean(bl));
    }

    public void setData(int n) {
        this.setData(new Integer(n));
    }

    public void setData(long l) {
        this.setData(new Long(l));
    }

    public void setData(float f) {
        this.setData(new Float(f));
    }

    public void setData(double d) {
        this.setData(new Double(d));
    }

    public String toString() {
        if (this.name == null || this.data == null) {
            throw new NullPointerException("Neither name not data may be null");
        }
        String string = "<no data>";
        if (this.type == ValueType.REG_SZ || this.type == ValueType.REG_EXPAND_SZ || this.type == ValueType.REG_MULTI_SZ) {
            string = this.data.toString();
        } else if (this.type == ValueType.REG_DWORD || this.type == ValueType.REG_DWORD_LITTLE_ENDIAN || this.type == ValueType.REG_DWORD_BIG_ENDIAN) {
            string = ((Integer)this.data).toString();
        } else if (this.type == ValueType.REG_NONE || this.type == ValueType.REG_BINARY) {
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = (byte[])this.data;
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(" " + Byte.toString(byArray[i]));
            }
            string = stringBuffer.toString();
        }
        return this.name + ":" + this.type.toString() + ":" + string;
    }
}

