/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.shell;

import java.util.Random;
import java.util.Vector;
import org.sf.feeling.swt.win32.extension.jna.Callback;
import org.sf.feeling.swt.win32.extension.jna.Native;
import org.sf.feeling.swt.win32.extension.jna.datatype.LONG;
import org.sf.feeling.swt.win32.extension.jna.datatype.UINT;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.LPARAM;
import org.sf.feeling.swt.win32.extension.jna.datatype.win32.WPARAM;
import org.sf.feeling.swt.win32.extension.jna.exception.NativeException;
import org.sf.feeling.swt.win32.extension.jna.win32.Kernel32;
import org.sf.feeling.swt.win32.extension.jna.win32.User32;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.HWND;
import org.sf.feeling.swt.win32.extension.jna.win32.structure.MSG;

public class Hotkey
implements Callback,
Runnable {
    public static final int MOD_ALT = 1;
    public static final int MOD_SHIFT = 4;
    public static final int MOD_CONTROL = 2;
    public static final int MOD_WIN = 8;
    private HWND messageWindow = null;
    private static final Vector hotkeys = new Vector();
    private int myAddress = -1;
    private int iAtom = 0;
    private int prevWndProc = 0;
    private int modifiers = -1;
    private int key = -1;
    private Callback callback = null;
    private boolean isRegistered = false;
    private Thread thread = null;
    private boolean loopStarted = false;

    public Hotkey(int n, int n2) {
        this.modifiers = n;
        this.key = n2;
    }

    public Hotkey(int n, int n2, Callback callback) {
        this(n, n2);
        this.callback = callback;
    }

    public void run() {
        try {
            this.createNativeWindow();
            if (this.callback == null) {
                this.setCallback(this);
            }
            this.prevWndProc = User32.SetWindowLong(this.messageWindow, -4, new LONG(this.callback.getCallbackAddress()));
            this.registerHotkeyInternal();
            this.startNativeMessageLoop();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NativeException nativeException) {
            nativeException.printStackTrace();
        }
    }

    private void stopNativeMessageLoop() {
        this.loopStarted = false;
        try {
            User32.PostMessage(this.messageWindow, new UINT(18), new WPARAM(this.iAtom), new LPARAM(0));
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NativeException nativeException) {
            nativeException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startNativeMessageLoop() throws NativeException, IllegalAccessException {
        if (this.loopStarted) {
            return;
        }
        this.loopStarted = true;
        try {
            MSG mSG = new MSG();
            while (User32.GetMessage(mSG, this.messageWindow, 0, 0) > 0) {
                User32.TranslateMessage(mSG);
                User32.DispatchMessage(mSG);
                mSG.getPointer().zeroMemory();
            }
        }
        finally {
            this.loopStarted = false;
        }
    }

    public static Vector getInstalledHotkeys() {
        return hotkeys;
    }

    public static final void unregisterAllHotkeys() throws NativeException, IllegalAccessException {
        for (int i = hotkeys.size() - 1; i >= 0; --i) {
            Hotkey hotkey = (Hotkey)hotkeys.get(i);
            if (!hotkey.isRegistered()) continue;
            hotkey.unregisterHotkey();
        }
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getKey() {
        return this.key;
    }

    public int getPrevWndProc() {
        return this.prevWndProc;
    }

    public int getAtom() {
        return this.iAtom;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public HWND getNativeHWND() {
        return this.messageWindow;
    }

    private void createNativeWindow() throws NativeException, IllegalAccessException {
        this.messageWindow = new HWND(User32.CreateWindowEx(0, "Button", "" + new Random().nextInt(Integer.MAX_VALUE), 0, 0, 0, 0, 0, 0, 0, 0, 0));
    }

    private void destroyNativeWindow() throws NativeException, IllegalAccessException {
        if (this.messageWindow != null) {
            User32.DestroyWindow(this.messageWindow);
        }
        this.messageWindow = null;
    }

    public final void registerHotkey() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    private final boolean registerHotkeyInternal() throws NativeException, IllegalAccessException {
        this.iAtom = Kernel32.GlobalAddAtom("HotKey" + new Random().nextInt(Integer.MAX_VALUE));
        if (this.iAtom != 0) {
            this.isRegistered = User32.RegisterHotKey(this.messageWindow, this.iAtom, this.modifiers, this.key);
            if (this.isRegistered) {
                hotkeys.add(this);
                return true;
            }
            this.unregisterHotkey();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterHotkey() throws NativeException, IllegalAccessException {
        try {
            this.stopNativeMessageLoop();
            if (this.messageWindow != null) {
                User32.UnregisterHotKey(this.messageWindow, this.iAtom);
                User32.SetWindowLong(this.messageWindow, -4, new LONG(this.prevWndProc));
            }
            Kernel32.GlobalDeleteAtom(this.iAtom);
        }
        finally {
            try {
                this.destroyNativeWindow();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (NativeException nativeException) {
                nativeException.printStackTrace();
            }
            this.isRegistered = false;
            this.iAtom = 0;
            this.prevWndProc = 0;
            hotkeys.remove(this);
        }
    }

    public void setCallback(Callback callback) throws NativeException, IllegalAccessException {
        if (callback == null) {
            return;
        }
        if (this.callback != null) {
            if (this.messageWindow != null) {
                User32.SetWindowLong(this.messageWindow, -4, new LONG(this.prevWndProc));
            }
            Native.releaseCallback(this.callback);
        }
        this.callback = callback;
    }

    public int callback(long[] lArray) {
        try {
            return User32.CallWindowProc(this.getPrevWndProc(), (int)lArray[0], (int)lArray[1], (int)lArray[2], (int)lArray[3]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
    }

    public int getCallbackAddress() throws NativeException {
        if (this.myAddress == -1) {
            this.myAddress = Native.createCallback(4, this);
        }
        return this.myAddress;
    }

    public Callback getCallback() {
        return this.callback;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    Hotkey.unregisterAllHotkeys();
                }
                catch (NativeException nativeException) {
                    nativeException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
        });
    }
}

