/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.shell.listener;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WindowResizeListener
extends MouseAdapter
implements MouseTrackListener,
MouseMoveListener {
    private Control control;
    private int position;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int DOWN = 3;
    private Shell shell;
    private int minWidth;
    private int minHeight;

    public WindowResizeListener(Control control, int n) {
        this.control = control;
        this.position = n;
        this.shell = control.getShell();
    }

    public void mouseEnter(MouseEvent mouseEvent) {
        switch (this.position) {
            case 0: {
                this.control.setCursor(new Cursor((Device)Display.getDefault(), 12));
                break;
            }
            case 1: {
                this.control.setCursor(new Cursor((Device)Display.getDefault(), 13));
                break;
            }
            case 2: {
                this.control.setCursor(new Cursor((Device)Display.getDefault(), 10));
                break;
            }
            case 3: {
                this.control.setCursor(new Cursor((Device)Display.getDefault(), 11));
            }
        }
        this.control.addMouseListener((MouseListener)this);
    }

    public void mouseExit(MouseEvent mouseEvent) {
        this.control.setCursor(new Cursor((Device)Display.getDefault(), 0));
        this.control.removeMouseListener((MouseListener)this);
    }

    public void mouseHover(MouseEvent mouseEvent) {
        switch (this.position) {
            case 0: {
                this.control.setCursor(new Cursor((Device)Display.getDefault(), 12));
                break;
            }
            case 1: {
                this.control.setCursor(new Cursor((Device)Display.getDefault(), 13));
                break;
            }
            case 2: {
                this.control.setCursor(new Cursor((Device)Display.getDefault(), 10));
                break;
            }
            case 3: {
                this.control.setCursor(new Cursor((Device)Display.getDefault(), 11));
            }
        }
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button == 1) {
            this.control.addMouseMoveListener((MouseMoveListener)this);
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        Point point = this.shell.getLocation();
        Point point2 = this.shell.getSize();
        if (mouseEvent.button == 1) {
            this.control.removeMouseMoveListener((MouseMoveListener)this);
            switch (this.position) {
                case 0: {
                    if (point2.x - mouseEvent.x < this.minWidth) {
                        return;
                    }
                    this.shell.setSize(point2.x - mouseEvent.x, point2.y);
                    this.shell.setLocation(point.x + mouseEvent.x, point.y);
                    break;
                }
                case 1: {
                    if (point2.x + mouseEvent.x < this.minWidth) {
                        return;
                    }
                    this.shell.setSize(point2.x + mouseEvent.x, point2.y);
                    break;
                }
                case 2: {
                    if (point2.y - mouseEvent.y < this.minHeight) {
                        return;
                    }
                    this.shell.setSize(point2.x, point2.y - mouseEvent.y);
                    this.shell.setLocation(point.x, point.y + mouseEvent.y);
                    break;
                }
                case 3: {
                    if (point2.y + mouseEvent.y < this.minHeight) {
                        return;
                    }
                    this.shell.setSize(point2.x, point2.y + mouseEvent.y);
                }
            }
            this.handleMouseUpEvent(mouseEvent);
        }
    }

    public void handleMouseUpEvent(MouseEvent mouseEvent) {
    }

    public void mouseMove(MouseEvent mouseEvent) {
        Point point = this.shell.getLocation();
        Point point2 = this.shell.getSize();
        switch (this.position) {
            case 0: {
                if (point2.x - mouseEvent.x < this.minWidth) {
                    return;
                }
                this.shell.setSize(point2.x - mouseEvent.x, point2.y);
                this.shell.setLocation(point.x + mouseEvent.x, point.y);
                break;
            }
            case 1: {
                if (point2.x + mouseEvent.x < this.minWidth) {
                    return;
                }
                this.shell.setSize(point2.x + mouseEvent.x, point2.y);
                break;
            }
            case 2: {
                if (point2.y - mouseEvent.y < this.minHeight) {
                    return;
                }
                this.shell.setSize(point2.x, point2.y - mouseEvent.y);
                this.shell.setLocation(point.x, point.y + mouseEvent.y);
                break;
            }
            case 3: {
                if (point2.y + mouseEvent.y < this.minHeight) {
                    return;
                }
                this.shell.setSize(point2.x, point2.y + mouseEvent.y);
            }
        }
        this.handleMouseMoveEvent(mouseEvent);
    }

    public void handleMouseMoveEvent(MouseEvent mouseEvent) {
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int n) {
        this.minWidth = n > 1 ? n : 1;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeigth(int n) {
        this.minHeight = n > 1 ? n : 1;
    }
}

