/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.system;

import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.MEMORYSTATUS;

public class MemoryStatus {
    private long totalPhys;
    private long availPhys;
    private long totalPageFile;
    private long availPageFile;
    private long totalVirtual;
    private long availVirtual;
    private int memoryLoad;
    private static MemoryStatus memoryStatus = null;

    private MemoryStatus() {
    }

    public static synchronized MemoryStatus getInstance() {
        if (memoryStatus == null) {
            memoryStatus = new MemoryStatus();
            memoryStatus.refreshStatus();
        }
        return memoryStatus;
    }

    public void refreshStatus() {
        MEMORYSTATUS mEMORYSTATUS = Extension.GlobalMemoryStatus();
        MemoryStatus.memoryStatus.totalPhys = mEMORYSTATUS.ullTotalPhys;
        MemoryStatus.memoryStatus.totalVirtual = mEMORYSTATUS.ullTotalVirtual;
        MemoryStatus.memoryStatus.totalVirtual = mEMORYSTATUS.ullTotalPageFile;
        MemoryStatus.memoryStatus.availPhys = mEMORYSTATUS.ullAvailPhys;
        MemoryStatus.memoryStatus.availPageFile = mEMORYSTATUS.ullAvailPageFile;
        MemoryStatus.memoryStatus.availVirtual = mEMORYSTATUS.ullAvailVirtual;
        MemoryStatus.memoryStatus.memoryLoad = mEMORYSTATUS.dwMemoryLoad;
    }

    public long getTotalPhys() {
        return this.totalPhys;
    }

    public long getAvailPhys() {
        return this.availPhys;
    }

    public long getTotalPageFile() {
        return this.totalPageFile;
    }

    public long getAvailPageFile() {
        return this.availPageFile;
    }

    public long getTotalVirtual() {
        return this.totalVirtual;
    }

    public long getAvailVirtual() {
        return this.availVirtual;
    }

    public int getMemoryLoad() {
        return this.memoryLoad;
    }
}

