/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.system;

import org.eclipse.swt.internal.win32.OSVERSIONINFOA;
import org.eclipse.swt.internal.win32.OSVERSIONINFOW;
import org.sf.feeling.swt.win32.internal.extension.Extension;

public class OSVersionInfo {
    private int majorVersion;
    private int minorVersion;
    private int buildNumber;
    private int platformId;
    private String cSDVersion = "";
    private static OSVersionInfo versionInfo = null;

    private OSVersionInfo() {
    }

    public static synchronized OSVersionInfo getInstance() {
        if (versionInfo == null) {
            OSVERSIONINFOW oSVERSIONINFOW = new OSVERSIONINFOW();
            oSVERSIONINFOW.dwOSVersionInfoSize = OSVERSIONINFOW.sizeof;
            if (!Extension.GetVersionExW((OSVERSIONINFOW)oSVERSIONINFOW)) {
                oSVERSIONINFOW = new OSVERSIONINFOA();
                oSVERSIONINFOW.dwOSVersionInfoSize = OSVERSIONINFOA.sizeof;
                Extension.GetVersionExA((OSVERSIONINFOA)((OSVERSIONINFOA)oSVERSIONINFOW));
            }
            versionInfo = new OSVersionInfo();
            OSVersionInfo.versionInfo.buildNumber = oSVERSIONINFOW.dwBuildNumber;
            OSVersionInfo.versionInfo.majorVersion = oSVERSIONINFOW.dwMajorVersion;
            OSVersionInfo.versionInfo.minorVersion = oSVERSIONINFOW.dwMinorVersion;
            OSVersionInfo.versionInfo.platformId = oSVERSIONINFOW.dwPlatformId;
            OSVersionInfo.versionInfo.cSDVersion = oSVERSIONINFOW instanceof OSVERSIONINFOW ? new String(oSVERSIONINFOW.szCSDVersion).trim() : new String(((OSVERSIONINFOA)oSVERSIONINFOW).szCSDVersion).trim();
        }
        return versionInfo;
    }

    public int getBuildNumber() {
        int n = this.buildNumber;
        if (this.isNT()) {
            return n;
        }
        return n & 0xFFFF;
    }

    public int getMajor() {
        return this.majorVersion;
    }

    public int getMinor() {
        return this.minorVersion;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public String getServicePack() {
        return this.cSDVersion;
    }

    public boolean isWinCE() {
        return this.getPlatformId() == 3;
    }

    public boolean isNT() {
        return this.getPlatformId() == 2;
    }

    public boolean isWin95() {
        return this.getPlatformId() == 1 && this.getMajor() == 4 && this.getMinor() == 0;
    }

    public boolean isWin98() {
        return this.getPlatformId() == 1 && this.getMajor() == 4 && this.getMinor() == 10;
    }

    public boolean isWin2k() {
        return this.getMajor() == 5 && this.getMinor() == 0 && this.getPlatformId() == 2;
    }

    public boolean isWinNT4() {
        return this.getMajor() == 4 && this.getPlatformId() == 2;
    }

    public boolean isWinMe() {
        return this.getPlatformId() == 1 && this.getMajor() == 4 && this.getMinor() == 90;
    }

    public boolean isWinXP() {
        return this.getMajor() == 5 && this.getMinor() == 1 && this.getPlatformId() == 2;
    }

    public boolean isWin2003() {
        return this.getMajor() == 5 && this.getMinor() == 2 && this.getPlatformId() == 2;
    }

    public boolean isWinVista() {
        return this.getMajor() >= 6;
    }

    public String getWindowVersion() {
        String string = "";
        if (this.platformId == 2) {
            string = "Windows NT 3";
            if (this.majorVersion == 4) {
                string = "Windows NT 4";
            }
            if (this.majorVersion == 5 && this.minorVersion == 0) {
                string = "Windows 2000";
            }
            if (this.majorVersion == 5 && this.minorVersion == 1) {
                string = "Windows XP";
            }
            if (this.majorVersion == 6 && this.minorVersion == 0) {
                string = "Windows Vista";
            }
            if (this.majorVersion == 6 && this.minorVersion == 1) {
                string = "Windows 7";
            }
        } else if (this.platformId == 1) {
            string = "Windows 95";
            if (this.majorVersion == 4 && this.minorVersion == 10) {
                string = "Windows 98";
            } else if (this.majorVersion == 4 && this.minorVersion == 90) {
                string = "Windows ME";
            }
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getWindowVersion());
        stringBuffer.append(" ");
        stringBuffer.append(this.getMajor());
        stringBuffer.append(".");
        stringBuffer.append(this.getMinor());
        stringBuffer.append(" ");
        stringBuffer.append(this.getServicePack());
        return stringBuffer.toString();
    }
}

