/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.system;

import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.SYSTEMINFO;

public class SystemInfo {
    private int oemId;
    private int pageSize;
    private int minAppAddress;
    private int maxAppAddress;
    private int activeProcessorMask;
    private int numberOfProcessors;
    private int processorType;
    private int allocationGranularity;
    private static SystemInfo systemInfo = null;

    private SystemInfo() {
    }

    public static synchronized SystemInfo getInstance() {
        if (systemInfo == null) {
            SYSTEMINFO sYSTEMINFO = Extension.GetSystemInfo();
            systemInfo = new SystemInfo();
            SystemInfo.systemInfo.oemId = sYSTEMINFO.dwOemId;
            SystemInfo.systemInfo.pageSize = sYSTEMINFO.dwPageSize;
            SystemInfo.systemInfo.minAppAddress = sYSTEMINFO.lpMinimumApplicationAddress;
            SystemInfo.systemInfo.maxAppAddress = sYSTEMINFO.lpMaximumApplicationAddress;
            SystemInfo.systemInfo.activeProcessorMask = sYSTEMINFO.dwActiveProcessorMask;
            SystemInfo.systemInfo.numberOfProcessors = sYSTEMINFO.dwNumberOfProcessors;
            SystemInfo.systemInfo.processorType = sYSTEMINFO.dwProcessorType;
            SystemInfo.systemInfo.allocationGranularity = sYSTEMINFO.dwAllocationGranularity;
        }
        return systemInfo;
    }

    public int getOemId() {
        return this.oemId;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getMinAppAddress() {
        return this.minAppAddress;
    }

    public int getMaxAppAddress() {
        return this.maxAppAddress;
    }

    public int getActiveProcessorMask() {
        return this.activeProcessorMask;
    }

    public int getNumberOfProcessors() {
        return this.numberOfProcessors;
    }

    public int getProcessorType() {
        return this.processorType;
    }

    public int getAllocationGranularity() {
        return this.allocationGranularity;
    }

    public String getComputerName() {
        return Extension.GetComputerName();
    }

    public boolean setComputerName(String string) {
        if (string.getBytes().length > 31) {
            throw new UnsupportedOperationException("Compute Name length can't more than 31.");
        }
        return Extension.SetComputerName(string);
    }

    public String getUserName() {
        return Extension.GetUserName();
    }

    public static String[] getMACAddresses() {
        int[] nArray = Extension.GetMACID();
        if (nArray.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = Extension.GetMACAddress(nArray[i]);
            if (nArray2.length == 0) {
                stringArray[i] = "";
                continue;
            }
            String string = "";
            for (int j = 0; j < nArray2.length; ++j) {
                String string2 = Integer.toHexString(nArray2[j]).toUpperCase();
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                string = string + string2;
                if (j == nArray2.length - 1) continue;
                string = string + "-";
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public static int getCpuUsages() {
        return Extension.GetCpuUsages();
    }

    public static String getCPUID() {
        return Extension.GetCPUID();
    }

    public static int[] getMACID() {
        return Extension.GetMACID();
    }
}

