/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.util;

import java.io.File;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class UIUtil {
    private static ImageLoader loader;
    private static final String ELLIPSIS = "...";

    public static int GetStringWidth(Control control, String string) {
        if (control == null || string == null) {
            return 0;
        }
        GC gC = new GC((Drawable)control);
        int n = gC.stringExtent((String)string).x;
        gC.dispose();
        return n;
    }

    public static Point GetPositionAtControl(Control control, Point point) {
        if (control == null || point == null) {
            SWT.error((int)4);
            return null;
        }
        return control.toControl(point);
    }

    public static Point GetPositionAtDisplay(Control control, Point point) {
        if (control == null || point == null) {
            SWT.error((int)4);
            return null;
        }
        return control.toDisplay(point);
    }

    public static void SaveImage(ImageData imageData, File file, int n) {
        if (loader == null) {
            loader = new ImageLoader();
        }
        loader.save(file.getAbsolutePath(), n);
    }

    public static String[] getSystemFontNames() {
        return UIUtil.getSystemFontNames(null);
    }

    public static String[] getSystemFontNames(Comparator comparator) {
        int n;
        TreeSet<String> treeSet = new TreeSet<String>(comparator);
        FontData[] fontDataArray = Display.getCurrent().getFontList(null, false);
        for (n = 0; n < fontDataArray.length; ++n) {
            treeSet.add(fontDataArray[n].getName());
        }
        fontDataArray = Display.getCurrent().getFontList(null, true);
        for (n = 0; n < fontDataArray.length; ++n) {
            treeSet.add(fontDataArray[n].getName());
        }
        String[] stringArray = new String[treeSet.size()];
        treeSet.toArray(stringArray);
        return stringArray;
    }

    public static String[] getSystemFontNames(Comparator comparator, boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>(comparator);
        FontData[] fontDataArray = Display.getCurrent().getFontList(null, bl);
        for (int i = 0; i < fontDataArray.length; ++i) {
            treeSet.add(fontDataArray[i].getName());
        }
        String[] stringArray = new String[treeSet.size()];
        treeSet.toArray(stringArray);
        return stringArray;
    }

    public static String shortenText(GC gC, int n, String string, int n2) {
        String string2;
        int n3;
        if (string == null) {
            return null;
        }
        int n4 = gC.textExtent((String)ELLIPSIS, (int)n).x;
        if (n2 <= n4) {
            return string;
        }
        int n5 = string.length();
        int n6 = n5 / 2;
        int n7 = (n6 + (n3 = 0)) / 2 - 1;
        if (n7 <= 0) {
            return string;
        }
        TextLayout textLayout = new TextLayout((Device)Display.getDefault());
        textLayout.setText(string);
        n7 = UIUtil.validateOffset(textLayout, n7);
        while (n3 < n7 && n7 < n6) {
            string2 = string.substring(0, n7);
            String string3 = string.substring(UIUtil.validateOffset(textLayout, n5 - n7), n5);
            int n8 = gC.textExtent((String)string2, (int)n).x;
            int n9 = gC.textExtent((String)string3, (int)n).x;
            if (n8 + n4 + n9 > n2) {
                n6 = n7;
                n7 = UIUtil.validateOffset(textLayout, (n6 + n3) / 2);
                continue;
            }
            if (n8 + n4 + n9 < n2) {
                n3 = n7;
                n7 = UIUtil.validateOffset(textLayout, (n6 + n3) / 2);
                continue;
            }
            n3 = n6;
        }
        string2 = n7 == 0 ? string : string.substring(0, n7) + ELLIPSIS + string.substring(UIUtil.validateOffset(textLayout, n5 - n7), n5);
        textLayout.dispose();
        return string2;
    }

    private static int validateOffset(TextLayout textLayout, int n) {
        int n2 = textLayout.getNextOffset(n, 2);
        if (n2 != n) {
            return textLayout.getPreviousOffset(n2, 2);
        }
        return n;
    }
}

