/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.sf.feeling.swt.win32.extension.graphics.GraphicsUtil;
import org.sf.feeling.swt.win32.extension.widgets.CMenu;
import org.sf.feeling.swt.win32.extension.widgets.MenuControl;
import org.sf.feeling.swt.win32.extension.widgets.theme.GeneralThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.GlossyThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.OfficeThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.ThemeRender;
import org.sf.feeling.swt.win32.internal.extension.graphics.GCExtension;

public class CButton {
    private static final int SUBMENUWIDTH = 11;
    private static final int HORIZON_MARGIN = 5;
    private static final int VERTICAL_MARGIN = 2;
    private static final int DRAW_FLAGS = 7;
    private boolean menuTracked;
    private boolean selected = false;
    private boolean selection = false;
    private ThemeRender theme;
    private int style = 0;
    private static final int VERTICAL_GAP = 3;
    private static final int HORIZON_GAP = 2;
    private String text = "";
    private Image image;
    private boolean visible = true;
    private boolean enabled = true;
    private CMenu menu;
    private List listeners;
    private Canvas button;
    private MenuControl popupMenu;

    public void setTheme(ThemeRender themeRender) {
        if (this.button == null || this.button.isDisposed()) {
            return;
        }
        if (!GraphicsUtil.checkGdip() && themeRender instanceof GlossyThemeRender) {
            return;
        }
        this.theme = themeRender;
    }

    public CButton(Composite composite, int n, ThemeRender themeRender) {
        this.button = new Canvas(composite, 0){

            public Point computeSize(int n, int n2, boolean bl) {
                this.checkWidget();
                Point point = CButton.this.recalculate();
                int n3 = point.x;
                int n4 = point.y;
                if (n != -1) {
                    n3 = n;
                }
                if (n2 != -1) {
                    n4 = n2;
                }
                int n5 = this.getBorderWidth();
                return new Point(n3 += n5 * 2, n4 += n5 * 2);
            }
        };
        this.style = n;
        this.setTheme(themeRender);
        this.button.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                CButton.this.onPaint(paintEvent);
            }
        });
        this.button.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                CButton.this.handleMouseMoveEvent(new Point(mouseEvent.x, mouseEvent.y));
            }
        });
        this.button.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent mouseEvent) {
                CButton.this.menuTracked = false;
                CButton.this.selected = false;
                CButton.this.refresh();
            }
        });
        this.button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (!CButton.this.selected) {
                    CButton.this.selected = true;
                    CButton.this.refresh();
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (CButton.this.selected) {
                    if (CButton.this.isEnabled()) {
                        Event event = new Event();
                        event.widget = CButton.this.button;
                        event.data = this;
                        event.type = 2;
                        CButton.this.fireSelectionEvent(event);
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                CButton.this.refresh();
                            }
                        });
                    }
                    CButton.this.selected = false;
                    CButton.this.refresh();
                }
            }
        });
    }

    private void onPaint(PaintEvent paintEvent) {
        this.drawSingleCommand(paintEvent.gc);
    }

    public Control getControl() {
        return this.button;
    }

    private void drawSingleCommand(GC gC) {
        Color[] colorArray;
        ThemeRender themeRender;
        Rectangle rectangle = new Rectangle(1, 1, this.button.getSize().x - 2, this.button.getSize().y - 2);
        if ((this.getStyle() & 2) != 0 && this.getSelection()) {
            if (this.theme instanceof GeneralThemeRender) {
                themeRender = (GeneralThemeRender)this.theme;
                gC.setForeground(((GeneralThemeRender)themeRender).getTool_item_check_selection_bg_normal1());
                gC.setBackground(((GeneralThemeRender)themeRender).getTool_item_check_selection_bg_normal2());
                gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                gC.setForeground(((GeneralThemeRender)themeRender).getTool_item_check_selection_fg_normal());
                gC.drawRectangle(rectangle);
            } else if (this.theme instanceof OfficeThemeRender) {
                themeRender = (OfficeThemeRender)this.theme;
                colorArray = new Color[]{((OfficeThemeRender)themeRender).getTool_item_outer_top_checked1(), ((OfficeThemeRender)themeRender).getTool_item_outer_top_checked2(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_checked1(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_checked2(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_checked1(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_checked2(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_checked1(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_checked2(), ((OfficeThemeRender)themeRender).getTool_item_border_checked()};
                this.drawGradientBack(gC, rectangle, colorArray);
                this.drawGradientBorder(gC, rectangle, colorArray);
            } else if (this.theme instanceof GlossyThemeRender) {
                this.drawGlossyItem(gC, rectangle);
            }
        }
        if (this.theme instanceof GeneralThemeRender) {
            themeRender = (GeneralThemeRender)this.theme;
            if (this.selected && this.isEnabled()) {
                if (this.menuTracked || this.getMenu() != null && !this.canSelected()) {
                    gC.setForeground(((GeneralThemeRender)themeRender).getTool_item_showmenu_bg1());
                    gC.setBackground(((GeneralThemeRender)themeRender).getTool_item_showmenu_bg2());
                    gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                    gC.setForeground(((GeneralThemeRender)themeRender).getTool_item_showmenu_fg());
                    gC.drawRectangle(rectangle);
                } else {
                    gC.setForeground(((GeneralThemeRender)themeRender).getTool_item_bg_selected1());
                    gC.setBackground(((GeneralThemeRender)themeRender).getTool_item_bg_selected2());
                    if (this.getMenu() != null) {
                        colorArray = this.getNonMenuRect();
                        gC.fillGradientRectangle(colorArray.x, colorArray.y, colorArray.width, colorArray.height, true);
                        gC.setForeground(((GeneralThemeRender)themeRender).getTool_item_bg_track1());
                        gC.setBackground(((GeneralThemeRender)themeRender).getTool_item_bg_track2());
                        Rectangle rectangle2 = this.getMenuRect();
                        gC.fillGradientRectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
                    } else {
                        gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                    }
                    gC.setForeground(((GeneralThemeRender)themeRender).getTool_item_fg_selected());
                    gC.drawRectangle(rectangle);
                }
            } else if ((this.getStyle() & 2) != 0 && this.getSelection() && this.isEnabled()) {
                gC.setForeground(((GeneralThemeRender)themeRender).getTool_item_check_selection_bg_track1());
                gC.setBackground(((GeneralThemeRender)themeRender).getTool_item_check_selection_bg_track2());
                gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                gC.setForeground(((GeneralThemeRender)themeRender).getTool_item_check_selection_fg_track());
                gC.drawRectangle(rectangle);
            } else {
                gC.setForeground(((GeneralThemeRender)themeRender).getTool_item_bg_track1());
                gC.setBackground(((GeneralThemeRender)themeRender).getTool_item_bg_track2());
                gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                gC.setForeground(((GeneralThemeRender)themeRender).getTool_item_fg_track());
                gC.drawRectangle(rectangle);
            }
        } else if (this.theme instanceof OfficeThemeRender) {
            themeRender = (OfficeThemeRender)this.theme;
            colorArray = null;
            if (this.selected && this.isEnabled()) {
                if (this.menuTracked || this.getMenu() != null && !this.canSelected()) {
                    colorArray = new Color[]{((OfficeThemeRender)themeRender).getTool_item_outer_top_showmenu_color1(), ((OfficeThemeRender)themeRender).getTool_item_outer_top_showmenu_color2(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_showmenu_color1(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_showmenu_color2(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_showmenu_color1(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_showmenu_color2(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_showmenu_color1(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_showmenu_color2(), ((OfficeThemeRender)themeRender).getTool_item_border_showmenu_color()};
                    this.drawGradientBack(gC, rectangle, colorArray);
                    this.drawGradientBorder(gC, rectangle, colorArray);
                } else {
                    colorArray = new Color[]{((OfficeThemeRender)themeRender).getTool_item_outer_top_selected1(), ((OfficeThemeRender)themeRender).getTool_item_outer_top_selected2(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_selected1(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_selected2(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_selected1(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_selected2(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_selected1(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_selected2(), ((OfficeThemeRender)themeRender).getTool_item_border_selected()};
                    if (this.getMenu() != null) {
                        this.drawGradientBack(gC, this.getNonMenuRect(), colorArray);
                        colorArray = new Color[]{((OfficeThemeRender)themeRender).getTool_item_outer_top_track1(), ((OfficeThemeRender)themeRender).getTool_item_outer_top_track2(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_track1(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_track2(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_track1(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_track2(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_track1(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_track2(), ((OfficeThemeRender)themeRender).getTool_item_border_track()};
                        this.drawGradientBack(gC, this.getMenuRect(), colorArray);
                    } else {
                        this.drawGradientBack(gC, rectangle, colorArray);
                    }
                    this.drawGradientBorder(gC, rectangle, colorArray);
                }
            } else if ((this.getStyle() & 2) != 0 && this.getSelection() && this.isEnabled()) {
                colorArray = new Color[]{((OfficeThemeRender)themeRender).getTool_item_outer_top_checked_track1(), ((OfficeThemeRender)themeRender).getTool_item_outer_top_checked_track2(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_checked_track1(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_checked_track2(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_checked_track1(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_checked_track2(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_checked_track1(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_checked_track2(), ((OfficeThemeRender)themeRender).getTool_item_border_checked_track()};
                this.drawGradientBack(gC, rectangle, colorArray);
                this.drawGradientBorder(gC, rectangle, colorArray);
            } else {
                colorArray = new Color[]{((OfficeThemeRender)themeRender).getTool_item_outer_top_track1(), ((OfficeThemeRender)themeRender).getTool_item_outer_top_track2(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_track1(), ((OfficeThemeRender)themeRender).getTool_item_outer_bottom_track2(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_track1(), ((OfficeThemeRender)themeRender).getTool_item_inner_top_track2(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_track1(), ((OfficeThemeRender)themeRender).getTool_item_inner_bottom_track2(), ((OfficeThemeRender)themeRender).getTool_item_border_track()};
                this.drawGradientBack(gC, rectangle, colorArray);
                this.drawGradientBorder(gC, rectangle, colorArray);
            }
        } else if (this.theme instanceof GlossyThemeRender) {
            this.drawGlossyItem(gC, rectangle);
        }
        if (this.isEnabled()) {
            gC.setForeground(this.theme.getTool_item_fg());
        } else {
            gC.setForeground(this.theme.getTool_item_fg_disabled());
        }
        this.drawImageAndText(gC);
    }

    private void drawGradientBack(GC gC, Rectangle rectangle, Color[] colorArray) {
        gC.setAdvanced(true);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        Rectangle rectangle3 = GraphicsUtil.inflate(rectangle2, -1, -1);
        int n = rectangle3.height / 2;
        Rectangle rectangle4 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, n);
        Rectangle rectangle5 = new Rectangle(rectangle3.x, rectangle3.y + n, rectangle3.width, rectangle3.height - n);
        gC.setForeground(colorArray[0]);
        gC.setBackground(colorArray[1]);
        gC.fillGradientRectangle(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, true);
        gC.setForeground(colorArray[2]);
        gC.setBackground(colorArray[3]);
        gC.fillGradientRectangle(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height, true);
        Rectangle rectangle6 = GraphicsUtil.inflate(rectangle3, -1, -1);
        n = rectangle6.height / 2;
        rectangle4 = new Rectangle(rectangle6.x, rectangle6.y, rectangle6.width, n);
        rectangle5 = new Rectangle(rectangle6.x, rectangle6.y + n, rectangle6.width, rectangle6.height - n);
        gC.setForeground(colorArray[4]);
        gC.setBackground(colorArray[5]);
        gC.fillGradientRectangle(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, true);
        gC.setForeground(colorArray[6]);
        gC.setBackground(colorArray[7]);
        gC.fillGradientRectangle(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height, true);
        gC.setAdvanced(false);
    }

    private void drawGradientBorder(GC gC, Rectangle rectangle, Color[] colorArray) {
        if (GraphicsUtil.checkGdip()) {
            gC.setAdvanced(true);
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Path path = GraphicsUtil.createRoundPath(rectangle2, 1.2f);
            gC.setForeground(colorArray[8]);
            gC.drawPath(path);
            path.dispose();
            gC.setAdvanced(false);
        } else {
            gC.setForeground(colorArray[8]);
            gC.drawRectangle(rectangle);
        }
    }

    private void drawGlossyItem(GC gC, Rectangle rectangle) {
        GlossyThemeRender glossyThemeRender = (GlossyThemeRender)this.theme;
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Rectangle rectangle3 = GraphicsUtil.inflate(rectangle2, -1, -1);
        Rectangle rectangle4 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height / 2);
        Rectangle rectangle5 = GraphicsUtil.createRectangleFromLTRB(rectangle2.x, rectangle2.y + Math.round((float)rectangle2.height * 0.5f), rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
        gC.setBackground(glossyThemeRender.getMenu_control_item_bg_track());
        gC.fillRectangle(rectangle3);
        gC.setAntialias(1);
        Pattern pattern = new Pattern(null, 0.0f, (float)rectangle4.y, 0.0f, (float)(rectangle4.y + rectangle4.height), glossyThemeRender.getTool_item_bg_color1(), glossyThemeRender.getTool_item_bg_color1_alpha(), glossyThemeRender.getTool_item_bg_color2(), glossyThemeRender.getTool_item_bg_color2_alpha());
        Path path = new Path(null);
        path.addRectangle((float)rectangle4.x, (float)rectangle4.y, (float)rectangle4.width, (float)rectangle4.height);
        gC.setBackgroundPattern(pattern);
        gC.fillPath(path);
        path.dispose();
        path = GraphicsUtil.createRoundRectangle(rectangle2, 2);
        gC.setForeground(glossyThemeRender.getTool_item_outer_border());
        gC.drawPath(path);
        path.dispose();
        if (this.selected && (this.menuTracked || this.getMenu() != null && !this.canSelected())) {
            path = GraphicsUtil.createTopRoundRectangle(rectangle3, 2);
            gC.setBackground(glossyThemeRender.getTool_item_bg_glossy_showMenu());
            gC.fillPath(path);
            path.dispose();
            path = GraphicsUtil.createTopRoundRectangle(rectangle3, 2);
            gC.setForeground(glossyThemeRender.getTool_item_bg_glossy_showMenu());
            gC.drawPath(path);
            path.dispose();
            gC.setAdvanced(false);
            return;
        }
        if (this.selected && this.getMenu() != null) {
            pattern = new Pattern(null, 0.0f, (float)rectangle4.y, 0.0f, (float)(rectangle4.y + rectangle4.height), glossyThemeRender.getTool_item_bg_glossy_selected1(), glossyThemeRender.getTool_item_bg_glossy_selected1_alpha(), glossyThemeRender.getTool_item_bg_glossy_selected2(), glossyThemeRender.getTool_item_bg_glossy_selected2_alpha());
            Rectangle rectangle6 = this.getNonMenuRect();
            Rectangle rectangle7 = new Rectangle(rectangle3.x, rectangle3.y, rectangle6.width - 1, rectangle3.height / 2);
            path = this.createTopLeftRoundRectangle(rectangle7, 2);
            gC.setBackgroundPattern(pattern);
            gC.fillPath(path);
            path.dispose();
            pattern = new Pattern(null, 0.0f, (float)rectangle4.y, 0.0f, (float)(rectangle4.y + rectangle4.height), glossyThemeRender.getTool_item_bg_glossy_track1(), glossyThemeRender.getTool_item_bg_glossy_track1_alpha(), glossyThemeRender.getTool_item_bg_glossy_track2(), glossyThemeRender.getTool_item_bg_glossy_track2_alpha());
            Rectangle rectangle8 = this.getMenuRect();
            Rectangle rectangle9 = new Rectangle(rectangle8.x, rectangle3.y, rectangle8.width - 1, rectangle3.height / 2);
            path = this.createTopRightRoundRectangle(rectangle9, 2);
            gC.setBackgroundPattern(pattern);
            gC.fillPath(path);
            path.dispose();
            Color color = glossyThemeRender.getTool_item_inner_border_selected();
            path = CButton.createLeftRoundPath(new Rectangle(rectangle3.x, rectangle3.y, rectangle6.width - 1, rectangle3.height), 2);
            gC.setForeground(color);
            gC.drawPath(path);
            path.dispose();
            color = glossyThemeRender.getTool_item_inner_border_track();
            path = CButton.createRightRoundPath(new Rectangle(rectangle8.x, rectangle3.y, rectangle8.width, rectangle3.height), 2);
            gC.setForeground(color);
            gC.drawPath(path);
            path.dispose();
            path = GraphicsUtil.createRoundRectangle(rectangle5, 2);
            gC.setClipping(path);
            path.dispose();
            Color color2 = glossyThemeRender.getTool_item_bg_glow_track();
            path = this.createBottomRadialPath(rectangle5);
            float[] fArray = new float[2];
            float[] fArray2 = new float[4];
            path.getBounds(fArray2);
            fArray[0] = (fArray2[0] + fArray2[0] + fArray2[2]) / 2.0f;
            fArray[1] = (fArray2[1] + fArray2[1] + fArray2[3]) / 2.0f;
            GCExtension gCExtension = new GCExtension(gC);
            gCExtension.fillGradientPath(path, fArray, color2, 255, new Color[]{color2}, new int[]{0});
            path.dispose();
            gC.setClipping((Region)null);
            gC.setAdvanced(false);
            return;
        }
        pattern = !this.selected ? new Pattern(null, 0.0f, (float)rectangle4.y, 0.0f, (float)(rectangle4.y + rectangle4.height), glossyThemeRender.getTool_item_bg_glossy_track1(), glossyThemeRender.getTool_item_bg_glossy_track1_alpha(), glossyThemeRender.getTool_item_bg_glossy_track2(), glossyThemeRender.getTool_item_bg_glossy_track2_alpha()) : new Pattern(null, 0.0f, (float)rectangle4.y, 0.0f, (float)(rectangle4.y + rectangle4.height), glossyThemeRender.getTool_item_bg_glossy_selected1(), glossyThemeRender.getTool_item_bg_glossy_selected1_alpha(), glossyThemeRender.getTool_item_bg_glossy_selected2(), glossyThemeRender.getTool_item_bg_glossy_selected2_alpha());
        path = GraphicsUtil.createTopRoundRectangle(rectangle4, 2);
        gC.setBackgroundPattern(pattern);
        gC.fillPath(path);
        path.dispose();
        Color color = this.selected || (this.getStyle() & 2) != 0 && this.getSelection() ? glossyThemeRender.getTool_item_inner_border_selected() : glossyThemeRender.getTool_item_inner_border_track();
        path = GraphicsUtil.createRoundRectangle(rectangle3, 2);
        gC.setForeground(color);
        gC.drawPath(path);
        path.dispose();
        if (!this.menuTracked && (this.getMenu() == null || this.canSelected()) || !this.selected) {
            path = GraphicsUtil.createRoundRectangle(rectangle5, 2);
            gC.setClipping(path);
            path.dispose();
            Color color3 = glossyThemeRender.getTool_item_bg_glow_track();
            if ((this.getStyle() & 2) != 0 && this.getSelection()) {
                color3 = glossyThemeRender.getTool_item_bg_checked_glow_track();
            }
            path = this.createBottomRadialPath(rectangle5);
            float[] fArray = new float[2];
            float[] fArray3 = new float[4];
            path.getBounds(fArray3);
            fArray[0] = (fArray3[0] + fArray3[0] + fArray3[2]) / 2.0f;
            fArray[1] = (fArray3[1] + fArray3[1] + fArray3[3]) / 2.0f;
            GCExtension gCExtension = new GCExtension(gC);
            gCExtension.fillGradientPath(path, fArray, color3, 255, new Color[]{color3}, new int[]{0});
            path.dispose();
            gC.setClipping((Region)null);
        }
        gC.setAdvanced(false);
    }

    private Path createBottomRadialPath(Rectangle rectangle) {
        float[] fArray = new float[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        fArray[0] = fArray[0] - fArray[2] * 0.35f;
        fArray[1] = fArray[1] - fArray[3] * 0.15f;
        fArray[2] = fArray[2] * 1.7f;
        fArray[3] = fArray[3] * 2.3f;
        return GraphicsUtil.createEllipsePath(fArray);
    }

    private void drawImageAndText(GC gC) {
        int n;
        int n2;
        gC.setAdvanced(false);
        Rectangle rectangle = this.getSelectRect();
        if (this.getMenu() != null) {
            rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width - 11, rectangle.height);
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width + n3;
        int n6 = rectangle.height + n4;
        int n7 = gC.textExtent((String)this.getText(), (int)7).x;
        int n8 = gC.getFontMetrics().getHeight();
        String string = null;
        if (this.getText().length() > 0) {
            string = this.getText();
        }
        int n9 = this.image == null ? 0 : this.image.getImageData().height;
        int n10 = n2 = this.image == null ? 0 : this.image.getImageData().width;
        if (string != null && this.image != null) {
            if ((this.style & 0x80) != 0) {
                n = n3 + Math.round((float)(rectangle.width - this.image.getImageData().width) / 2.0f);
                int n11 = n4 + Math.round((float)(n9 - this.image.getImageData().height) / 2.0f);
                gC.drawImage(this.image, n, n11);
                gC.drawText(string, n3 + Math.round((float)(rectangle.width - n7) / 2.0f), n4 + n9 + 2, 7);
            } else if ((this.style & 0x400) != 0) {
                n = n3 + Math.round((float)(rectangle.width - this.image.getImageData().width) / 2.0f);
                int n12 = n6 - n9 + Math.round((float)(n9 - this.image.getImageData().height) / 2.0f);
                this.drawImage(gC, n, n12);
                gC.drawText(string, n3 + Math.round((float)(rectangle.width - n7) / 2.0f), n4 + rectangle.height - n9 - 2 - n8, 7);
            } else if ((this.style & 0x20000) != 0) {
                gC.drawText(string, n5 - n2 - 2 - n7, n4 + Math.round((float)(rectangle.height - n8) / 2.0f), 7);
                n = n5 - n2 + (n2 - this.image.getImageData().width) / 2;
                int n13 = n4 + (rectangle.height - this.image.getImageData().height) / 2;
                this.drawImage(gC, n, n13);
            } else {
                n = n3 + (n2 - this.image.getImageData().width) / 2;
                int n14 = n4 + (rectangle.height - this.image.getImageData().height) / 2;
                this.drawImage(gC, n, n14);
                gC.drawText(string, n3 + 2 + n2, n4 + Math.round((float)(rectangle.height - n8) / 2.0f), 7);
            }
        } else if (string != null) {
            gC.drawText(string, n3 + Math.round((float)(rectangle.width - n7) / 2.0f), n4 + Math.round((float)(rectangle.height - n8) / 2.0f), 7);
        } else if (this.image != null) {
            n = n3 + Math.round((float)(rectangle.width - this.image.getImageData().width) / 2.0f);
            int n15 = n4 + Math.round((float)(rectangle.height - this.image.getImageData().height) / 2.0f);
            this.drawImage(gC, n, n15);
        }
        if (this.getMenu() != null) {
            Rectangle rectangle2 = this.getMenuRect();
            gC.setAdvanced(false);
            if (this.isEnabled()) {
                gC.setBackground(this.theme.getTool_item_arrow_bg_track());
            } else {
                gC.setBackground(this.theme.getTool_item_arrow_bg_disabled());
            }
            GraphicsUtil.drawArrow(gC, rectangle2, 1024);
            if (!(this.theme instanceof OfficeThemeRender)) {
                if (this.theme instanceof GeneralThemeRender) {
                    gC.setForeground(((GeneralThemeRender)this.theme).getTool_item_check_separater_color());
                } else if (this.theme instanceof GlossyThemeRender) {
                    gC.setForeground(((GlossyThemeRender)this.theme).getTool_item_check_separater_color());
                }
                gC.drawLine(rectangle2.x, rectangle2.y + 1, rectangle2.x, rectangle2.y + rectangle2.height - 1);
            } else if (!this.selected) {
                gC.setForeground(((OfficeThemeRender)this.theme).getTool_item_check_separater_drakcolor());
                gC.drawLine(rectangle2.x, rectangle2.y + 1, rectangle2.x, rectangle2.y + rectangle2.height - 1);
                gC.setForeground(((OfficeThemeRender)this.theme).getTool_item_check_separater_lightcolor());
                gC.drawLine(rectangle2.x + 1, rectangle2.y + 1, rectangle2.x + 1, rectangle2.y + rectangle2.height - 1);
            }
        }
    }

    private Rectangle getSelectRect() {
        Rectangle rectangle = new Rectangle(1, 1, this.button.getSize().x - 1, this.button.getSize().y - 1);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle2.height -= 5;
        rectangle2.width -= 3;
        rectangle2.x += 2;
        rectangle2.y += 3;
        return rectangle2;
    }

    private Rectangle getMenuRect() {
        Rectangle rectangle = new Rectangle(1, 1, this.button.getSize().x - 2, this.button.getSize().y - 2);
        int n = this.getSelectRect().x + this.getSelectRect().width - 11;
        int n2 = rectangle.x + rectangle.width;
        Rectangle rectangle2 = new Rectangle(n, rectangle.y, n2 - n, rectangle.height);
        return rectangle2;
    }

    private Rectangle getNonMenuRect() {
        Rectangle rectangle = new Rectangle(1, 1, this.button.getSize().x - 2, this.button.getSize().y - 2);
        int n = rectangle.x;
        int n2 = this.getSelectRect().x + this.getSelectRect().width + 3 - 11;
        Rectangle rectangle2 = new Rectangle(n, rectangle.y, n2 - n, rectangle.height);
        return rectangle2;
    }

    private void drawImage(GC gC, int n, int n2) {
        if (this.image != null) {
            if (this.isEnabled()) {
                if (!this.selected && this.theme.isShowToolImageShadow() && GraphicsUtil.checkGdip()) {
                    ImageData imageData = this.image.getImageData();
                    PaletteData paletteData = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(154, 156, 146)});
                    ImageData imageData2 = new ImageData(imageData.width, imageData.height, 1, paletteData);
                    imageData2.transparentPixel = imageData.transparentPixel;
                    if (imageData.getTransparencyType() == 4) {
                        for (int i = 0; i < imageData.width; ++i) {
                            for (int j = 0; j < imageData.width; ++j) {
                                int n3 = imageData.getPixel(i, j);
                                if (n3 != imageData.transparentPixel) {
                                    imageData2.setPixel(i, j, 1);
                                    continue;
                                }
                                imageData2.setPixel(i, j, 0);
                            }
                        }
                        gC.setAdvanced(true);
                        Image image = new Image(gC.getDevice(), imageData2);
                        gC.drawImage(image, n + 1, n2 + 1);
                        image.dispose();
                        gC.setAdvanced(false);
                        gC.drawImage(this.image, n - 1, n2 - 1);
                    } else {
                        gC.drawImage(this.image, n, n2);
                    }
                } else if (GraphicsUtil.checkGdip() && this.theme.isShowToolImageShadow()) {
                    RGB[] rGBArray = this.image.getImageData().palette.getRGBs();
                    if (rGBArray != null) {
                        RGB rGB;
                        for (int i = 0; i < rGBArray.length; ++i) {
                            rGB = rGBArray[i];
                            rGB.red = rGB.red + 76 - (rGB.red + 32) / 64 * 19;
                            rGB.green = rGB.green + 76 - (rGB.green + 32) / 64 * 19;
                            rGB.blue = rGB.blue + 76 - (rGB.blue + 32) / 64 * 19;
                        }
                        ImageData imageData = this.image.getImageData();
                        rGB = new ImageData(imageData.width, imageData.height, imageData.depth, new PaletteData(rGBArray));
                        rGB.transparentPixel = imageData.transparentPixel;
                        for (int i = 0; i < imageData.width; ++i) {
                            for (int j = 0; j < imageData.width; ++j) {
                                int n4 = imageData.getPixel(i, j);
                                if (n4 != imageData.transparentPixel) {
                                    rGB.setPixel(i, j, n4);
                                    continue;
                                }
                                rGB.setPixel(i, j, imageData.transparentPixel);
                            }
                        }
                        Image image = new Image(null, (ImageData)rGB);
                        gC.drawImage(image, n, n2);
                        image.dispose();
                    }
                } else {
                    gC.drawImage(this.image, n, n2);
                }
            }
        } else {
            Image image = new Image(null, this.image, 1);
            gC.drawImage(image, n, n2);
            image.dispose();
        }
    }

    private Path createTopLeftRoundRectangle(Rectangle rectangle, int n) {
        Path path = new Path(null);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n << 1;
        path.addArc((float)n2, (float)n3, (float)n6, (float)n6, -180.0f, -90.0f);
        path.lineTo((float)(n2 + n), (float)n3);
        path.lineTo((float)(n2 + n4), (float)n3);
        path.lineTo((float)(n2 + n4), (float)(n3 + n5));
        path.lineTo((float)n2, (float)(n3 + n5));
        path.lineTo((float)n2, (float)(n3 + n));
        path.close();
        return path;
    }

    private Path createTopRightRoundRectangle(Rectangle rectangle, int n) {
        Path path = new Path(null);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n << 1;
        path.moveTo((float)n2, (float)n3);
        path.lineTo((float)(n2 + n4 - n), (float)n3);
        path.addArc((float)(n2 + n4 - n6), (float)n3, (float)n6, (float)n6, -270.0f, -90.0f);
        path.lineTo((float)(n2 + n4), (float)(n3 + n));
        path.lineTo((float)(n2 + n4), (float)(n3 + n5));
        path.lineTo((float)n2, (float)(n3 + n5));
        path.lineTo((float)n2, (float)n3);
        path.close();
        return path;
    }

    public static Path createLeftRoundPath(Rectangle rectangle, int n) {
        Path path = new Path(null);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n << 1;
        path.moveTo((float)(n2 + n4), (float)n3);
        path.lineTo((float)(n2 + n), (float)n3);
        path.addArc((float)n2, (float)n3, (float)n6, (float)n6, 90.0f, 90.0f);
        path.lineTo((float)n2, (float)(n3 + n));
        path.lineTo((float)n2, (float)(n3 + n5 - n));
        path.addArc((float)n2, (float)(n3 + n5 - n6), (float)n6, (float)n6, 180.0f, 90.0f);
        path.lineTo((float)(n2 + n), (float)(n3 + n5));
        path.lineTo((float)(n2 + n4), (float)(n3 + n5));
        return path;
    }

    public static Path createRightRoundPath(Rectangle rectangle, int n) {
        Path path = new Path(null);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n << 1;
        path.moveTo((float)n2, (float)n3);
        path.lineTo((float)(n2 + n4 - n), (float)n3);
        path.addArc((float)(n2 + n4 - n6), (float)n3, (float)n6, (float)n6, -270.0f, -90.0f);
        path.lineTo((float)(n2 + n4), (float)(n3 + n));
        path.lineTo((float)(n2 + n4), (float)(n3 + n5 - n));
        path.addArc((float)(n2 + n4 - n6), (float)(n3 + n5 - n6), (float)n6, (float)n6, 0.0f, -90.0f);
        path.lineTo((float)(n2 + n4 - n), (float)(n3 + n5));
        path.lineTo((float)n2, (float)(n3 + n5));
        return path;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string == null ? "" : string;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.refresh();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setMenu(CMenu cMenu) {
        this.menu = cMenu;
    }

    public CMenu getMenu() {
        return this.menu;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean getSelection() {
        return this.selection;
    }

    public void setSelection(boolean bl) {
        this.selection = bl;
    }

    public boolean canSelected() {
        if (this.getMenu() == null) {
            return true;
        }
        return this.listeners != null;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (this.button.isDisposed()) {
            return;
        }
        if (selectionListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(selectionListener)) {
            this.listeners.add(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.button.isDisposed()) {
            return;
        }
        if (selectionListener == null) {
            return;
        }
        this.listeners.remove(selectionListener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    void fireSelectionEvent(Event event) {
        if (this.button.isDisposed()) {
            return;
        }
        if (this.listeners != null) {
            final SelectionEvent selectionEvent = new SelectionEvent(event);
            for (int i = 0; i < this.listeners.size(); ++i) {
                final SelectionListener selectionListener = (SelectionListener)this.listeners.get(i);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        selectionListener.widgetSelected(selectionEvent);
                    }
                });
            }
        }
    }

    public void disposed() {
        this.listeners.clear();
        this.listeners = null;
        this.button.dispose();
    }

    public boolean isDisposed() {
        return this.button.isDisposed();
    }

    private Point recalculate() {
        GC gC = new GC((Drawable)this.button);
        int n = gC.getFontMetrics().getHeight() / 3 + 1;
        int n2 = gC.getFontMetrics().getHeight() + n * 2;
        if ((this.style & 0x80) != 0 || (this.style & 0x400) != 0) {
            if (this.image != null) {
                n2 += this.image.getImageData().height;
            }
            n2 += 4;
        } else if (this.image != null) {
            n2 = this.image.getImageData().height > n2 ? this.image.getImageData().height : n2;
        }
        int n3 = 0;
        int n4 = 10;
        if (this.getText() == null) {
            n3 = n4;
            if (this.image != null) {
                n3 += this.image.getImageData().width;
            }
        } else if (this.image == null) {
            n3 = n4 + gC.textExtent((String)this.getText(), (int)7).x;
        } else if ((this.style & 0x80) == 0 && (this.style & 0x400) == 0) {
            n3 = n4 + gC.textExtent((String)this.getText(), (int)7).x + 5;
            if (this.image != null) {
                n3 += this.image.getImageData().width;
            }
        } else {
            n3 = gC.textExtent((String)this.getText(), (int)7).x;
            n3 = n3 < this.image.getImageData().width ? this.image.getImageData().width : n3;
            n3 += n4;
        }
        if (this.getMenu() != null) {
            n3 += 11;
        }
        gC.dispose();
        return new Point(n3, n2);
    }

    public void setLayoutData(Object object) {
        this.button.setLayoutData(object);
    }

    public Object getLayoutData() {
        return this.button.getLayoutData();
    }

    private boolean isShowMenu() {
        return this.popupMenu != null && this.popupMenu.getShell() != null && !this.popupMenu.getShell().isDisposed();
    }

    public void refresh() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.redraw();
        }
    }

    private void handleMouseMoveEvent(Point point) {
        if (!new Rectangle(0, 0, this.getBounds().width, this.getBounds().height).contains(point)) {
            if (this.menuTracked || this.selected) {
                this.menuTracked = false;
                this.selected = false;
                this.refresh();
            }
        } else if (!this.isShowMenu() && this.getMenu() != null) {
            if (this.getMenuRect().contains(point)) {
                if (!this.menuTracked) {
                    this.menuTracked = true;
                    this.refresh();
                }
            } else if (this.menuTracked) {
                this.menuTracked = false;
                this.refresh();
            }
        }
    }

    public void setLocation(Point point) {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setLocation(point);
        }
    }

    public void setSize(Point point) {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setSize(point);
        }
    }

    public void setBounds(Rectangle rectangle) {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setBounds(rectangle);
        }
    }

    public Point getLocation() {
        if (this.button != null && !this.button.isDisposed()) {
            return this.button.getLocation();
        }
        return null;
    }

    public Point getSize() {
        if (this.button != null && !this.button.isDisposed()) {
            return this.button.getSize();
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.button != null && !this.button.isDisposed()) {
            return this.button.getBounds();
        }
        return null;
    }

    public Point computeSize(int n, int n2) {
        if (this.button != null && !this.button.isDisposed()) {
            return this.button.computeSize(n, n2);
        }
        return null;
    }
}

