/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.swt.win32.extension.graphics.GraphicsUtil;
import org.sf.feeling.swt.win32.extension.widgets.Bar;
import org.sf.feeling.swt.win32.extension.widgets.CMenu;
import org.sf.feeling.swt.win32.extension.widgets.CToolItem;
import org.sf.feeling.swt.win32.extension.widgets.MenuControl;
import org.sf.feeling.swt.win32.extension.widgets.MenuHolder;
import org.sf.feeling.swt.win32.extension.widgets.MenuHolderManager;
import org.sf.feeling.swt.win32.extension.widgets.ToolDrawCommand;
import org.sf.feeling.swt.win32.extension.widgets.ToolMenuControl;
import org.sf.feeling.swt.win32.extension.widgets.theme.GeneralThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.GlossyThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.OfficeThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.ThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.VS2005ThemeRender;
import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.graphics.GCExtension;

public class CToolBar
implements MenuHolder,
Bar {
    private static final int KEY_LEFT = 0x1000003;
    private static final int KEY_RIGHT = 0x1000004;
    private static final int KEY_DOWN = 0x1000002;
    private static final int KEY_UP = 0x1000001;
    private static final int SUBMENUWIDTH = 11;
    private static final int CHEVRON_LENGTH = 12;
    private static final int HORIZON_GAP = 4;
    private static final int HORIZON_MARGIN = 2;
    private static final int VERTICAL_MARGIN = 1;
    private static final int SEPARATOR_WIDTH = 4;
    private static final int SHADOW_GAP = 4;
    private static final int VERTICAL_GAP = 3;
    private CToolItem chevronStartItem;
    private List drawCommands = new ArrayList();
    private boolean drawUpwards;
    private GridLayout layout;
    private CLabel toolbar;
    private MenuControl popupMenu;
    private boolean selected = false;
    private int style = 0;
    private ThemeRender theme;
    private int trackItemIndex = -1;
    private static final int IMAGE_MIN_WIDTH = 16;
    private static final int IMAGE_MIN_HEIGHT = 16;
    private int imageWidth = 16;
    private int imageHeight = 16;
    public static final int LARGE_ICON = 8192;
    public static final int SMALL_ICON = 16384;
    private static final int DRAW_FLAGS = 7;
    private boolean menuTracked;
    private List listeners;
    private boolean isFocusControl = false;
    private boolean hasText = false;
    private Callback mouseCallback;
    private int newAddress;
    private int oldAddress;
    private List items = new ArrayList();

    public CToolBar(Composite composite, int n) {
        this(composite, n, new VS2005ThemeRender());
    }

    public CToolBar(Composite composite, int n, ThemeRender themeRender) {
        this.toolbar = new CLabel(composite, 0){

            public Point computeSize(int n, int n2, boolean bl) {
                if (this.isVisible()) {
                    Rectangle rectangle = CToolBar.this.recalculate();
                    return new Point(rectangle.width, rectangle.height);
                }
                return super.computeSize(n, n2, bl);
            }
        };
        this.style = n;
        this.layout = new GridLayout();
        this.layout.marginHeight = 0;
        this.layout.marginWidth = 0;
        this.layout.horizontalSpacing = 0;
        this.setTheme(themeRender);
        this.toolbar.setLayout((Layout)this.layout);
        this.toolbar.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                CToolBar.this.onPaint(paintEvent);
            }
        });
        this.toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                CToolBar.this.hideCurrentMenu();
            }
        });
        ShellListener shellListener = new ShellListener(){

            public void shellClosed(ShellEvent shellEvent) {
                CToolBar.this.hideCurrentMenu();
            }

            public void shellDeactivated(ShellEvent shellEvent) {
                CToolBar.this.hideCurrentMenu();
            }

            public void shellIconified(ShellEvent shellEvent) {
                CToolBar.this.hideCurrentMenu();
            }

            public void shellActivated(ShellEvent shellEvent) {
                CToolBar.this.hideCurrentMenu();
            }

            public void shellDeiconified(ShellEvent shellEvent) {
                CToolBar.this.hideCurrentMenu();
            }
        };
        this.toolbar.getShell().addShellListener(shellListener);
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (CToolBar.this.getShell() == null || CToolBar.this.getShell().isDisposed()) {
                    Display.getDefault().removeFilter(3, (Listener)this);
                    return;
                }
                if (event.widget == null || event.widget.isDisposed() || CToolBar.this.checkMouseDownEvent(((Control)event.widget).toDisplay(event.x, event.y))) {
                    CToolBar.this.checkMouseDownEvent(((Control)event.widget).toDisplay(event.x, event.y));
                    CToolBar.this.hideCurrentMenu();
                }
            }
        };
        Display.getDefault().addFilter(3, listener);
        final Listener listener2 = new Listener(){

            public void handleEvent(Event event) {
                if (CToolBar.this.toolbar == null || CToolBar.this.toolbar.isDisposed()) {
                    Display.getDefault().removeFilter(1, (Listener)this);
                    event.doit = false;
                    return;
                }
                KeyEvent keyEvent = new KeyEvent(event);
                if (keyEvent.keyCode == 65536 || keyEvent.keyCode == 0x1000013) {
                    CToolBar.this.hideCurrentMenu();
                    return;
                }
                if (CToolBar.this.getCurrentMenu() == null) {
                    return;
                }
                CToolBar.this.getCurrentMenu().dealAltKeyEvent(keyEvent);
                if (keyEvent.keyCode == 0x1000004 && CToolBar.this.trackItemIndex > -1) {
                    CToolBar.this.getCurrentMenu().subMenuSelected();
                }
                if (keyEvent.keyCode == 0x1000003 && CToolBar.this.trackItemIndex > -1) {
                    CToolBar.this.getCurrentMenu().parentMenuSelected();
                }
                if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001) {
                    if (keyEvent.keyCode == 0x1000002) {
                        CToolBar.this.getCurrentMenu().downSelected();
                    } else {
                        CToolBar.this.getCurrentMenu().upSelected();
                    }
                }
                if (keyEvent.keyCode == 27) {
                    if (CToolBar.this.getCurrentMenu().parentMenu == null) {
                        CToolBar.this.hideCurrentMenu();
                        CToolBar.this.selected = false;
                        CToolBar.this.refresh();
                    } else {
                        CToolBar.this.getCurrentMenu().parentMenuSelected();
                    }
                }
                if (keyEvent.keyCode == 13) {
                    CToolBar.this.getCurrentMenu().handleSelectedEvent();
                }
            }
        };
        Display.getDefault().addFilter(1, listener2);
        this.toolbar.addKeyListener((KeyListener)new KeyAdapter(){});
        this.toolbar.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                CToolBar.this.setFocusControl(true);
                CToolBar.this.trackItemIndex = CToolBar.this.calculateNextTraverseIndex(CToolBar.this.trackItemIndex, true);
                CToolBar.this.drawCommand(CToolBar.this.trackItemIndex, true);
            }

            public void focusLost(FocusEvent focusEvent) {
                CToolBar.this.setFocusControl(false);
                CToolBar.this.hideCurrentMenu();
                CToolBar.this.selected = false;
                CToolBar.this.refresh();
                CToolBar.this.trackItemIndex = -1;
            }
        });
        this.toolbar.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (CToolBar.this.isShowMenu() && CToolBar.this.popupMenu instanceof ToolMenuControl) {
                    if (traverseEvent.detail != 2) {
                        traverseEvent.doit = false;
                    } else if (((ToolMenuControl)((CToolBar)CToolBar.this).popupMenu).toolbar.getCurrentMenu() == null) {
                        CToolBar.this.popupMenu.hideMenu();
                        CToolBar.this.popupMenu = null;
                        CToolBar.this.selected = false;
                        CToolBar.this.refresh();
                    }
                    return;
                }
                switch (traverseEvent.detail) {
                    case 256: 
                    case 512: {
                        traverseEvent.doit = false;
                        return;
                    }
                }
                if (traverseEvent.detail == 32 || traverseEvent.detail == 64) {
                    if (traverseEvent.detail == 32 && traverseEvent.keyCode == 0x1000003) {
                        if (CToolBar.this.isShowMenu()) {
                            CToolBar.this.popupMenu.hideMenu();
                            CToolBar.this.popupMenu = null;
                            CToolBar.this.selected = false;
                        }
                        CToolBar.this.selected = false;
                        CToolBar.this.menuTracked = false;
                        CToolBar.this.refresh();
                        CToolBar.this.trackItemIndex = CToolBar.this.calculateNextTraverseIndex(CToolBar.this.trackItemIndex, false);
                    } else if (traverseEvent.detail == 64 && traverseEvent.keyCode == 0x1000004) {
                        if (CToolBar.this.isShowMenu()) {
                            CToolBar.this.popupMenu.hideMenu();
                            CToolBar.this.popupMenu = null;
                            CToolBar.this.selected = false;
                        }
                        CToolBar.this.selected = false;
                        CToolBar.this.menuTracked = false;
                        CToolBar.this.refresh();
                        CToolBar.this.trackItemIndex = CToolBar.this.calculateNextTraverseIndex(CToolBar.this.trackItemIndex, true);
                    } else if (!CToolBar.this.isShowMenu() && CToolBar.this.trackItemIndex > -1) {
                        ToolDrawCommand toolDrawCommand = (ToolDrawCommand)CToolBar.this.drawCommands.get(CToolBar.this.trackItemIndex);
                        CToolItem cToolItem = toolDrawCommand.getToolItem();
                        if (cToolItem == null || !cToolItem.canSelected()) {
                            CToolBar.this.showMenu(toolDrawCommand);
                            CToolBar.this.selected = true;
                        } else if (cToolItem.canSelected() && cToolItem.getMenu() != null) {
                            CToolBar.this.showMenu(toolDrawCommand);
                            CToolBar.this.selected = true;
                            CToolBar.this.menuTracked = true;
                        }
                        CToolBar.this.refresh();
                    }
                } else if (traverseEvent.detail == 4 && CToolBar.this.trackItemIndex > -1 && !CToolBar.this.menuTracked) {
                    ToolDrawCommand toolDrawCommand = (ToolDrawCommand)CToolBar.this.drawCommands.get(CToolBar.this.trackItemIndex);
                    CToolItem cToolItem = toolDrawCommand.getToolItem();
                    Event event = new Event();
                    event.widget = CToolBar.this.toolbar;
                    event.data = cToolItem;
                    event.type = 2;
                    CToolBar.this.getItem(CToolBar.this.trackItemIndex).fireSelectionEvent(new SelectionEvent(event));
                    CToolBar.this.fireSelectionEvent(event);
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            CToolBar.this.refresh();
                        }
                    });
                } else {
                    traverseEvent.doit = true;
                }
            }
        });
        this.toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Display.getDefault().removeFilter(3, listener);
                Display.getDefault().removeFilter(1, listener2);
            }
        });
        this.toolbar.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                CToolBar.this.handleMouseMoveEvent(new Point(mouseEvent.x, mouseEvent.y));
            }
        });
        this.toolbar.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent mouseEvent) {
                CToolBar.this.handleMouseMoveEvent(new Point(mouseEvent.x, mouseEvent.y));
            }
        });
        this.toolbar.addMouseListener((MouseListener)new MouseAdapter(){
            private boolean hideCurrentMenuCommand = false;

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button != 1) {
                    return;
                }
                for (int i = 0; i < CToolBar.this.drawCommands.size(); ++i) {
                    ToolDrawCommand toolDrawCommand = (ToolDrawCommand)CToolBar.this.drawCommands.get(i);
                    if (!toolDrawCommand.getDrawRect().contains(mouseEvent.x, mouseEvent.y) || toolDrawCommand.getToolItem() != null && !toolDrawCommand.getToolItem().isEnabled()) continue;
                    if (!CToolBar.this.selected && !CToolBar.this.isShowMenu()) {
                        CToolBar.this.selected = true;
                        CToolBar.this.refresh();
                        CToolBar.this.trackItemIndex = i;
                        CToolBar.this.refresh();
                        CToolItem cToolItem = toolDrawCommand.getToolItem();
                        if (cToolItem != null && cToolItem.getMenu() != null && CToolBar.this.getMenuRect(toolDrawCommand).contains(mouseEvent.x, mouseEvent.y)) {
                            CToolBar.this.menuTracked = true;
                            CToolBar.this.drawCommand(CToolBar.this.trackItemIndex, true);
                            CToolBar.this.showMenu(toolDrawCommand);
                        } else {
                            CToolBar.this.menuTracked = false;
                            CToolBar.this.drawCommand(CToolBar.this.trackItemIndex, true);
                            if (cToolItem == null || !cToolItem.canSelected()) {
                                CToolBar.this.showMenu(toolDrawCommand);
                            }
                        }
                    } else {
                        this.hideCurrentMenuCommand = true;
                    }
                    return;
                }
                CToolBar.this.selected = false;
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (CToolBar.this.isShowMenu()) {
                    if (this.hideCurrentMenuCommand) {
                        this.hideCurrentMenuCommand = false;
                        CToolBar.this.popupMenu.hideMenu();
                        CToolBar.this.popupMenu = null;
                        CToolBar.this.selected = false;
                        CToolBar.this.refresh();
                    }
                } else {
                    CToolBar.this.selected = false;
                    if (CToolBar.this.trackItemIndex >= 0 && mouseEvent.button == 1) {
                        CToolBar.this.drawCommand(CToolBar.this.trackItemIndex, true);
                        CToolItem cToolItem = ((ToolDrawCommand)CToolBar.this.drawCommands.get(CToolBar.this.trackItemIndex)).getToolItem();
                        if (cToolItem != null && cToolItem.isEnabled()) {
                            Event event = new Event();
                            event.widget = CToolBar.this.toolbar;
                            event.data = cToolItem;
                            event.type = 2;
                            CToolBar.this.getItem(CToolBar.this.trackItemIndex).fireSelectionEvent(new SelectionEvent(event));
                            CToolBar.this.fireSelectionEvent(event);
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    CToolBar.this.refresh();
                                }
                            });
                        }
                    }
                    CToolBar.this.refresh();
                }
            }
        });
        MenuHolderManager.registerHolder(this);
    }

    private int calculateNextTraverseIndex(int n, boolean bl) {
        if (bl) {
            ToolDrawCommand toolDrawCommand;
            int n2;
            for (n2 = n + 1; n2 < this.drawCommands.size(); ++n2) {
                toolDrawCommand = (ToolDrawCommand)this.drawCommands.get(n2);
                if (!toolDrawCommand.isEnabled() || toolDrawCommand.isSeparator()) continue;
                return n2;
            }
            for (n2 = 0; n2 < n; ++n2) {
                toolDrawCommand = (ToolDrawCommand)this.drawCommands.get(n2);
                if (!toolDrawCommand.isEnabled() || toolDrawCommand.isSeparator()) continue;
                return n2;
            }
        } else {
            ToolDrawCommand toolDrawCommand;
            int n3;
            for (n3 = n - 1; n3 >= 0; --n3) {
                toolDrawCommand = (ToolDrawCommand)this.drawCommands.get(n3);
                if (!toolDrawCommand.isEnabled() || toolDrawCommand.isSeparator()) continue;
                return n3;
            }
            for (n3 = this.drawCommands.size() - 1; n3 > n; --n3) {
                toolDrawCommand = (ToolDrawCommand)this.drawCommands.get(n3);
                if (!toolDrawCommand.isEnabled() || toolDrawCommand.isSeparator()) continue;
                return n3;
            }
        }
        return -1;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (this.toolbar.isDisposed()) {
            return;
        }
        if (selectionListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(selectionListener)) {
            this.listeners.add(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.toolbar.isDisposed()) {
            return;
        }
        if (selectionListener == null) {
            return;
        }
        this.listeners.remove(selectionListener);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    void fireSelectionEvent(Event event) {
        if (this.toolbar.isDisposed()) {
            return;
        }
        if (this.listeners != null) {
            final SelectionEvent selectionEvent = new SelectionEvent(event);
            for (int i = 0; i < this.listeners.size(); ++i) {
                final SelectionListener selectionListener = (SelectionListener)this.listeners.get(i);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        selectionListener.widgetSelected(selectionEvent);
                    }
                });
            }
        }
    }

    public boolean checkMouseDownEvent(Point point) {
        if (this.toolbar.isDisposed()) {
            return true;
        }
        if (new Rectangle(0, 0, this.toolbar.getSize().x, this.toolbar.getSize().y).contains(this.toolbar.toControl(point))) {
            for (int i = 0; i < this.drawCommands.size(); ++i) {
                ToolDrawCommand toolDrawCommand = (ToolDrawCommand)this.drawCommands.get(i);
                if (!toolDrawCommand.getDrawRect().contains(this.toolbar.toControl(point))) continue;
                return false;
            }
            return true;
        }
        if (this.popupMenu != null) {
            return this.popupMenu.checkMouseDownEvent(point);
        }
        return true;
    }

    private void drawAllCommands(GC gC) {
        for (int i = 0; i < this.drawCommands.size(); ++i) {
            ToolDrawCommand toolDrawCommand = (ToolDrawCommand)this.drawCommands.get(i);
            this.drawSingleCommand(gC, toolDrawCommand, i == this.trackItemIndex);
        }
    }

    private void drawCommand(int n, boolean bl) {
        if (n < 0 || n >= this.drawCommands.size()) {
            return;
        }
        GC gC = new GC((Drawable)this.toolbar);
        this.drawSingleCommand(gC, (ToolDrawCommand)this.drawCommands.get(n), bl);
        gC.dispose();
    }

    public void drawSelectionUpwards() {
        if (this.trackItemIndex != -1 && this.selected) {
            this.drawUpwards = true;
            this.drawCommand(this.trackItemIndex, true);
        }
    }

    private void drawSingleCommand(GC gC, ToolDrawCommand toolDrawCommand, boolean bl) {
        Rectangle rectangle = toolDrawCommand.getDrawRect();
        CToolItem cToolItem = toolDrawCommand.getToolItem();
        if (!toolDrawCommand.isSeparator()) {
            Object object;
            if (toolDrawCommand.isEnabled()) {
                Color[] colorArray;
                if (bl) {
                    if (this.theme instanceof GeneralThemeRender) {
                        object = (GeneralThemeRender)this.theme;
                        if (this.selected) {
                            if (cToolItem == null) {
                                gC.setForeground(((GeneralThemeRender)object).getTool_item_bg_selected1());
                                gC.setBackground(((GeneralThemeRender)object).getTool_item_bg_selected2());
                                gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                                gC.setForeground(((GeneralThemeRender)object).getTool_item_fg_selected());
                                gC.drawRectangle(rectangle);
                            } else if (this.menuTracked || cToolItem.getMenu() != null && !cToolItem.canSelected()) {
                                gC.setForeground(((GeneralThemeRender)object).getTool_item_showmenu_bg1());
                                gC.setBackground(((GeneralThemeRender)object).getTool_item_showmenu_bg2());
                                gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                                gC.setForeground(((GeneralThemeRender)object).getTool_item_showmenu_fg());
                                gC.drawRectangle(rectangle);
                            } else {
                                gC.setForeground(((GeneralThemeRender)object).getTool_item_bg_selected1());
                                gC.setBackground(((GeneralThemeRender)object).getTool_item_bg_selected2());
                                if (cToolItem.getMenu() != null) {
                                    colorArray = this.getNonMenuRect(toolDrawCommand);
                                    gC.fillGradientRectangle(colorArray.x, colorArray.y, colorArray.width, colorArray.height, true);
                                    gC.setForeground(((GeneralThemeRender)object).getTool_item_bg_track1());
                                    gC.setBackground(((GeneralThemeRender)object).getTool_item_bg_track2());
                                    Rectangle rectangle2 = this.getMenuRect(toolDrawCommand);
                                    gC.fillGradientRectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
                                } else {
                                    gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                                }
                                gC.setForeground(((GeneralThemeRender)object).getTool_item_fg_selected());
                                gC.drawRectangle(rectangle);
                            }
                        } else if (cToolItem != null && (cToolItem.getStyle() & 0x20) != 0 && cToolItem.getSelection()) {
                            gC.setForeground(((GeneralThemeRender)object).getTool_item_check_selection_bg_track1());
                            gC.setBackground(((GeneralThemeRender)object).getTool_item_check_selection_bg_track2());
                            gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                            gC.setForeground(((GeneralThemeRender)object).getTool_item_check_selection_fg_track());
                            gC.drawRectangle(rectangle);
                        } else {
                            gC.setForeground(((GeneralThemeRender)object).getTool_item_bg_track1());
                            gC.setBackground(((GeneralThemeRender)object).getTool_item_bg_track2());
                            gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                            gC.setForeground(((GeneralThemeRender)object).getTool_item_fg_track());
                            gC.drawRectangle(rectangle);
                        }
                    } else if (this.theme instanceof OfficeThemeRender) {
                        object = (OfficeThemeRender)this.theme;
                        colorArray = null;
                        if (this.selected) {
                            if (cToolItem == null) {
                                colorArray = new Color[]{((OfficeThemeRender)object).getTool_item_outer_top_selected1(), ((OfficeThemeRender)object).getTool_item_outer_top_selected2(), ((OfficeThemeRender)object).getTool_item_outer_bottom_selected1(), ((OfficeThemeRender)object).getTool_item_outer_bottom_selected2(), ((OfficeThemeRender)object).getTool_item_inner_top_selected1(), ((OfficeThemeRender)object).getTool_item_inner_top_selected2(), ((OfficeThemeRender)object).getTool_item_inner_bottom_selected1(), ((OfficeThemeRender)object).getTool_item_inner_bottom_selected2(), ((OfficeThemeRender)object).getTool_item_border_selected()};
                                this.drawGradientBack(gC, rectangle, colorArray);
                                this.drawGradientBorder(gC, rectangle, colorArray);
                            } else if (this.menuTracked || cToolItem.getMenu() != null && !cToolItem.canSelected()) {
                                colorArray = new Color[]{((OfficeThemeRender)object).getTool_item_outer_top_showmenu_color1(), ((OfficeThemeRender)object).getTool_item_outer_top_showmenu_color2(), ((OfficeThemeRender)object).getTool_item_outer_bottom_showmenu_color1(), ((OfficeThemeRender)object).getTool_item_outer_bottom_showmenu_color2(), ((OfficeThemeRender)object).getTool_item_inner_top_showmenu_color1(), ((OfficeThemeRender)object).getTool_item_inner_top_showmenu_color2(), ((OfficeThemeRender)object).getTool_item_inner_bottom_showmenu_color1(), ((OfficeThemeRender)object).getTool_item_inner_bottom_showmenu_color2(), ((OfficeThemeRender)object).getTool_item_border_showmenu_color()};
                                this.drawGradientBack(gC, rectangle, colorArray);
                                this.drawGradientBorder(gC, rectangle, colorArray);
                            } else {
                                colorArray = new Color[]{((OfficeThemeRender)object).getTool_item_outer_top_selected1(), ((OfficeThemeRender)object).getTool_item_outer_top_selected2(), ((OfficeThemeRender)object).getTool_item_outer_bottom_selected1(), ((OfficeThemeRender)object).getTool_item_outer_bottom_selected2(), ((OfficeThemeRender)object).getTool_item_inner_top_selected1(), ((OfficeThemeRender)object).getTool_item_inner_top_selected2(), ((OfficeThemeRender)object).getTool_item_inner_bottom_selected1(), ((OfficeThemeRender)object).getTool_item_inner_bottom_selected2(), ((OfficeThemeRender)object).getTool_item_border_selected()};
                                if (cToolItem.getMenu() != null) {
                                    this.drawGradientBack(gC, this.getNonMenuRect(toolDrawCommand), colorArray);
                                    colorArray = new Color[]{((OfficeThemeRender)object).getTool_item_outer_top_track1(), ((OfficeThemeRender)object).getTool_item_outer_top_track2(), ((OfficeThemeRender)object).getTool_item_outer_bottom_track1(), ((OfficeThemeRender)object).getTool_item_outer_bottom_track2(), ((OfficeThemeRender)object).getTool_item_inner_top_track1(), ((OfficeThemeRender)object).getTool_item_inner_top_track2(), ((OfficeThemeRender)object).getTool_item_inner_bottom_track1(), ((OfficeThemeRender)object).getTool_item_inner_bottom_track2(), ((OfficeThemeRender)object).getTool_item_border_track()};
                                    this.drawGradientBack(gC, this.getMenuRect(toolDrawCommand), colorArray);
                                } else {
                                    this.drawGradientBack(gC, rectangle, colorArray);
                                }
                                this.drawGradientBorder(gC, rectangle, colorArray);
                            }
                        } else if (cToolItem != null && (cToolItem.getStyle() & 0x20) != 0 && cToolItem.getSelection()) {
                            colorArray = new Color[]{((OfficeThemeRender)object).getTool_item_outer_top_checked_track1(), ((OfficeThemeRender)object).getTool_item_outer_top_checked_track2(), ((OfficeThemeRender)object).getTool_item_outer_bottom_checked_track1(), ((OfficeThemeRender)object).getTool_item_outer_bottom_checked_track2(), ((OfficeThemeRender)object).getTool_item_inner_top_checked_track1(), ((OfficeThemeRender)object).getTool_item_inner_top_checked_track2(), ((OfficeThemeRender)object).getTool_item_inner_bottom_checked_track1(), ((OfficeThemeRender)object).getTool_item_inner_bottom_checked_track2(), ((OfficeThemeRender)object).getTool_item_border_checked_track()};
                            this.drawGradientBack(gC, rectangle, colorArray);
                            this.drawGradientBorder(gC, rectangle, colorArray);
                        } else {
                            colorArray = new Color[]{((OfficeThemeRender)object).getTool_item_outer_top_track1(), ((OfficeThemeRender)object).getTool_item_outer_top_track2(), ((OfficeThemeRender)object).getTool_item_outer_bottom_track1(), ((OfficeThemeRender)object).getTool_item_outer_bottom_track2(), ((OfficeThemeRender)object).getTool_item_inner_top_track1(), ((OfficeThemeRender)object).getTool_item_inner_top_track2(), ((OfficeThemeRender)object).getTool_item_inner_bottom_track1(), ((OfficeThemeRender)object).getTool_item_inner_bottom_track2(), ((OfficeThemeRender)object).getTool_item_border_track()};
                            this.drawGradientBack(gC, rectangle, colorArray);
                            this.drawGradientBorder(gC, rectangle, colorArray);
                        }
                    } else if (this.theme instanceof GlossyThemeRender) {
                        this.drawGlossyItem(gC, rectangle, toolDrawCommand, bl);
                    }
                    if (this.selected) {
                        this.showMenuShadow(gC, toolDrawCommand.getDrawRect(), toolDrawCommand.getToolItem());
                    }
                } else if (cToolItem != null && (cToolItem.getStyle() & 0x20) != 0 && cToolItem.getSelection()) {
                    if (this.theme instanceof GeneralThemeRender) {
                        object = (GeneralThemeRender)this.theme;
                        gC.setForeground(((GeneralThemeRender)object).getTool_item_check_selection_bg_normal1());
                        gC.setBackground(((GeneralThemeRender)object).getTool_item_check_selection_bg_normal2());
                        gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                        gC.setForeground(((GeneralThemeRender)object).getTool_item_check_selection_fg_normal());
                        gC.drawRectangle(rectangle);
                    } else if (this.theme instanceof OfficeThemeRender) {
                        object = (OfficeThemeRender)this.theme;
                        colorArray = new Color[]{((OfficeThemeRender)object).getTool_item_outer_top_checked1(), ((OfficeThemeRender)object).getTool_item_outer_top_checked2(), ((OfficeThemeRender)object).getTool_item_outer_bottom_checked1(), ((OfficeThemeRender)object).getTool_item_outer_bottom_checked2(), ((OfficeThemeRender)object).getTool_item_inner_top_checked1(), ((OfficeThemeRender)object).getTool_item_inner_top_checked2(), ((OfficeThemeRender)object).getTool_item_inner_bottom_checked1(), ((OfficeThemeRender)object).getTool_item_inner_bottom_checked2(), ((OfficeThemeRender)object).getTool_item_border_checked()};
                        this.drawGradientBack(gC, rectangle, colorArray);
                        this.drawGradientBorder(gC, rectangle, colorArray);
                    } else if (this.theme instanceof GlossyThemeRender) {
                        this.drawGlossyItem(gC, rectangle, toolDrawCommand, bl);
                    }
                }
            }
            if (toolDrawCommand.isChevron) {
                object = this.theme.getTool_chevronImage();
                int n = rectangle.y + 3;
                int n2 = rectangle.x + (rectangle.width - object.getImageData().width) / 2 + 1;
                if (this.selected && bl) {
                    ++n2;
                    ++n;
                }
                gC.drawImage((Image)object, n2, n);
            } else {
                if (toolDrawCommand.isEnabled() && this.toolbar.isEnabled()) {
                    gC.setForeground(this.theme.getTool_item_fg());
                } else {
                    gC.setForeground(this.theme.getTool_item_fg_disabled());
                }
                this.drawImageAndText(gC, toolDrawCommand, this.selected, bl);
            }
        } else {
            Color color = this.theme.getTool_item_separater_darkcolor();
            Color color2 = this.theme.getTool_item_separater_lightcolor();
            this.drawSeparator(gC, toolDrawCommand.getDrawRect(), color2, color);
        }
    }

    private void drawGlossyItem(GC gC, Rectangle rectangle, ToolDrawCommand toolDrawCommand, boolean bl) {
        GlossyThemeRender glossyThemeRender = (GlossyThemeRender)this.theme;
        gC.setAntialias(1);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        Rectangle rectangle3 = GraphicsUtil.inflate(rectangle2, -1, -1);
        Rectangle rectangle4 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height / 2);
        Rectangle rectangle5 = GraphicsUtil.createRectangleFromLTRB(rectangle2.x, rectangle2.y + Math.round((float)rectangle2.height * 0.5f), rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
        Pattern pattern = new Pattern(null, 0.0f, (float)rectangle4.y, 0.0f, (float)(rectangle4.y + rectangle4.height), glossyThemeRender.getTool_item_bg_color1(), glossyThemeRender.getTool_item_bg_color1_alpha(), glossyThemeRender.getTool_item_bg_color2(), glossyThemeRender.getTool_item_bg_color2_alpha());
        Path path = new Path(null);
        path.addRectangle((float)rectangle4.x, (float)rectangle4.y, (float)rectangle4.width, (float)rectangle4.height);
        gC.setBackgroundPattern(pattern);
        gC.fillPath(path);
        path.dispose();
        path = GraphicsUtil.createRoundRectangle(rectangle2, 2);
        gC.setForeground(glossyThemeRender.getTool_item_outer_border());
        gC.drawPath(path);
        path.dispose();
        if (bl && toolDrawCommand.getToolItem() != null && this.selected && (this.menuTracked || toolDrawCommand.getToolItem().getMenu() != null && !toolDrawCommand.getToolItem().canSelected())) {
            path = GraphicsUtil.createTopRoundRectangle(rectangle3, 2);
            gC.setBackground(glossyThemeRender.getTool_item_bg_glossy_showMenu());
            gC.fillPath(path);
            path.dispose();
            path = GraphicsUtil.createTopRoundRectangle(rectangle3, 2);
            gC.setForeground(glossyThemeRender.getTool_item_bg_glossy_showMenu());
            gC.drawPath(path);
            path.dispose();
            gC.setAdvanced(false);
            return;
        }
        if (bl && toolDrawCommand.getToolItem() != null && this.selected && toolDrawCommand.getToolItem().getMenu() != null) {
            pattern = new Pattern(null, 0.0f, (float)rectangle4.y, 0.0f, (float)(rectangle4.y + rectangle4.height), glossyThemeRender.getTool_item_bg_glossy_selected1(), glossyThemeRender.getTool_item_bg_glossy_selected1_alpha(), glossyThemeRender.getTool_item_bg_glossy_selected2(), glossyThemeRender.getTool_item_bg_glossy_selected2_alpha());
            Rectangle rectangle6 = this.getNonMenuRect(toolDrawCommand);
            Rectangle rectangle7 = new Rectangle(rectangle3.x, rectangle3.y, rectangle6.width - 1, rectangle3.height / 2);
            path = this.createTopLeftRoundRectangle(rectangle7, 2);
            gC.setBackgroundPattern(pattern);
            gC.fillPath(path);
            path.dispose();
            pattern = new Pattern(null, 0.0f, (float)rectangle4.y, 0.0f, (float)(rectangle4.y + rectangle4.height), glossyThemeRender.getTool_item_bg_glossy_track1(), glossyThemeRender.getTool_item_bg_glossy_track1_alpha(), glossyThemeRender.getTool_item_bg_glossy_track2(), glossyThemeRender.getTool_item_bg_glossy_track2_alpha());
            Rectangle rectangle8 = this.getMenuRect(toolDrawCommand);
            Rectangle rectangle9 = new Rectangle(rectangle8.x, rectangle3.y, rectangle8.width - 1, rectangle3.height / 2);
            path = this.createTopRightRoundRectangle(rectangle9, 2);
            gC.setBackgroundPattern(pattern);
            gC.fillPath(path);
            path.dispose();
            Color color = glossyThemeRender.getTool_item_inner_border_selected();
            path = CToolBar.createLeftRoundPath(new Rectangle(rectangle3.x, rectangle3.y, rectangle6.width - 1, rectangle3.height), 2);
            gC.setForeground(color);
            gC.drawPath(path);
            path.dispose();
            color = glossyThemeRender.getTool_item_inner_border_track();
            path = CToolBar.createRightRoundPath(new Rectangle(rectangle8.x, rectangle3.y, rectangle8.width, rectangle3.height), 2);
            gC.setForeground(color);
            gC.drawPath(path);
            path.dispose();
            path = GraphicsUtil.createRoundRectangle(rectangle5, 2);
            gC.setClipping(path);
            path.dispose();
            Color color2 = glossyThemeRender.getTool_item_bg_glow_track();
            path = this.createBottomRadialPath(rectangle5);
            float[] fArray = new float[2];
            float[] fArray2 = new float[4];
            path.getBounds(fArray2);
            fArray[0] = (fArray2[0] + fArray2[0] + fArray2[2]) / 2.0f;
            fArray[1] = (fArray2[1] + fArray2[1] + fArray2[3]) / 2.0f;
            GCExtension gCExtension = new GCExtension(gC);
            gCExtension.fillGradientPath(path, fArray, color2, 255, new Color[]{color2}, new int[]{0});
            path.dispose();
            gC.setClipping((Region)null);
            gC.setAdvanced(false);
            return;
        }
        pattern = !this.selected || !bl ? new Pattern(null, 0.0f, (float)rectangle4.y, 0.0f, (float)(rectangle4.y + rectangle4.height), glossyThemeRender.getTool_item_bg_glossy_track1(), glossyThemeRender.getTool_item_bg_glossy_track1_alpha(), glossyThemeRender.getTool_item_bg_glossy_track2(), glossyThemeRender.getTool_item_bg_glossy_track2_alpha()) : new Pattern(null, 0.0f, (float)rectangle4.y, 0.0f, (float)(rectangle4.y + rectangle4.height), glossyThemeRender.getTool_item_bg_glossy_selected1(), glossyThemeRender.getTool_item_bg_glossy_selected1_alpha(), glossyThemeRender.getTool_item_bg_glossy_selected2(), glossyThemeRender.getTool_item_bg_glossy_selected2_alpha());
        path = GraphicsUtil.createTopRoundRectangle(rectangle4, 2);
        gC.setBackgroundPattern(pattern);
        gC.fillPath(path);
        path.dispose();
        Color color = this.selected && bl || toolDrawCommand.getToolItem() != null && (toolDrawCommand.getToolItem().getStyle() & 0x20) != 0 && toolDrawCommand.getToolItem().getSelection() ? glossyThemeRender.getTool_item_inner_border_selected() : glossyThemeRender.getTool_item_inner_border_track();
        path = GraphicsUtil.createRoundRectangle(rectangle3, 2);
        gC.setForeground(color);
        gC.drawPath(path);
        path.dispose();
        if (!this.menuTracked && (toolDrawCommand.getToolItem() == null || toolDrawCommand.getToolItem().getMenu() == null || toolDrawCommand.getToolItem().canSelected()) || !this.selected || !bl) {
            path = GraphicsUtil.createRoundRectangle(rectangle5, 2);
            gC.setClipping(path);
            path.dispose();
            Color color3 = glossyThemeRender.getTool_item_bg_glow_track();
            if (toolDrawCommand.getToolItem() != null && (toolDrawCommand.getToolItem().getStyle() & 0x20) != 0 && toolDrawCommand.getToolItem().getSelection()) {
                color3 = bl ? glossyThemeRender.getTool_item_bg_checked_glow_track() : glossyThemeRender.getTool_item_bg_checked_glow();
            }
            path = this.createBottomRadialPath(rectangle5);
            float[] fArray = new float[2];
            float[] fArray3 = new float[4];
            path.getBounds(fArray3);
            fArray[0] = (fArray3[0] + fArray3[0] + fArray3[2]) / 2.0f;
            fArray[1] = (fArray3[1] + fArray3[1] + fArray3[3]) / 2.0f;
            GCExtension gCExtension = new GCExtension(gC);
            gCExtension.fillGradientPath(path, fArray, color3, 255, new Color[]{color3}, new int[]{0});
            path.dispose();
            gC.setClipping((Region)null);
        }
        gC.setAdvanced(false);
    }

    private Path createBottomRadialPath(Rectangle rectangle) {
        float[] fArray = new float[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        fArray[0] = fArray[0] - fArray[2] * 0.35f;
        fArray[1] = fArray[1] - fArray[3] * 0.15f;
        fArray[2] = fArray[2] * 1.7f;
        fArray[3] = fArray[3] * 2.3f;
        return GraphicsUtil.createEllipsePath(fArray);
    }

    private void drawImageAndText(GC gC, ToolDrawCommand toolDrawCommand, boolean bl, boolean bl2) {
        int n;
        gC.setAdvanced(false);
        Rectangle rectangle = toolDrawCommand.getSelectRect();
        if (toolDrawCommand.getToolItem().getMenu() != null) {
            rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width - 11, rectangle.height);
        }
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width + n2;
        int n5 = rectangle.height + n3;
        int n6 = gC.textExtent((String)toolDrawCommand.getToolItem().getText(), (int)7).x;
        int n7 = gC.getFontMetrics().getHeight();
        String string = null;
        if (toolDrawCommand.getToolItem().getText().length() > 0) {
            string = toolDrawCommand.getToolItem().getText();
        }
        Image image = toolDrawCommand.getToolItem().getImage();
        if (string == null && this.hasText && ((this.style & 0x80) != 0 || (this.style & 0x400) != 0)) {
            string = "";
        }
        if (string != null && image != null) {
            if ((this.style & 0x80) != 0) {
                n = n2 + Math.round((float)(rectangle.width - image.getImageData().width) / 2.0f);
                int n8 = n3 + Math.round((float)(this.imageHeight - image.getImageData().height) / 2.0f);
                this.drawImage(gC, toolDrawCommand, n, n8, bl2);
                gC.drawText(string, n2 + Math.round((float)(rectangle.width - n6) / 2.0f), n3 + this.imageHeight + 1, 7);
            } else if ((this.style & 0x400) != 0) {
                n = n2 + Math.round((float)(rectangle.width - image.getImageData().width) / 2.0f);
                int n9 = n5 - this.imageHeight + Math.round((float)(this.imageHeight - image.getImageData().height) / 2.0f);
                this.drawImage(gC, toolDrawCommand, n, n9, bl2);
                gC.drawText(string, n2 + Math.round((float)(rectangle.width - n6) / 2.0f), n3 + rectangle.height - this.imageHeight - 1 - n7, 7);
            } else if ((this.style & 0x20000) != 0) {
                gC.drawText(string, n4 - this.imageWidth - 2 - n6, n3 + Math.round((float)(rectangle.height - n7) / 2.0f), 7);
                n = n4 - this.imageWidth + (this.imageWidth - image.getImageData().width) / 2;
                int n10 = n3 + Math.round((float)(rectangle.height - image.getImageData().height) / 2.0f);
                this.drawImage(gC, toolDrawCommand, n, n10, bl2);
            } else {
                n = n2 + (this.imageWidth - image.getImageData().width) / 2;
                int n11 = n3 + Math.round((float)(rectangle.height - image.getImageData().height) / 2.0f);
                this.drawImage(gC, toolDrawCommand, n, n11, bl2);
                gC.drawText(string, n2 + 2 + this.imageWidth, n3 + Math.round((float)(rectangle.height - n7) / 2.0f), 7);
            }
        } else if (string != null) {
            gC.drawText(string, n2 + Math.round((float)(rectangle.width - n6) / 2.0f), n3 + Math.round((float)(rectangle.height - n7) / 2.0f), 7);
        } else if (image != null) {
            n = n2 + Math.round((float)(rectangle.width - image.getImageData().width) / 2.0f);
            int n12 = n3 + Math.round((float)(rectangle.height - image.getImageData().height) / 2.0f);
            this.drawImage(gC, toolDrawCommand, n, n12, bl2);
        }
        if (toolDrawCommand.getToolItem().getMenu() != null) {
            Rectangle rectangle2 = this.getMenuRect(toolDrawCommand);
            gC.setAdvanced(false);
            if (toolDrawCommand.isEnabled()) {
                if (bl2) {
                    gC.setBackground(this.theme.getTool_item_arrow_bg_track());
                } else {
                    gC.setBackground(this.theme.getTool_item_arrow_bg());
                }
            } else {
                gC.setBackground(this.theme.getTool_item_arrow_bg_disabled());
            }
            GraphicsUtil.drawArrow(gC, rectangle2, 1024);
            if (bl2 && (!this.menuTracked || !bl) && toolDrawCommand.getToolItem().canSelected() && toolDrawCommand.getToolItem().isEnabled()) {
                if (!(this.theme instanceof OfficeThemeRender)) {
                    if (this.theme instanceof GeneralThemeRender) {
                        gC.setForeground(((GeneralThemeRender)this.theme).getTool_item_check_separater_color());
                    } else if (this.theme instanceof GlossyThemeRender) {
                        gC.setForeground(((GlossyThemeRender)this.theme).getTool_item_check_separater_color());
                    }
                    gC.drawLine(rectangle2.x, rectangle2.y + 1, rectangle2.x, rectangle2.y + rectangle2.height - 1);
                } else if (!bl) {
                    gC.setForeground(((OfficeThemeRender)this.theme).getTool_item_check_separater_drakcolor());
                    gC.drawLine(rectangle2.x, rectangle2.y + 1, rectangle2.x, rectangle2.y + rectangle2.height - 1);
                    gC.setForeground(((OfficeThemeRender)this.theme).getTool_item_check_separater_lightcolor());
                    gC.drawLine(rectangle2.x + 1, rectangle2.y + 1, rectangle2.x + 1, rectangle2.y + rectangle2.height - 1);
                }
            }
        }
    }

    private Rectangle getMenuRect(ToolDrawCommand toolDrawCommand) {
        int n = toolDrawCommand.getSelectRect().x + toolDrawCommand.getSelectRect().width + 3 - 11;
        int n2 = toolDrawCommand.getDrawRect().x + toolDrawCommand.getDrawRect().width;
        Rectangle rectangle = new Rectangle(n, toolDrawCommand.getDrawRect().y, n2 - n, toolDrawCommand.getDrawRect().height);
        return rectangle;
    }

    private Rectangle getNonMenuRect(ToolDrawCommand toolDrawCommand) {
        int n = toolDrawCommand.getDrawRect().x;
        int n2 = toolDrawCommand.getSelectRect().x + toolDrawCommand.getSelectRect().width + 3 - 11;
        Rectangle rectangle = new Rectangle(n, toolDrawCommand.getDrawRect().y, n2 - n, toolDrawCommand.getDrawRect().height);
        return rectangle;
    }

    private void drawImage(GC gC, ToolDrawCommand toolDrawCommand, int n, int n2, boolean bl) {
        Image image = toolDrawCommand.getToolItem().getImage();
        Image image2 = toolDrawCommand.getToolItem().getDisableImage();
        if (image != null) {
            if (toolDrawCommand.isEnabled()) {
                if (bl && !this.selected && this.theme.isShowToolImageShadow() && GraphicsUtil.checkGdip()) {
                    ImageData imageData = image.getImageData();
                    PaletteData paletteData = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(154, 156, 146)});
                    ImageData imageData2 = new ImageData(imageData.width, imageData.height, 1, paletteData);
                    imageData2.transparentPixel = imageData.transparentPixel;
                    if (imageData.getTransparencyType() == 4) {
                        for (int i = 0; i < imageData.width; ++i) {
                            for (int j = 0; j < imageData.width; ++j) {
                                int n3 = imageData.getPixel(i, j);
                                if (n3 != imageData.transparentPixel) {
                                    imageData2.setPixel(i, j, 1);
                                    continue;
                                }
                                imageData2.setPixel(i, j, 0);
                            }
                        }
                        gC.setAdvanced(true);
                        Image image3 = new Image(gC.getDevice(), imageData2);
                        gC.drawImage(image3, n + 1, n2 + 1);
                        image3.dispose();
                        gC.setAdvanced(false);
                        gC.drawImage(image, n - 1, n2 - 1);
                    } else {
                        gC.drawImage(image, n, n2);
                    }
                } else if (GraphicsUtil.checkGdip() && this.theme.isShowToolImageShadow()) {
                    RGB[] rGBArray = image.getImageData().palette.getRGBs();
                    if (rGBArray != null) {
                        RGB rGB;
                        for (int i = 0; i < rGBArray.length; ++i) {
                            rGB = rGBArray[i];
                            rGB.red = rGB.red + 76 - (rGB.red + 32) / 64 * 19;
                            rGB.green = rGB.green + 76 - (rGB.green + 32) / 64 * 19;
                            rGB.blue = rGB.blue + 76 - (rGB.blue + 32) / 64 * 19;
                        }
                        ImageData imageData = image.getImageData();
                        rGB = new ImageData(imageData.width, imageData.height, imageData.depth, new PaletteData(rGBArray));
                        rGB.transparentPixel = imageData.transparentPixel;
                        for (int i = 0; i < imageData.width; ++i) {
                            for (int j = 0; j < imageData.width; ++j) {
                                int n4 = imageData.getPixel(i, j);
                                if (n4 != imageData.transparentPixel) {
                                    rGB.setPixel(i, j, n4);
                                    continue;
                                }
                                rGB.setPixel(i, j, imageData.transparentPixel);
                            }
                        }
                        Image image4 = new Image(null, (ImageData)rGB);
                        gC.drawImage(image4, n, n2);
                        image4.dispose();
                    }
                } else {
                    gC.drawImage(image, n, n2);
                }
            } else if (image2 == null) {
                image2 = new Image(null, image, 1);
                gC.drawImage(image2, n, n2);
                image2.dispose();
            } else {
                gC.drawImage(image2, n, n2);
            }
        }
    }

    private void drawGradientBack(GC gC, Rectangle rectangle, Color[] colorArray) {
        gC.setAdvanced(true);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        Rectangle rectangle3 = GraphicsUtil.inflate(rectangle2, -1, -1);
        int n = rectangle3.height / 2;
        Rectangle rectangle4 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, n);
        Rectangle rectangle5 = new Rectangle(rectangle3.x, rectangle3.y + n, rectangle3.width, rectangle3.height - n);
        gC.setForeground(colorArray[0]);
        gC.setBackground(colorArray[1]);
        gC.fillGradientRectangle(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, true);
        gC.setForeground(colorArray[2]);
        gC.setBackground(colorArray[3]);
        gC.fillGradientRectangle(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height, true);
        Rectangle rectangle6 = GraphicsUtil.inflate(rectangle3, -1, -1);
        n = rectangle6.height / 2;
        rectangle4 = new Rectangle(rectangle6.x, rectangle6.y, rectangle6.width, n);
        rectangle5 = new Rectangle(rectangle6.x, rectangle6.y + n, rectangle6.width, rectangle6.height - n);
        gC.setForeground(colorArray[4]);
        gC.setBackground(colorArray[5]);
        gC.fillGradientRectangle(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, true);
        gC.setForeground(colorArray[6]);
        gC.setBackground(colorArray[7]);
        gC.fillGradientRectangle(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height, true);
        gC.setAdvanced(false);
    }

    private void drawGradientBorder(GC gC, Rectangle rectangle, Color[] colorArray) {
        if (GraphicsUtil.checkGdip()) {
            gC.setAdvanced(true);
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Path path = GraphicsUtil.createRoundPath(rectangle2, 1.2f);
            gC.setForeground(colorArray[8]);
            gC.drawPath(path);
            path.dispose();
            gC.setAdvanced(false);
        } else {
            gC.setForeground(colorArray[8]);
            gC.drawRectangle(rectangle);
        }
    }

    public Control getControl() {
        return this.toolbar;
    }

    protected ToolDrawCommand getCurrentCommand() {
        if (this.toolbar.isDisposed()) {
            return null;
        }
        if (this.trackItemIndex < 0 || this.trackItemIndex >= this.drawCommands.size()) {
            return null;
        }
        return (ToolDrawCommand)this.drawCommands.get(this.trackItemIndex);
    }

    public CToolItem getSelection() {
        if (this.trackItemIndex == -1) {
            return null;
        }
        ToolDrawCommand toolDrawCommand = (ToolDrawCommand)this.drawCommands.get(this.trackItemIndex);
        if (toolDrawCommand == null) {
            return null;
        }
        return toolDrawCommand.getToolItem();
    }

    public int getSelectionIndex() {
        return this.trackItemIndex;
    }

    public Shell getShell() {
        if (this.toolbar.isDisposed()) {
            return null;
        }
        return this.toolbar.getShell();
    }

    public ThemeRender getTheme() {
        return this.theme;
    }

    boolean isFocusControl() {
        return this.isFocusControl;
    }

    void setFocusControl(boolean bl) {
        this.isFocusControl = bl;
    }

    private void handleMouseMoveEvent(Point point) {
        if (!this.checkEnableHandleEvent()) {
            return;
        }
        for (int i = 0; i < this.drawCommands.size(); ++i) {
            ToolDrawCommand toolDrawCommand = (ToolDrawCommand)this.drawCommands.get(i);
            if (!toolDrawCommand.getDrawRect().contains(point.x, point.y)) continue;
            if (this.trackItemIndex != i) {
                if (toolDrawCommand.isSeparator() && this.isFocusControl()) {
                    return;
                }
                this.selected = false;
                this.toolbar.setToolTipText(null);
                if (this.popupMenu != null) {
                    this.popupMenu.hideMenu();
                    this.popupMenu = null;
                }
                this.refresh();
                this.trackItemIndex = i;
                if (toolDrawCommand.getToolItem() != null && toolDrawCommand.getToolItem().getToolTip() != null) {
                    this.toolbar.setToolTipText(toolDrawCommand.getToolItem().getToolTip());
                }
                this.refresh();
                this.menuTracked = !this.isShowMenu() && toolDrawCommand.getToolItem() != null && toolDrawCommand.getToolItem().getMenu() != null ? this.getMenuRect(toolDrawCommand).contains(point) : false;
                this.drawCommand(this.trackItemIndex, true);
                return;
            }
            return;
        }
        this.toolbar.setToolTipText(null);
        if (this.trackItemIndex >= 0) {
            if (!this.selected) {
                this.refresh();
                this.drawCommand(this.trackItemIndex, false);
                this.trackItemIndex = -1;
            } else if (!this.isShowMenu()) {
                this.selected = false;
                this.refresh();
                this.drawCommand(this.trackItemIndex, false);
                this.trackItemIndex = -1;
            }
        }
    }

    protected boolean checkEnableHandleEvent() {
        MenuHolder menuHolder = MenuHolderManager.getActiveHolder();
        return menuHolder == null || menuHolder == this;
    }

    public void hideMenu() {
        this.hideCurrentMenu();
    }

    private void hideCurrentMenu() {
        if (this.popupMenu != null) {
            this.popupMenu.hideMenu();
            this.popupMenu = null;
        }
        if (this.toolbar.isDisposed()) {
            return;
        }
        this.selected = false;
        this.refresh();
        if (!this.isFocusControl()) {
            this.drawCommand(this.trackItemIndex, false);
            this.trackItemIndex = -1;
        }
    }

    public boolean isMultiLine() {
        return (this.style & 2) != 0;
    }

    private boolean isShowMenu() {
        return this.popupMenu != null && !this.popupMenu.getShell().isDisposed();
    }

    private void onPaint(PaintEvent paintEvent) {
        if (this.theme instanceof GlossyThemeRender) {
            this.drawGlossyThemeBackGround(paintEvent.gc);
        }
        this.recalculate();
        this.toolbar.getParent().layout();
        this.drawAllCommands(paintEvent.gc);
    }

    private void drawGlossyThemeBackGround(GC gC) {
        GlossyThemeRender glossyThemeRender = (GlossyThemeRender)this.theme;
        Rectangle rectangle = new Rectangle(0, 0, this.toolbar.getSize().x, this.toolbar.getSize().y / 2);
        Pattern pattern = new Pattern(null, 0.0f, 0.0f, 0.0f, (float)rectangle.height, glossyThemeRender.getToolbar_bg_glossy_color1(), glossyThemeRender.getToolbar_bg_glossy_color1_alpha(), glossyThemeRender.getToolbar_bg_glossy_color2(), glossyThemeRender.getToolbar_bg_glossy_color2_alpha());
        gC.setBackgroundPattern(pattern);
        Path path = new Path(null);
        path.addRectangle((float)rectangle.x, (float)rectangle.y, (float)rectangle.width, (float)rectangle.height);
        gC.fillPath(path);
        path.dispose();
        int n = (int)((double)this.toolbar.getSize().y * 0.15);
        Rectangle rectangle2 = new Rectangle(0, this.toolbar.getSize().y - n, this.toolbar.getSize().x, n);
        pattern = new Pattern(null, 0.0f, (float)rectangle2.y, 0.0f, (float)(rectangle2.y + rectangle2.height), glossyThemeRender.getToolbar_bg_glow_color1(), glossyThemeRender.getToolbar_bg_glow_color1_alpha(), glossyThemeRender.getToolbar_bg_glow_color2(), glossyThemeRender.getToolbar_bg_glow_color2_alpha());
        gC.setBackgroundPattern(pattern);
        path = new Path(null);
        path.addRectangle((float)rectangle2.x, (float)rectangle2.y, (float)rectangle2.width, (float)rectangle2.height);
        gC.fillPath(path);
        path.dispose();
    }

    protected Rectangle recalculate() {
        int n;
        int n2;
        int n3;
        this.hasText = false;
        int n4 = this.toolbar.getSize().x;
        this.imageWidth = 16;
        this.imageHeight = 16;
        for (n3 = 0; n3 < this.getItemCount(); ++n3) {
            Image image = this.getItem(n3).getImage();
            if (image == null || image.isDisposed()) continue;
            n2 = image.getImageData().width;
            n = image.getImageData().height;
            if (n2 > this.imageWidth) {
                this.imageWidth = n2;
            }
            if (n <= this.imageHeight) continue;
            this.imageHeight = n;
        }
        if (n4 > 0) {
            CToolItem cToolItem;
            int n5;
            int n6;
            n3 = 0;
            int n7 = 0;
            n2 = 8;
            n = 2;
            int n8 = 0;
            n4 = (this.style & 2) == 0 ? (n4 -= 15) : (n4 -= 4);
            this.drawCommands.clear();
            this.chevronStartItem = null;
            GC gC = new GC((Drawable)this.toolbar);
            int n9 = gC.getFontMetrics().getHeight() / 3 + 1;
            int n10 = gC.getFontMetrics().getHeight() + n9 * 2 + 1;
            if ((this.style & 0x80) != 0 || (this.style & 0x400) != 0) {
                n10 += this.imageHeight;
                ++n10;
            } else {
                n6 = this.imageHeight + n9 * 2 + 1;
                n10 = n6 > n10 ? n6 : n10;
            }
            n6 = 0;
            for (n5 = 0; n5 < this.getItemCount(); ++n5) {
                Rectangle rectangle;
                cToolItem = this.getItem(n5);
                if (!cToolItem.isVisible()) continue;
                int n11 = 0;
                if (cToolItem.getText().equals("-") || (cToolItem.getStyle() & 2) != 0) {
                    n11 = 8;
                } else {
                    if (cToolItem.getText() == null) {
                        n11 = n2 + this.imageWidth;
                    } else if (cToolItem.getImage() == null) {
                        n11 = n2 + gC.textExtent((String)cToolItem.getText(), (int)7).x;
                    } else {
                        if ((this.style & 0x80) == 0 && (this.style & 0x400) == 0) {
                            n11 = n2 + gC.textExtent((String)cToolItem.getText(), (int)7).x + 2;
                            n11 += this.imageWidth;
                        } else {
                            n11 = gC.textExtent((String)cToolItem.getText(), (int)7).x;
                            n11 = n11 < this.imageWidth ? this.imageWidth : n11;
                            n11 += n2;
                        }
                        this.hasText = true;
                    }
                    if (cToolItem.getMenu() != null) {
                        n11 += 11;
                    }
                }
                Rectangle rectangle2 = new Rectangle(n, n10 * n3 + 2, n11, n10 - 1);
                if ((n += n11) > n4 && ++n7 > 1) {
                    if ((this.style & 2) != 0) {
                        ++n3;
                        n7 = 1;
                        n = n11;
                        rectangle2.x = 1;
                        rectangle2.y += n10;
                    } else {
                        if (n6 <= this.trackItemIndex) {
                            this.removeItemTracking();
                        }
                        this.chevronStartItem = cToolItem;
                        rectangle2.y = 1;
                        rectangle2.width = 14;
                        rectangle2.x = this.toolbar.getClientArea().width - rectangle2.width - 1;
                        rectangle2.height = n10 + 1;
                        rectangle = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        rectangle.height -= 2;
                        this.drawCommands.add(new ToolDrawCommand(rectangle));
                        break;
                    }
                }
                rectangle = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                rectangle.height -= 2;
                Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                rectangle3.height -= 7;
                rectangle3.width -= 9;
                rectangle3.x += 4;
                rectangle3.y += 3;
                this.drawCommands.add(new ToolDrawCommand(cToolItem, rectangle, rectangle3));
                ++n6;
            }
            gC.dispose();
            n5 = (n3 + 1) * n10 + 2 * n8 + 2;
            if (this.toolbar.getBounds().height != n5) {
                cToolItem = new Rectangle(this.toolbar.getBounds().x, this.toolbar.getBounds().y, this.toolbar.getBounds().width, n5);
                return cToolItem;
            }
        }
        return this.toolbar.getBounds();
    }

    public void refresh() {
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            this.toolbar.redraw();
        }
    }

    private void removeItemTracking() {
        if (this.trackItemIndex != -1 && this.trackItemIndex < this.drawCommands.size()) {
            ToolDrawCommand toolDrawCommand = (ToolDrawCommand)this.drawCommands.get(this.trackItemIndex);
            if (toolDrawCommand.getToolItem() != null) {
                Event event = new Event();
                event.data = toolDrawCommand.getToolItem();
                event.detail = 27;
                this.toolbar.notifyListeners(27, event);
            }
            this.trackItemIndex = -1;
        }
    }

    public void setBackground(Color color) {
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            this.toolbar.setBackground(color);
        }
    }

    public void setBackground(Color[] colorArray, int[] nArray, boolean bl) {
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            this.toolbar.setBackground(colorArray, nArray, bl);
        }
    }

    public void setBackgroundImage(Image image) {
        if (this.toolbar != null && !this.toolbar.isDisposed()) {
            this.toolbar.setBackgroundImage(image);
        }
    }

    public void setMultiLine(boolean bl) {
        this.style = !bl ? (this.style &= 0xFFFFFFFD) : (this.style |= 2);
    }

    public void setSelection(int n, boolean bl) {
        if (this.drawCommands.size() > 0) {
            if (n > -1 && n < this.drawCommands.size()) {
                ToolDrawCommand toolDrawCommand = (ToolDrawCommand)this.drawCommands.get(n);
                if (!toolDrawCommand.isSeparator() && (toolDrawCommand.isChevron() || toolDrawCommand.isEnabled())) {
                    this.refresh();
                    this.trackItemIndex = n;
                    this.selected = bl;
                    this.refresh();
                    this.drawCommand(this.trackItemIndex, true);
                    if (this.selected) {
                        this.showMenu(toolDrawCommand);
                    }
                }
            } else {
                this.selected = false;
                this.refresh();
                this.drawCommand(this.trackItemIndex, false);
                this.trackItemIndex = -1;
                this.hideCurrentMenu();
            }
        }
    }

    public void setTheme(ThemeRender themeRender) {
        if (this.toolbar == null || this.toolbar.isDisposed()) {
            return;
        }
        if (!GraphicsUtil.checkGdip() && themeRender instanceof GlossyThemeRender) {
            return;
        }
        this.theme = themeRender;
        if (themeRender.getToolbar_bgColors_percents() == null) {
            this.toolbar.setBackground(themeRender.getToolbar_bgColors()[0]);
        } else {
            this.toolbar.setBackground(themeRender.getToolbar_bgColors(), themeRender.getToolbar_bgColors_percents(), true);
        }
    }

    private void showMenu(ToolDrawCommand toolDrawCommand) {
        if (toolDrawCommand == null || this.getCurrentCommand() == null) {
            return;
        }
        if (toolDrawCommand.getToolItem() != this.getCurrentCommand().getToolItem()) {
            return;
        }
        if (toolDrawCommand.isChevron()) {
            ArrayList<CToolItem> arrayList = new ArrayList<CToolItem>();
            int n = this.indexOf(this.chevronStartItem);
            if (n > 0) {
                for (int i = n; i < this.getItemCount(); ++i) {
                    if ((this.getItem(i).getStyle() & 2) != 0 || this.getItem(i).getText().equals("-")) continue;
                    arrayList.add(this.getItem(i));
                }
                if (arrayList.size() > 0) {
                    this.drawUpwards = false;
                    this.popupMenu = new ToolMenuControl(this, this.theme, this.style);
                    ((ToolMenuControl)this.popupMenu).setToolItems(arrayList.toArray(new CToolItem[0]));
                    ((ToolMenuControl)this.popupMenu).setTopRightLocation(this.toolbar.toDisplay(this.toolbar.getSize().x, this.toolbar.getSize().y));
                    this.popupMenu.createAndShowWindow();
                    this.installMouseHook();
                }
            }
        } else {
            this.drawUpwards = false;
            this.popupMenu = new MenuControl(this, this.theme);
            this.popupMenu.menu = toolDrawCommand.getToolItem().getMenu();
            this.popupMenu.screenPos = this.toolbar.toDisplay(new Point(toolDrawCommand.getDrawRect().x, toolDrawCommand.getDrawRect().y + toolDrawCommand.getDrawRect().height));
            this.popupMenu.bar = this;
            this.popupMenu.leftScreenPos = this.popupMenu.screenPos;
            this.popupMenu.aboveScreenPos = this.toolbar.toDisplay(new Point(toolDrawCommand.getDrawRect().x, toolDrawCommand.getDrawRect().y + 1));
            this.popupMenu.borderGap = toolDrawCommand.getDrawRect().width;
            this.popupMenu.createAndShowWindow();
            this.installMouseHook();
        }
    }

    private void installMouseHook() {
        this.mouseCallback = new Callback((Object)this, "MouseProc", 3);
        this.newAddress = this.mouseCallback.getAddress();
        if (this.newAddress == 0) {
            SWT.error((int)3);
        }
        int n = Extension.GetCurrentThreadId();
        this.oldAddress = Extension.SetWindowsHookEx((int)7, (int)this.newAddress, (int)0, (int)n);
        this.popupMenu.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (CToolBar.this.mouseCallback != null) {
                    Extension.UnhookWindowsHookEx((int)CToolBar.this.oldAddress);
                    CToolBar.this.mouseCallback.dispose();
                    CToolBar.this.mouseCallback = null;
                    CToolBar.this.newAddress = 0;
                }
            }
        });
    }

    int MouseProc(int n, int n2, int n3) {
        int n4 = Extension.CallNextHookEx((int)this.oldAddress, (int)n, (int)n2, (int)n3);
        if (n < 0) {
            return n4;
        }
        switch (n2) {
            case 161: 
            case 164: {
                this.hideCurrentMenu();
            }
        }
        return n4;
    }

    private void showMenuShadow(GC gC, Rectangle rectangle, CToolItem cToolItem) {
        if (!GraphicsUtil.checkGdip() || !this.theme.isShowToolItemShadow()) {
            return;
        }
        if (cToolItem == null) {
            return;
        }
        gC.setAdvanced(true);
        if (cToolItem.getMenu() != null && cToolItem.getMenu().getItemCount() > 0 && cToolItem.isEnabled() && (this.menuTracked || !cToolItem.canSelected())) {
            if (this.drawUpwards) {
                int n = rectangle.x + rectangle.width + 1;
                int n2 = rectangle.y + 1;
                int n3 = rectangle.y + rectangle.height + 1;
                int n4 = rectangle.x + 4;
                int n5 = rectangle.width + 1;
                int n6 = 4;
                Pattern pattern = new Pattern(gC.getDevice(), (float)n, 9999.0f, (float)(n + 4), 9999.0f, this.theme.getMenuShadowColor(), 48, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n, n2, 4, rectangle.height));
                pattern.dispose();
                pattern = new Pattern(gC.getDevice(), (float)(n4 + 4), (float)(n3 - 4), (float)n4, (float)(n3 + n6), this.theme.getMenuShadowColor(), 64, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n4, n3, 4, n6));
                pattern.dispose();
                pattern = new Pattern(gC.getDevice(), (float)(n4 + n5 - 4 - 2), (float)(n3 - 4 - 2), (float)(n4 + n5), (float)(n3 + n6), this.theme.getMenuShadowColor(), 64, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n4 + n5 - 4, n3, 3, n6 - 1));
                pattern.dispose();
                pattern = new Pattern(gC.getDevice(), 9999.0f, (float)n3, 9999.0f, (float)(n3 + n6), this.theme.getMenuShadowColor(), 48, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n4 + 4, n3, n5 - 8, n6));
                pattern.dispose();
            } else {
                int n = rectangle.x + rectangle.width + 1;
                int n7 = rectangle.y + 4;
                Pattern pattern = new Pattern(gC.getDevice(), (float)(n - 4), (float)(n7 + 4), (float)(n + 4), (float)n7, this.theme.getMenuShadowColor(), 64, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n, rectangle.y + 4, 2, 1));
                gC.fillRectangle(new Rectangle(n, rectangle.y + 1 + 4, 3, 1));
                gC.fillRectangle(new Rectangle(n, rectangle.y + 2 + 4, 4, 2));
                pattern.dispose();
                pattern = new Pattern(gC.getDevice(), (float)n, 9999.0f, (float)(n + 4), 9999.0f, this.theme.getMenuShadowColor(), 48, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n, n7 += 4, 4, rectangle.y + rectangle.height - n7 + 1));
                pattern.dispose();
            }
        }
        gC.setAdvanced(false);
    }

    public boolean isAcitve() {
        return this.trackItemIndex > -1;
    }

    public CToolItem addItem(CToolItem cToolItem) {
        this.items.add(cToolItem);
        return cToolItem;
    }

    public void addItems(CToolItem[] cToolItemArray) {
        for (int i = 0; i < cToolItemArray.length; ++i) {
            this.addItem(cToolItemArray[i]);
        }
    }

    public void removeAll() {
        while (this.items.size() > 0) {
            this.removeItem(this.getItem(0));
        }
    }

    public void removeItem(CToolItem cToolItem) {
        cToolItem.disposed();
        this.items.remove(cToolItem);
    }

    public void addItem(int n, CToolItem cToolItem) {
        this.items.add(n, cToolItem);
    }

    public boolean contains(CToolItem cToolItem) {
        return this.items.contains(cToolItem);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public CToolItem getItem(int n) {
        if (n < 0 || n >= this.items.size()) {
            SWT.error((int)5);
        }
        return (CToolItem)this.items.get(n);
    }

    public CToolItem getItem(String string) {
        for (int i = 0; i < this.items.size(); ++i) {
            CToolItem cToolItem = this.getItem(i);
            if (!cToolItem.getText().equals(string)) continue;
            return cToolItem;
        }
        return null;
    }

    public boolean visibleItems() {
        for (int i = 0; i < this.items.size(); ++i) {
            CToolItem cToolItem = this.getItem(i);
            if (!cToolItem.isVisible() || cToolItem.getText().equals("-") || cToolItem.getMenu() != null && cToolItem.getMenu().getItemCount() > 0 && !cToolItem.getMenu().visibleItems()) continue;
            return true;
        }
        return false;
    }

    public int indexOf(CToolItem cToolItem) {
        return this.items.indexOf(cToolItem);
    }

    private void drawSeparator(GC gC, Rectangle rectangle, Color color, Color color2) {
        int n = rectangle.x + 4;
        int n2 = rectangle.y;
        int n3 = n2 + rectangle.height;
        gC.setForeground(color2);
        gC.drawLine(n, n2 + 3 + 1, n, n3 - 3 + 1);
        gC.setForeground(color);
        gC.drawLine(n + 1, n2 + 3 + 1, n + 1, n3 - 3 + 1);
    }

    public CMenu getMenu() {
        return null;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        this.style = n;
        this.refresh();
    }

    MenuControl getCurrentMenu() {
        if (this.popupMenu != null && this.popupMenu instanceof ToolMenuControl) {
            return null;
        }
        if (this.popupMenu != null && this.popupMenu.trackItemIndex != -1) {
            return this.popupMenu.getCurrentMenu();
        }
        if (this.popupMenu != null) {
            return this.popupMenu;
        }
        return null;
    }

    private Path createTopLeftRoundRectangle(Rectangle rectangle, int n) {
        Path path = new Path(null);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n << 1;
        path.addArc((float)n2, (float)n3, (float)n6, (float)n6, -180.0f, -90.0f);
        path.lineTo((float)(n2 + n), (float)n3);
        path.lineTo((float)(n2 + n4), (float)n3);
        path.lineTo((float)(n2 + n4), (float)(n3 + n5));
        path.lineTo((float)n2, (float)(n3 + n5));
        path.lineTo((float)n2, (float)(n3 + n));
        path.close();
        return path;
    }

    private Path createTopRightRoundRectangle(Rectangle rectangle, int n) {
        Path path = new Path(null);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n << 1;
        path.moveTo((float)n2, (float)n3);
        path.lineTo((float)(n2 + n4 - n), (float)n3);
        path.addArc((float)(n2 + n4 - n6), (float)n3, (float)n6, (float)n6, -270.0f, -90.0f);
        path.lineTo((float)(n2 + n4), (float)(n3 + n));
        path.lineTo((float)(n2 + n4), (float)(n3 + n5));
        path.lineTo((float)n2, (float)(n3 + n5));
        path.lineTo((float)n2, (float)n3);
        path.close();
        return path;
    }

    public static Path createLeftRoundPath(Rectangle rectangle, int n) {
        Path path = new Path(null);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n << 1;
        path.moveTo((float)(n2 + n4), (float)n3);
        path.lineTo((float)(n2 + n), (float)n3);
        path.addArc((float)n2, (float)n3, (float)n6, (float)n6, 90.0f, 90.0f);
        path.lineTo((float)n2, (float)(n3 + n));
        path.lineTo((float)n2, (float)(n3 + n5 - n));
        path.addArc((float)n2, (float)(n3 + n5 - n6), (float)n6, (float)n6, 180.0f, 90.0f);
        path.lineTo((float)(n2 + n), (float)(n3 + n5));
        path.lineTo((float)(n2 + n4), (float)(n3 + n5));
        return path;
    }

    public static Path createRightRoundPath(Rectangle rectangle, int n) {
        Path path = new Path(null);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = n << 1;
        path.moveTo((float)n2, (float)n3);
        path.lineTo((float)(n2 + n4 - n), (float)n3);
        path.addArc((float)(n2 + n4 - n6), (float)n3, (float)n6, (float)n6, -270.0f, -90.0f);
        path.lineTo((float)(n2 + n4), (float)(n3 + n));
        path.lineTo((float)(n2 + n4), (float)(n3 + n5 - n));
        path.addArc((float)(n2 + n4 - n6), (float)(n3 + n5 - n6), (float)n6, (float)n6, 0.0f, -90.0f);
        path.lineTo((float)(n2 + n4 - n), (float)(n3 + n5));
        path.lineTo((float)n2, (float)(n3 + n5));
        return path;
    }
}

