/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class FramedComposite
extends Composite {
    private int trimSize;
    private int style;

    public FramedComposite(Composite composite, int n) {
        n = FramedComposite.checkStyle(n);
        super(composite, n);
        this.style = n;
        this.trimSize = (n & 0x10) != 0 || (n & 0x40) != 0 ? 2 : 1;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                FramedComposite.this.onPaint(paintEvent);
            }
        });
    }

    private static int checkStyle(int n) {
        int n2 = 124;
        if ((n &= n2) == 0) {
            n = 16;
        }
        return n;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        rectangle.x -= this.trimSize;
        rectangle.y -= this.trimSize;
        rectangle.width += 2 * this.trimSize;
        rectangle.height += 2 * this.trimSize;
        return rectangle;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle rectangle = super.getClientArea();
        rectangle.x += this.trimSize;
        rectangle.y += this.trimSize;
        rectangle.width -= 2 * this.trimSize;
        rectangle.height -= 2 * this.trimSize;
        if (rectangle.width < 0) {
            rectangle.width = 0;
        }
        if (rectangle.height < 0) {
            rectangle.height = 0;
        }
        return rectangle;
    }

    private void onPaint(PaintEvent paintEvent) {
        Rectangle rectangle = super.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        paintEvent.gc.setLineWidth(1);
        Color color = display.getSystemColor(18);
        Color color2 = display.getSystemColor(20);
        if (color == null || color2 == null) {
            return;
        }
        if ((this.style & 0x20) != 0) {
            paintEvent.gc.setForeground(this.getForeground());
            paintEvent.gc.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        if ((this.style & 4) != 0) {
            FramedComposite.drawBevelRect(paintEvent.gc, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, color, color2);
        } else if ((this.style & 8) != 0) {
            FramedComposite.drawBevelRect(paintEvent.gc, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, color2, color);
        } else if ((this.style & 0x10) != 0) {
            FramedComposite.drawBevelRect(paintEvent.gc, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, color, color2);
            FramedComposite.drawBevelRect(paintEvent.gc, rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3, color2, color);
        } else {
            FramedComposite.drawBevelRect(paintEvent.gc, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, color2, color);
            FramedComposite.drawBevelRect(paintEvent.gc, rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 3, color, color2);
        }
    }

    private static void drawBevelRect(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        gC.setForeground(color2);
        gC.drawLine(n + n3, n2, n + n3, n2 + n4);
        gC.drawLine(n, n2 + n4, n + n3, n2 + n4);
        gC.setForeground(color);
        gC.drawLine(n, n2, n + n3 - 1, n2);
        gC.drawLine(n, n2, n, n2 + n4 - 1);
    }
}

