/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.swt.win32.extension.graphics.GraphicsUtil;
import org.sf.feeling.swt.win32.extension.widgets.Bar;
import org.sf.feeling.swt.win32.extension.widgets.CMenu;
import org.sf.feeling.swt.win32.extension.widgets.CMenuItem;
import org.sf.feeling.swt.win32.extension.widgets.MenuControl;
import org.sf.feeling.swt.win32.extension.widgets.MenuDrawCommand;
import org.sf.feeling.swt.win32.extension.widgets.MenuHolder;
import org.sf.feeling.swt.win32.extension.widgets.MenuHolderManager;
import org.sf.feeling.swt.win32.extension.widgets.theme.GeneralThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.GlossyThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.OfficeThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.ThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.VS2005ThemeRender;
import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.graphics.GCExtension;

public final class MenuBar
implements MenuHolder,
Bar {
    private static final int CHEVRON_LENGTH = 12;
    private static final int DRAW_FLAGS = 15;
    private static final int HORIZON_GAP = 5;
    private static final int HORIZON_MARGIN = 2;
    private static final int VERTICAL_MARGIN = 2;
    private static final int KEY_DOWN = 0x1000002;
    private static final int KEY_LEFT = 0x1000003;
    private static final int KEY_RIGHT = 0x1000004;
    private static final int KEY_UP = 0x1000001;
    private static final int SEPARATOR_WIDTH = 15;
    private static final int SHADOW_GAP = 4;
    private static final int VERTICAL_GAP = 1;
    private boolean altKeyDown = false;
    private CMenuItem chevronStartItem;
    private List drawCommands = new ArrayList();
    private boolean drawUpwards;
    private GridLayout layout;
    private CMenu menu = new CMenu();
    private CLabel menubar;
    private Callback mouseCallback;
    private int newAddress;
    private boolean nonAltKeyDown = false;
    private int oldAddress;
    private MenuControl popupMenu;
    private boolean selected = false;
    private int style = 0;
    private ThemeRender theme;
    private int trackItemIndex = -1;

    public MenuBar(Composite composite, int n) {
        this(composite, n, new VS2005ThemeRender());
    }

    public MenuBar(Composite composite, int n, ThemeRender themeRender) {
        this.menubar = new CLabel(composite, n){

            public Point computeSize(int n, int n2, boolean bl) {
                if (this.isVisible()) {
                    Rectangle rectangle = MenuBar.this.recalculate();
                    return new Point(rectangle.width, rectangle.height);
                }
                return super.computeSize(n, n2, bl);
            }
        };
        this.style = n;
        this.layout = new GridLayout();
        this.layout.marginHeight = 0;
        this.layout.marginWidth = 0;
        this.layout.horizontalSpacing = 0;
        this.setTheme(themeRender);
        this.menubar.setLayout((Layout)this.layout);
        this.menubar.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                MenuBar.this.onPaint(paintEvent);
            }
        });
        this.menubar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                MenuBar.this.hideMenu();
                MenuHolderManager.deRegistryShortcut(MenuBar.this);
            }
        });
        final ShellAdapter shellAdapter = new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                MenuBar.this.hideMenu();
            }

            public void shellDeactivated(ShellEvent shellEvent) {
                MenuBar.this.hideMenu();
            }

            public void shellIconified(ShellEvent shellEvent) {
                MenuBar.this.hideMenu();
            }
        };
        this.menubar.getShell().addShellListener((ShellListener)shellAdapter);
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (MenuBar.this.getShell() == null || MenuBar.this.getShell().isDisposed()) {
                    Display.getDefault().removeFilter(3, (Listener)this);
                    return;
                }
                if (event.widget == null || event.widget.isDisposed() || MenuBar.this.checkMouseDownEvent(((Control)event.widget).toDisplay(event.x, event.y))) {
                    MenuBar.this.hideMenu();
                }
            }
        };
        Display.getDefault().addFilter(3, listener);
        final Listener listener2 = new Listener(){

            /*
             * Enabled aggressive block sorting
             */
            public void handleEvent(Event event) {
                KeyEvent keyEvent;
                block46: {
                    block45: {
                        Object object;
                        int n;
                        MenuHolder menuHolder = MenuHolderManager.getActiveHolder();
                        if (menuHolder != null && menuHolder != MenuBar.this) {
                            MenuBar.this.altKeyDown = false;
                            MenuBar.this.nonAltKeyDown = true;
                            return;
                        }
                        if (MenuBar.this.getShell() == null || MenuBar.this.getShell().isDisposed()) {
                            Display.getDefault().removeFilter(1, (Listener)this);
                            return;
                        }
                        keyEvent = new KeyEvent(event);
                        if (keyEvent.keyCode == 65536 || keyEvent.keyCode == 0x1000013) {
                            if (keyEvent.keyCode == 65536) {
                                MenuBar.this.altKeyDown = true;
                            }
                            MenuBar.this.nonAltKeyDown = false;
                        } else {
                            n = keyEvent.keyCode;
                            if (n == 0) {
                                n = keyEvent.character;
                            }
                            object = "&" + (char)n;
                            if (!MenuBar.this.altKeyDown && MenuBar.this.trackItemIndex <= -1 || MenuBar.this.popupMenu != null) {
                                if (MenuBar.this.popupMenu != null) {
                                    if (MenuBar.this.popupMenu.getCurrentMenu() != null) {
                                        MenuBar.this.popupMenu.getCurrentMenu().dealAltKeyEvent(keyEvent);
                                    } else {
                                        MenuBar.this.popupMenu.dealAltKeyEvent(keyEvent);
                                    }
                                }
                            } else {
                                boolean bl = false;
                                for (int i = 0; i < MenuBar.this.menu.getItemCount(); ++i) {
                                    if (MenuBar.this.menu.getItem(i).getText().toLowerCase().indexOf(((String)object).toLowerCase()) <= -1) continue;
                                    MenuBar.this.setSelection(i, true);
                                    Display.getDefault().asyncExec(new Runnable(){

                                        public void run() {
                                            if (MenuBar.this.popupMenu != null) {
                                                MenuBar.this.popupMenu.setSelection(0);
                                            }
                                        }
                                    });
                                    bl = true;
                                    break;
                                }
                                if (!bl && n < 256) {
                                    MenuBar.this.trackItemIndex = -1;
                                    MenuBar.this.refresh();
                                    MenuBar.this.altKeyDown = false;
                                    MenuBar.this.nonAltKeyDown = true;
                                    return;
                                }
                            }
                            MenuBar.this.nonAltKeyDown = true;
                        }
                        if (keyEvent.keyCode == 0x1000004 && MenuBar.this.trackItemIndex > -1) {
                            if (MenuBar.this.popupMenu == null || MenuBar.this.popupMenu.getCurrentMenu() == null || MenuBar.this.popupMenu.getCurrentMenu().isSubMenuEnd()) {
                                MenuBar.this.refresh();
                                n = MenuBar.this.drawCommands.size();
                                if (MenuBar.this.chevronStartItem != null) {
                                    n = MenuBar.this.menu.indexOf(MenuBar.this.chevronStartItem) + 1;
                                }
                                if (++MenuBar.this.trackItemIndex == n) {
                                    MenuBar.this.trackItemIndex = 0;
                                }
                                if (!MenuBar.this.selected) {
                                    MenuBar.this.refresh();
                                    MenuBar.this.drawCommand(MenuBar.this.trackItemIndex, true);
                                    break block45;
                                } else {
                                    if (MenuBar.this.popupMenu != null) {
                                        MenuBar.this.popupMenu.hideMenu();
                                        MenuBar.this.popupMenu = null;
                                    }
                                    MenuBar.this.refresh();
                                    MenuBar.this.drawCommand(MenuBar.this.trackItemIndex, true);
                                    if (MenuBar.this.isShowMenu()) return;
                                    if (!MenuBar.this.selected) return;
                                    object = (MenuDrawCommand)MenuBar.this.drawCommands.get(MenuBar.this.trackItemIndex);
                                    Display.getDefault().asyncExec(new Runnable((MenuDrawCommand)object){
                                        private final /* synthetic */ MenuDrawCommand val$command;
                                        {
                                            this.val$command = menuDrawCommand;
                                        }

                                        public void run() {
                                            MenuBar.this.showMenu(this.val$command);
                                        }
                                    });
                                    return;
                                }
                            }
                            MenuBar.this.popupMenu.getCurrentMenu().subMenuSelected();
                        }
                    }
                    if (keyEvent.keyCode == 0x1000003 && MenuBar.this.trackItemIndex > -1) {
                        if (MenuBar.this.popupMenu == null || MenuBar.this.popupMenu.getCurrentMenu() == null || MenuBar.this.popupMenu.getCurrentMenu() == MenuBar.this.popupMenu) {
                            MenuBar.this.refresh();
                            if (--MenuBar.this.trackItemIndex == -1) {
                                if (MenuBar.this.chevronStartItem != null) {
                                    MenuBar.this.trackItemIndex = MenuBar.this.menu.indexOf(MenuBar.this.chevronStartItem);
                                } else {
                                    MenuBar.this.trackItemIndex = MenuBar.this.drawCommands.size() - 1;
                                }
                            }
                            if (!MenuBar.this.selected) {
                                MenuBar.this.refresh();
                                MenuBar.this.drawCommand(MenuBar.this.trackItemIndex, true);
                                break block46;
                            } else {
                                if (MenuBar.this.popupMenu != null) {
                                    MenuBar.this.popupMenu.hideMenu();
                                    MenuBar.this.popupMenu = null;
                                }
                                MenuBar.this.refresh();
                                MenuBar.this.drawCommand(MenuBar.this.trackItemIndex, true);
                                if (MenuBar.this.isShowMenu()) return;
                                if (!MenuBar.this.selected) return;
                                final MenuDrawCommand menuDrawCommand = (MenuDrawCommand)MenuBar.this.drawCommands.get(MenuBar.this.trackItemIndex);
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        MenuBar.this.showMenu(menuDrawCommand);
                                    }
                                });
                                return;
                            }
                        }
                        MenuBar.this.popupMenu.getCurrentMenu().parentMenuSelected();
                    }
                }
                if ((keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001) && MenuBar.this.trackItemIndex > -1) {
                    if (!MenuBar.this.selected) {
                        MenuBar.this.selected = true;
                        MenuBar.this.refresh();
                        if (!MenuBar.this.isShowMenu() && MenuBar.this.selected) {
                            final MenuDrawCommand menuDrawCommand = (MenuDrawCommand)MenuBar.this.drawCommands.get(MenuBar.this.trackItemIndex);
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    MenuBar.this.showMenu(menuDrawCommand);
                                }
                            });
                        }
                    } else if (MenuBar.this.popupMenu != null) {
                        if (MenuBar.this.popupMenu.getCurrentMenu() == null) {
                            MenuBar.this.popupMenu.setSelection(0);
                        } else if (keyEvent.keyCode == 0x1000002) {
                            MenuBar.this.popupMenu.getCurrentMenu().downSelected();
                        } else {
                            MenuBar.this.popupMenu.getCurrentMenu().upSelected();
                        }
                    }
                }
                if (keyEvent.keyCode == 27) {
                    if (!MenuBar.this.selected) {
                        MenuBar.this.refresh();
                        MenuBar.this.trackItemIndex = -1;
                    } else if (MenuBar.this.popupMenu == null || MenuBar.this.popupMenu.getCurrentMenu() == null || MenuBar.this.popupMenu.getCurrentMenu() == MenuBar.this.popupMenu) {
                        MenuBar.this.selected = false;
                        MenuBar.this.refresh();
                        MenuBar.this.drawCommand(MenuBar.this.trackItemIndex, false);
                        if (MenuBar.this.popupMenu != null) {
                            MenuBar.this.popupMenu.hideMenu();
                            MenuBar.this.popupMenu = null;
                        }
                    } else {
                        MenuBar.this.popupMenu.getCurrentMenu().parentMenuSelected();
                    }
                }
                if (keyEvent.keyCode != 13) return;
                if (MenuBar.this.popupMenu != null && MenuBar.this.popupMenu.getCurrentMenu() != null) {
                    MenuBar.this.popupMenu.getCurrentMenu().handleSelectedEvent();
                    return;
                }
                if (MenuBar.this.popupMenu != null) return;
                if (MenuBar.this.trackItemIndex == -1) return;
                if (MenuBar.this.selected) return;
                MenuBar.this.selected = true;
                MenuBar.this.refresh();
                MenuBar.this.drawCommand(MenuBar.this.trackItemIndex, true);
                if (MenuBar.this.isShowMenu()) return;
                if (!MenuBar.this.selected) return;
                MenuBar.this.showMenu((MenuDrawCommand)MenuBar.this.drawCommands.get(MenuBar.this.trackItemIndex));
            }
        };
        Display.getDefault().addFilter(1, listener2);
        final Listener listener3 = new Listener(){

            public void handleEvent(Event event) {
                MenuHolder menuHolder = MenuHolderManager.getActiveHolder();
                if (menuHolder != null && menuHolder != MenuBar.this) {
                    return;
                }
                if (MenuBar.this.getShell() == null || MenuBar.this.getShell().isDisposed()) {
                    Display.getDefault().removeFilter(2, (Listener)this);
                    return;
                }
                KeyEvent keyEvent = new KeyEvent(event);
                if (!(keyEvent.keyCode != 65536 && keyEvent.keyCode != 0x1000013 || MenuBar.this.nonAltKeyDown || MenuBar.this.drawCommands.size() <= 0)) {
                    if (MenuBar.this.trackItemIndex == -1) {
                        for (int i = 0; i < MenuBar.this.drawCommands.size(); ++i) {
                            MenuDrawCommand menuDrawCommand = (MenuDrawCommand)MenuBar.this.drawCommands.get(i);
                            if (menuDrawCommand.isSeparator() || !menuDrawCommand.isChevron() && !menuDrawCommand.isEnabled()) continue;
                            MenuBar.this.refresh();
                            MenuBar.this.trackItemIndex = i;
                            MenuBar.this.refresh();
                            MenuBar.this.drawCommand(MenuBar.this.trackItemIndex, true);
                            MenuBar.this.getControl().forceFocus();
                            break;
                        }
                    } else {
                        MenuBar.this.selected = false;
                        MenuBar.this.refresh();
                        MenuBar.this.drawCommand(MenuBar.this.trackItemIndex, false);
                        MenuBar.this.trackItemIndex = -1;
                        MenuBar.this.hideMenu();
                    }
                }
                if (keyEvent.keyCode == 65536) {
                    MenuBar.this.altKeyDown = false;
                }
            }
        };
        Display.getDefault().addFilter(2, listener3);
        this.menubar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Display.getDefault().removeFilter(3, listener);
                Display.getDefault().removeFilter(2, listener3);
                Display.getDefault().removeFilter(1, listener2);
                MenuBar.this.menubar.getShell().removeShellListener((ShellListener)shellAdapter);
            }
        });
        this.menubar.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                MenuHolder menuHolder = MenuHolderManager.getActiveHolder();
                if (menuHolder != null && menuHolder != MenuBar.this) {
                    return;
                }
                MenuBar.this.handleMouseMoveEvent(new Point(mouseEvent.x, mouseEvent.y));
            }
        });
        this.menubar.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent mouseEvent) {
                MenuHolder menuHolder = MenuHolderManager.getActiveHolder();
                if (menuHolder != null && menuHolder != MenuBar.this) {
                    return;
                }
                MenuBar.this.handleMouseMoveEvent(new Point(mouseEvent.x, mouseEvent.y));
            }
        });
        this.menubar.addMouseListener((MouseListener)new MouseAdapter(){
            private boolean hideMenuCommand = false;

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button != 1) {
                    return;
                }
                for (int i = 0; i < MenuBar.this.drawCommands.size(); ++i) {
                    MenuDrawCommand menuDrawCommand = (MenuDrawCommand)MenuBar.this.drawCommands.get(i);
                    if (!menuDrawCommand.getDrawRect().contains(mouseEvent.x, mouseEvent.y)) continue;
                    if (!MenuBar.this.selected && !MenuBar.this.isShowMenu()) {
                        MenuBar.this.selected = true;
                        MenuBar.this.refresh();
                        MenuBar.this.trackItemIndex = i;
                        MenuBar.this.refresh();
                        MenuBar.this.drawCommand(MenuBar.this.trackItemIndex, true);
                        MenuBar.this.showMenu(menuDrawCommand);
                    } else {
                        this.hideMenuCommand = true;
                    }
                    return;
                }
                MenuBar.this.selected = false;
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (MenuBar.this.isShowMenu() && this.hideMenuCommand) {
                    this.hideMenuCommand = false;
                    MenuBar.this.popupMenu.hideMenu();
                    MenuBar.this.popupMenu = null;
                    MenuBar.this.selected = false;
                    MenuBar.this.refresh();
                }
            }
        });
        MenuHolderManager.registerHolder(this);
    }

    public boolean checkMouseDownEvent(Point point) {
        if (this.menubar.isDisposed()) {
            return true;
        }
        if (new Rectangle(0, 0, this.menubar.getSize().x, this.menubar.getSize().y).contains(this.menubar.toControl(point))) {
            for (int i = 0; i < this.drawCommands.size(); ++i) {
                MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.drawCommands.get(i);
                if (!menuDrawCommand.getDrawRect().contains(this.menubar.toControl(point))) continue;
                return false;
            }
            return true;
        }
        if (this.popupMenu != null) {
            return this.popupMenu.checkMouseDownEvent(point);
        }
        return true;
    }

    private void drawAllCommands(GC gC) {
        for (int i = 0; i < this.drawCommands.size(); ++i) {
            MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.drawCommands.get(i);
            this.drawSingleCommand(gC, menuDrawCommand, i == this.trackItemIndex);
        }
    }

    private void drawCommand(int n, boolean bl) {
        GC gC = new GC((Drawable)this.menubar);
        this.drawSingleCommand(gC, (MenuDrawCommand)this.drawCommands.get(n), bl);
        gC.dispose();
    }

    public void drawSelectionUpwards() {
        if (this.trackItemIndex != -1 && this.selected) {
            this.drawUpwards = true;
            this.drawCommand(this.trackItemIndex, true);
        }
    }

    private void drawSingleCommand(GC gC, MenuDrawCommand menuDrawCommand, boolean bl) {
        Rectangle rectangle = menuDrawCommand.getDrawRect();
        CMenuItem cMenuItem = menuDrawCommand.getMenuItem();
        if (!menuDrawCommand.isSeparator()) {
            Object object;
            if (menuDrawCommand.isEnabled() && bl) {
                Color[] colorArray;
                if (this.theme instanceof GeneralThemeRender) {
                    object = (GeneralThemeRender)this.theme;
                    if (this.selected) {
                        gC.setForeground(((GeneralThemeRender)object).getMenu_item_bg_selected1());
                        gC.setBackground(((GeneralThemeRender)object).getMenu_item_bg_selected2());
                        gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                        gC.setForeground(((GeneralThemeRender)object).getMenu_item_border_selected());
                        gC.drawRectangle(rectangle);
                    } else {
                        gC.setForeground(((GeneralThemeRender)object).getMenu_item_bg_track1());
                        gC.setBackground(((GeneralThemeRender)object).getMenu_item_bg_track2());
                        gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                        gC.setForeground(((GeneralThemeRender)object).getMenu_item_border_track());
                        gC.drawRectangle(rectangle);
                    }
                } else if (this.theme instanceof OfficeThemeRender) {
                    object = (OfficeThemeRender)this.theme;
                    colorArray = null;
                    colorArray = this.selected ? new Color[]{((OfficeThemeRender)object).getMenu_item_outer_top_selected1(), ((OfficeThemeRender)object).getMenu_item_outer_top_selected2(), ((OfficeThemeRender)object).getMenu_item_outer_bottom_selected1(), ((OfficeThemeRender)object).getMenu_item_outer_bottom_selected2(), ((OfficeThemeRender)object).getMenu_item_inner_top_selected1(), ((OfficeThemeRender)object).getMenu_item_inner_top_selected2(), ((OfficeThemeRender)object).getMenu_item_inner_bottom_selected1(), ((OfficeThemeRender)object).getMenu_item_inner_bottom_selected2(), ((OfficeThemeRender)object).getMenu_item_border_selected()} : new Color[]{((OfficeThemeRender)object).getMenu_item_outer_top_track1(), ((OfficeThemeRender)object).getMenu_item_outer_top_track2(), ((OfficeThemeRender)object).getMenu_item_outer_bottom_track1(), ((OfficeThemeRender)object).getMenu_item_outer_bottom_track2(), ((OfficeThemeRender)object).getMenu_item_inner_top_track1(), ((OfficeThemeRender)object).getMenu_item_inner_top_track2(), ((OfficeThemeRender)object).getMenu_item_inner_bottom_track1(), ((OfficeThemeRender)object).getMenu_item_inner_bottom_track2(), ((OfficeThemeRender)object).getMenu_item_border_track()};
                    this.drawGradientBack(gC, rectangle, colorArray);
                    this.drawGradientBorder(gC, rectangle, colorArray);
                } else if (this.theme instanceof GlossyThemeRender) {
                    object = (GlossyThemeRender)this.theme;
                    gC.setAntialias(1);
                    colorArray = new Rectangle(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
                    Rectangle rectangle2 = GraphicsUtil.inflate((Rectangle)colorArray, -1, -1);
                    Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height / 2);
                    Rectangle rectangle4 = GraphicsUtil.createRectangleFromLTRB(colorArray.x, colorArray.y + Math.round((float)colorArray.height * 0.5f), colorArray.x + colorArray.width, colorArray.y + colorArray.height);
                    Pattern pattern = new Pattern(null, 0.0f, (float)rectangle3.y, 0.0f, (float)(rectangle3.y + rectangle3.height), ((GlossyThemeRender)object).getMenu_item_bg_color1(), ((GlossyThemeRender)object).getMenu_item_bg_color1_alpha(), ((GlossyThemeRender)object).getMenu_item_bg_color2(), ((GlossyThemeRender)object).getMenu_item_bg_color2_alpha());
                    Path path = new Path(null);
                    path.addRectangle((float)rectangle3.x, (float)rectangle3.y, (float)rectangle3.width, (float)rectangle3.height);
                    gC.setBackgroundPattern(pattern);
                    gC.fillPath(path);
                    path.dispose();
                    path = GraphicsUtil.createRoundRectangle((Rectangle)colorArray, 2);
                    gC.setForeground(((GlossyThemeRender)object).getMenu_item_outer_border());
                    gC.drawPath(path);
                    path.dispose();
                    pattern = !this.selected ? new Pattern(null, 0.0f, (float)rectangle3.y, 0.0f, (float)(rectangle3.y + rectangle3.height), ((GlossyThemeRender)object).getMenu_item_bg_glossy_track1(), ((GlossyThemeRender)object).getMenu_item_bg_glossy_track1_alpha(), ((GlossyThemeRender)object).getMenu_item_bg_glossy_track2(), ((GlossyThemeRender)object).getMenu_item_bg_glossy_track2_alpha()) : new Pattern(null, 0.0f, (float)rectangle3.y, 0.0f, (float)(rectangle3.y + rectangle3.height), ((GlossyThemeRender)object).getMenu_item_bg_glossy_selected1(), ((GlossyThemeRender)object).getMenu_item_bg_glossy_selected1_alpha(), ((GlossyThemeRender)object).getMenu_item_bg_glossy_selected2(), ((GlossyThemeRender)object).getMenu_item_bg_glossy_selected2_alpha());
                    path = GraphicsUtil.createTopRoundRectangle(rectangle3, 2);
                    gC.setBackgroundPattern(pattern);
                    gC.fillPath(path);
                    path.dispose();
                    Color color = this.selected || cMenuItem != null && (cMenuItem.getStyle() & 0x20) != 0 && cMenuItem.getSelection() ? ((GlossyThemeRender)object).getMenu_item_inner_border_selected() : ((GlossyThemeRender)object).getMenu_item_inner_border_track();
                    path = GraphicsUtil.createRoundRectangle(rectangle2, 2);
                    gC.setForeground(color);
                    gC.drawPath(path);
                    path.dispose();
                    if (!this.selected) {
                        path = GraphicsUtil.createRoundRectangle(rectangle4, 2);
                        gC.setClipping(path);
                        path.dispose();
                        Color color2 = ((GlossyThemeRender)object).getMenu_item_bg_glow_track();
                        path = this.createBottomRadialPath(rectangle4);
                        float[] fArray = new float[2];
                        float[] fArray2 = new float[4];
                        path.getBounds(fArray2);
                        fArray[0] = (fArray2[0] + fArray2[0] + fArray2[2]) / 2.0f;
                        fArray[1] = (fArray2[1] + fArray2[1] + fArray2[3]) / 2.0f;
                        GCExtension gCExtension = new GCExtension(gC);
                        gCExtension.fillGradientPath(path, fArray, color2, 255, new Color[]{color2}, new int[]{0});
                        path.dispose();
                        gC.setClipping((Path)null);
                    }
                    gC.setAdvanced(false);
                }
                if (this.selected) {
                    this.showMenuShadow(gC, menuDrawCommand.getSelectRect(), menuDrawCommand.getMenuItem());
                }
            }
            if (menuDrawCommand.isChevron) {
                object = this.theme.getMenu_chevronImage();
                int n = rectangle.y + 1;
                int n2 = rectangle.x + (rectangle.width - object.getImageData().width) / 2 + 1;
                if (this.selected && bl) {
                    ++n2;
                    ++n;
                }
                gC.drawImage((Image)object, n2, n);
            } else {
                if (menuDrawCommand.isEnabled() && this.menubar.isEnabled()) {
                    gC.setForeground(this.theme.getMenu_item_fg());
                } else {
                    gC.setForeground(this.theme.getMenu_item_fg_disabled());
                }
                int n = gC.getFontMetrics().getHeight();
                int n3 = gC.textExtent((String)cMenuItem.getText(), (int)15).x;
                gC.drawText(cMenuItem.getText(), rectangle.x + (rectangle.width - n3) / 2, rectangle.y + (rectangle.height - n) / 2, 15);
            }
        }
    }

    private Path createBottomRadialPath(Rectangle rectangle) {
        float[] fArray = new float[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        fArray[0] = fArray[0] - fArray[2] * 0.35f;
        fArray[1] = fArray[1] - fArray[3] * 0.15f;
        fArray[2] = fArray[2] * 1.7f;
        fArray[3] = fArray[3] * 2.3f;
        return GraphicsUtil.createEllipsePath(fArray);
    }

    private void drawGradientBack(GC gC, Rectangle rectangle, Color[] colorArray) {
        gC.setAdvanced(true);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        Rectangle rectangle3 = GraphicsUtil.inflate(rectangle2, -1, -1);
        int n = rectangle3.height / 2;
        Rectangle rectangle4 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, n);
        Rectangle rectangle5 = new Rectangle(rectangle3.x, rectangle3.y + n, rectangle3.width, rectangle3.height - n);
        gC.setForeground(colorArray[0]);
        gC.setBackground(colorArray[1]);
        gC.fillGradientRectangle(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, true);
        gC.setForeground(colorArray[2]);
        gC.setBackground(colorArray[3]);
        gC.fillGradientRectangle(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height, true);
        Rectangle rectangle6 = GraphicsUtil.inflate(rectangle3, -1, -1);
        n = rectangle6.height / 2;
        rectangle4 = new Rectangle(rectangle6.x, rectangle6.y, rectangle6.width, n);
        rectangle5 = new Rectangle(rectangle6.x, rectangle6.y + n, rectangle6.width, rectangle6.height - n);
        gC.setForeground(colorArray[4]);
        gC.setBackground(colorArray[5]);
        gC.fillGradientRectangle(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, true);
        gC.setForeground(colorArray[6]);
        gC.setBackground(colorArray[7]);
        gC.fillGradientRectangle(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height, true);
        gC.setAdvanced(false);
    }

    private void drawGradientBorder(GC gC, Rectangle rectangle, Color[] colorArray) {
        if (GraphicsUtil.checkGdip()) {
            gC.setAdvanced(true);
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Path path = GraphicsUtil.createRoundPath(rectangle2, 1.2f);
            gC.setForeground(colorArray[8]);
            gC.drawPath(path);
            path.dispose();
            gC.setAdvanced(false);
        } else {
            gC.setForeground(colorArray[8]);
            gC.drawRectangle(rectangle);
        }
    }

    public Color getBackground() {
        if (this.menubar != null && !this.menubar.isDisposed()) {
            return this.menubar.getBackground();
        }
        return null;
    }

    public Control getControl() {
        return this.menubar;
    }

    protected MenuDrawCommand getCurrentCommand() {
        if (this.menubar.isDisposed()) {
            return null;
        }
        if (this.trackItemIndex < 0 || this.trackItemIndex >= this.drawCommands.size()) {
            return null;
        }
        return (MenuDrawCommand)this.drawCommands.get(this.trackItemIndex);
    }

    public CMenu getMenu() {
        return this.menu;
    }

    public CMenuItem getSelection() {
        if (this.trackItemIndex == -1) {
            return null;
        }
        MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.drawCommands.get(this.trackItemIndex);
        if (menuDrawCommand == null) {
            return null;
        }
        return menuDrawCommand.getMenuItem();
    }

    public int getSelectionIndex() {
        return this.trackItemIndex;
    }

    public Shell getShell() {
        if (this.menubar.isDisposed()) {
            return null;
        }
        return this.menubar.getShell();
    }

    public ThemeRender getTheme() {
        return this.theme;
    }

    private void handleMouseMoveEvent(Point point) {
        for (int i = 0; i < this.drawCommands.size(); ++i) {
            final MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.drawCommands.get(i);
            if (!menuDrawCommand.getDrawRect().contains(point.x, point.y)) continue;
            if (this.trackItemIndex != i) {
                if (this.popupMenu != null) {
                    this.popupMenu.hideMenu();
                    this.popupMenu = null;
                }
                this.refresh();
                this.trackItemIndex = i;
                this.refresh();
                this.drawCommand(this.trackItemIndex, true);
                if (!this.isShowMenu() && this.selected) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            MenuBar.this.showMenu(menuDrawCommand);
                        }
                    });
                }
                return;
            }
            return;
        }
        if (this.trackItemIndex >= 0 && !this.selected) {
            this.refresh();
            this.drawCommand(this.trackItemIndex, false);
            this.trackItemIndex = -1;
        }
    }

    public void hideMenu() {
        if (this.popupMenu != null) {
            this.popupMenu.hideMenu();
            this.popupMenu = null;
        }
        if (this.menubar.isDisposed()) {
            return;
        }
        this.selected = false;
        this.refresh();
        this.trackItemIndex = -1;
    }

    private void installMouseHook() {
        this.mouseCallback = new Callback((Object)this, "MouseProc", 3);
        this.newAddress = this.mouseCallback.getAddress();
        if (this.newAddress == 0) {
            SWT.error((int)3);
        }
        int n = Extension.GetCurrentThreadId();
        this.oldAddress = Extension.SetWindowsHookEx((int)7, (int)this.newAddress, (int)0, (int)n);
        this.popupMenu.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (MenuBar.this.mouseCallback != null) {
                    Extension.UnhookWindowsHookEx((int)MenuBar.this.oldAddress);
                    MenuBar.this.mouseCallback.dispose();
                    MenuBar.this.mouseCallback = null;
                    MenuBar.this.newAddress = 0;
                }
            }
        });
    }

    public boolean isMultiLine() {
        return (this.style & 2) != 0;
    }

    private boolean isShowMenu() {
        return this.popupMenu != null && !this.popupMenu.getShell().isDisposed();
    }

    int MouseProc(int n, int n2, int n3) {
        int n4 = Extension.CallNextHookEx((int)this.oldAddress, (int)n, (int)n2, (int)n3);
        if (n < 0) {
            return n4;
        }
        switch (n2) {
            case 161: 
            case 164: {
                this.hideMenu();
            }
        }
        return n4;
    }

    private void onPaint(PaintEvent paintEvent) {
        this.recalculate();
        this.menubar.getParent().layout();
        this.drawAllCommands(paintEvent.gc);
    }

    protected Rectangle recalculate() {
        int n = this.menubar.getSize().x;
        if (n > 0) {
            CMenuItem cMenuItem;
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 10;
            int n6 = 2;
            int n7 = 2;
            n = (this.style & 2) == 0 ? (n -= 15) : (n -= 5);
            this.drawCommands.clear();
            this.chevronStartItem = null;
            GC gC = new GC((Drawable)this.menubar);
            int n8 = gC.getFontMetrics().getHeight() / 3;
            int n9 = gC.getFontMetrics().getHeight() + n8 * 2 + 1;
            int n10 = 0;
            for (n2 = 0; n2 < this.menu.getItemCount(); ++n2) {
                cMenuItem = this.menu.getItem(n2);
                if (!cMenuItem.isVisible()) continue;
                int n11 = 0;
                n11 = cMenuItem.getText().equals("-") || (cMenuItem.getStyle() & 2) != 0 ? 15 : n5 + gC.textExtent((String)cMenuItem.getText(), (int)15).x + 1;
                Rectangle rectangle = new Rectangle(n6, 1 + n9 * n3, n11, n9);
                if ((n6 += n11) > n && ++n4 > 1) {
                    if ((this.style & 2) != 0) {
                        ++n3;
                        n4 = 1;
                        n6 = n11;
                        rectangle.x = 2;
                        rectangle.y += n9;
                    } else {
                        if (n10 <= this.trackItemIndex) {
                            this.removeItemTracking();
                        }
                        this.chevronStartItem = cMenuItem;
                        rectangle.y = 0;
                        rectangle.width = 14;
                        rectangle.x = this.menubar.getClientArea().width - rectangle.width - 1;
                        rectangle.height = n9 + n7 - 2;
                        this.drawCommands.add(new MenuDrawCommand(rectangle));
                        break;
                    }
                }
                Rectangle rectangle2 = rectangle;
                --rectangle2.height;
                this.drawCommands.add(new MenuDrawCommand(cMenuItem, rectangle, rectangle2));
                ++n10;
            }
            gC.dispose();
            n2 = (n3 + 1) * n9 + 2 * n7 - 2;
            if (this.menubar.getBounds().height != n2) {
                cMenuItem = new Rectangle(this.menubar.getBounds().x, this.menubar.getBounds().y, this.menubar.getBounds().width, n2);
                return cMenuItem;
            }
        }
        return this.menubar.getBounds();
    }

    public void refresh() {
        if (this.menubar != null && !this.menubar.isDisposed()) {
            this.menubar.redraw();
        }
    }

    private void removeItemTracking() {
        if (this.trackItemIndex != -1 && this.trackItemIndex < this.drawCommands.size()) {
            MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.drawCommands.get(this.trackItemIndex);
            if (menuDrawCommand.getMenuItem() != null) {
                Event event = new Event();
                event.data = menuDrawCommand.getMenuItem();
                event.detail = 27;
                this.menubar.notifyListeners(27, event);
            }
            this.trackItemIndex = -1;
        }
    }

    public void setMenu(CMenu cMenu) {
        if (this.menu != null) {
            MenuHolderManager.deRegistryShortcut(this);
        }
        this.menu = cMenu;
        MenuHolderManager.registryShortcut(this);
    }

    public void setMultiLine(boolean bl) {
        this.style = !bl ? (this.style &= 0xFFFFFFFD) : (this.style |= 2);
    }

    public void setSelection(int n, boolean bl) {
        if (this.drawCommands.size() > 0) {
            if (n > -1 && n < this.drawCommands.size()) {
                MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.drawCommands.get(n);
                if (!menuDrawCommand.isSeparator() && (menuDrawCommand.isChevron() || menuDrawCommand.isEnabled())) {
                    this.refresh();
                    this.trackItemIndex = n;
                    this.selected = bl;
                    this.refresh();
                    this.drawCommand(this.trackItemIndex, true);
                    if (this.selected) {
                        this.showMenu(menuDrawCommand);
                    }
                }
            } else {
                this.selected = false;
                this.refresh();
                this.drawCommand(this.trackItemIndex, false);
                this.trackItemIndex = -1;
                this.hideMenu();
            }
        }
    }

    public void setTheme(ThemeRender themeRender) {
        if (this.menubar == null || this.menubar.isDisposed() || themeRender == null) {
            return;
        }
        if (!GraphicsUtil.checkGdip() && themeRender instanceof GlossyThemeRender) {
            return;
        }
        this.theme = themeRender;
        if (themeRender.getMenubar_bgColors_percents() == null) {
            this.menubar.setBackground(themeRender.getMenubar_bgColors()[0]);
        } else {
            this.menubar.setBackground(themeRender.getMenubar_bgColors(), themeRender.getMenubar_bgColors_percents(), false);
        }
    }

    private void showMenu(MenuDrawCommand menuDrawCommand) {
        if (menuDrawCommand == null || this.getCurrentCommand() == null) {
            return;
        }
        if (menuDrawCommand.getMenuItem() != this.getCurrentCommand().getMenuItem()) {
            return;
        }
        if (menuDrawCommand.isChevron()) {
            CMenu cMenu = new CMenu();
            int n = this.menu.indexOf(this.chevronStartItem);
            if (n > 0) {
                for (int i = n; i < this.menu.getItemCount(); ++i) {
                    cMenu.addItem(this.menu.getItem(i));
                }
                if (cMenu.getItemCount() > 0) {
                    this.drawUpwards = false;
                    this.popupMenu = new MenuControl(this, this.theme);
                    this.popupMenu.menu = cMenu;
                    this.popupMenu.bar = this;
                    this.popupMenu.leftScreenPos = this.popupMenu.screenPos = this.menubar.toDisplay(new Point(menuDrawCommand.getDrawRect().x, menuDrawCommand.getDrawRect().y + menuDrawCommand.getDrawRect().height));
                    this.popupMenu.aboveScreenPos = this.menubar.toDisplay(new Point(menuDrawCommand.getDrawRect().x, menuDrawCommand.getDrawRect().y + 2));
                    this.popupMenu.borderGap = menuDrawCommand.getDrawRect().width;
                    Event event = new Event();
                    event.data = this.popupMenu;
                    event.type = 4096;
                    this.popupMenu.menu.fireMenuEvent(event);
                    this.popupMenu.createAndShowWindow();
                    this.installMouseHook();
                }
            }
        } else {
            if (this.popupMenu != null || menuDrawCommand.getMenuItem() == null) {
                return;
            }
            if (!menuDrawCommand.getMenuItem().isEnabled()) {
                return;
            }
            if (menuDrawCommand.getMenuItem().getMenu() == null) {
                return;
            }
            this.drawUpwards = false;
            this.popupMenu = new MenuControl(this, this.theme);
            this.popupMenu.menu = menuDrawCommand.getMenuItem().getMenu();
            this.popupMenu.bar = this;
            this.popupMenu.leftScreenPos = this.popupMenu.screenPos = this.menubar.toDisplay(new Point(menuDrawCommand.getDrawRect().x, menuDrawCommand.getDrawRect().y + menuDrawCommand.getDrawRect().height));
            this.popupMenu.aboveScreenPos = this.menubar.toDisplay(new Point(menuDrawCommand.getDrawRect().x, menuDrawCommand.getDrawRect().y + 2));
            this.popupMenu.borderGap = menuDrawCommand.getDrawRect().width;
            Event event = new Event();
            event.data = this.popupMenu;
            event.type = 4096;
            this.popupMenu.menu.fireMenuEvent(event);
            this.popupMenu.createAndShowWindow();
            this.installMouseHook();
        }
    }

    private void showMenuShadow(GC gC, Rectangle rectangle, CMenuItem cMenuItem) {
        if (!GraphicsUtil.checkGdip() || !this.theme.isShowMenuItemShadow()) {
            return;
        }
        if (cMenuItem == null) {
            return;
        }
        gC.setAdvanced(true);
        if (cMenuItem.getMenu() != null && cMenuItem.getMenu().getItemCount() > 0 && cMenuItem.isEnabled()) {
            if (this.drawUpwards) {
                int n = rectangle.x + rectangle.width + 1;
                int n2 = rectangle.y + 1;
                int n3 = rectangle.y + rectangle.height + 1;
                int n4 = rectangle.x + 4;
                int n5 = rectangle.width + 1;
                int n6 = 4;
                Pattern pattern = new Pattern(gC.getDevice(), (float)n, 9999.0f, (float)(n + 4), 9999.0f, this.theme.getMenuShadowColor(), 48, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n, n2, 4, rectangle.height));
                pattern.dispose();
                pattern = new Pattern(gC.getDevice(), (float)(n4 + 4), (float)(n3 - 4), (float)n4, (float)(n3 + n6), this.theme.getMenuShadowColor(), 64, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n4, n3, 4, n6));
                pattern.dispose();
                pattern = new Pattern(gC.getDevice(), (float)(n4 + n5 - 4 - 2), (float)(n3 - 4 - 2), (float)(n4 + n5), (float)(n3 + n6), this.theme.getMenuShadowColor(), 64, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n4 + n5 - 4, n3, 3, n6 - 1));
                pattern.dispose();
                pattern = new Pattern(gC.getDevice(), 9999.0f, (float)n3, 9999.0f, (float)(n3 + n6), this.theme.getMenuShadowColor(), 48, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n4 + 4, n3, n5 - 8, n6));
                pattern.dispose();
            } else {
                int n = rectangle.x + rectangle.width + 1;
                int n7 = rectangle.y + 4;
                Pattern pattern = new Pattern(gC.getDevice(), (float)(n - 4), (float)(n7 + 4), (float)(n + 4), (float)n7, this.theme.getMenuShadowColor(), 64, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n, rectangle.y + 4, 2, 1));
                gC.fillRectangle(new Rectangle(n, rectangle.y + 1 + 4, 3, 1));
                gC.fillRectangle(new Rectangle(n, rectangle.y + 2 + 4, 4, 2));
                pattern.dispose();
                pattern = new Pattern(gC.getDevice(), (float)n, 9999.0f, (float)(n + 4), 9999.0f, this.theme.getMenuShadowColor(), 48, this.theme.getMenuShadowColor(), 0);
                gC.setForegroundPattern(pattern);
                gC.setBackgroundPattern(pattern);
                gC.fillRectangle(new Rectangle(n, n7 += 4, 4, rectangle.y + rectangle.height - n7 + 1));
                pattern.dispose();
            }
        }
        gC.setAdvanced(false);
    }

    public boolean isAcitve() {
        return this.trackItemIndex > -1;
    }
}

