/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.swt.win32.extension.Win32;
import org.sf.feeling.swt.win32.extension.graphics.GraphicsUtil;
import org.sf.feeling.swt.win32.extension.shell.Windows;
import org.sf.feeling.swt.win32.extension.widgets.Bar;
import org.sf.feeling.swt.win32.extension.widgets.CMenu;
import org.sf.feeling.swt.win32.extension.widgets.CMenuItem;
import org.sf.feeling.swt.win32.extension.widgets.MenuDrawCommand;
import org.sf.feeling.swt.win32.extension.widgets.MenuHolder;
import org.sf.feeling.swt.win32.extension.widgets.theme.GeneralThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.GlossyThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.OfficeThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.ThemeRender;
import org.sf.feeling.swt.win32.internal.extension.graphics.GCExtension;

public class MenuControl {
    protected List commands;
    protected CMenu menu;
    protected static final int[] POSITION = new int[]{2, 1, 0, 1, 2, 4, 3, 5, 4, 4, 2, 6, 5, 5, 1, 10, 2, 2, 0, 0};
    protected static int DRAW_FLAGS = 15;
    protected static final int IMAGE_WIDTH = 16;
    protected static final int IMAGE_HEIGHT = 16;
    protected ThemeRender theme;
    protected Shell shell;
    protected MenuHolder holder;
    protected int trackItemIndex = -1;
    protected boolean ignoreTaskbar = false;
    protected Point screenPos;
    private boolean excludeTop;
    private int excludeOffset;
    protected MenuControl parentMenu;
    protected Bar bar;
    protected Point aboveScreenPos;
    protected CMenuItem parentMenuItem;
    protected int borderGap;
    protected Point leftScreenPos;
    protected MenuControl popupMenu;
    private int cellMinHeight;
    protected boolean popupRight = true;
    protected boolean isPopupMenu = false;
    private int shortCutWidth;

    protected MenuControl(MenuHolder menuHolder, ThemeRender themeRender) {
        this.holder = menuHolder;
        this.theme = themeRender;
    }

    protected void createAndShowWindow() {
        Point point = this.generateDrawPositions();
        Point point2 = this.correctPositionForScreen(point);
        if (this.menu == null || this.menu.getItemCount() == 0) {
            point = new Point(0, 0);
        }
        if (this.shell == null || this.shell.isDisposed()) {
            int n = 540684;
            if (Win32.getWin32Version() < Win32.VERSION(5, 0)) {
                n = 540672;
            }
            this.shell = new Shell(this.holder.getShell(), n);
            if (Win32.getWin32Version() < Win32.VERSION(5, 0)) {
                Windows.hideTitleBar(this.shell.handle);
            }
            this.shell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    MenuControl.this.refreshAllCommands(paintEvent.gc);
                }
            });
            Display.getDefault().addFilter(3, new Listener(){

                public void handleEvent(Event event) {
                    if (MenuControl.this.shell == null || MenuControl.this.shell.isDisposed()) {
                        Display.getDefault().removeFilter(3, (Listener)this);
                        return;
                    }
                    if (MenuControl.this.holder.checkMouseDownEvent(((Control)event.widget).toDisplay(event.x, event.y))) {
                        MenuControl.this.holder.hideMenu();
                    }
                }
            });
            this.shell.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent mouseEvent) {
                    MenuControl.this.handleMouseMoveEvent(mouseEvent);
                }
            });
            this.shell.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent mouseEvent) {
                    MenuControl.this.handleMouseMoveEvent(mouseEvent);
                }

                public void mouseExit(MouseEvent mouseEvent) {
                    MenuDrawCommand menuDrawCommand;
                    if (MenuControl.this.trackItemIndex != -1 && (menuDrawCommand = (MenuDrawCommand)MenuControl.this.commands.get(MenuControl.this.trackItemIndex)).getMenuItem().getMenu() == null) {
                        MenuControl.this.handleMouseMoveEvent(mouseEvent);
                    }
                }
            });
            this.shell.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent mouseEvent) {
                    if (MenuControl.this.trackItemIndex != -1 && mouseEvent.button == 1) {
                        MenuControl.this.handleSelectedEvent();
                    }
                }
            });
        }
        this.shell.setLocation(point2);
        this.shell.setSize(point);
        new Thread(){

            public void run() {
                try {
                    if (MenuControl.this.parentMenu != null) {
                        Thread.sleep(300L);
                    } else {
                        Thread.sleep(50L);
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (!(this).MenuControl.this.shell.isDisposed()) {
                                if (Win32.getWin32Version() >= Win32.VERSION(5, 0)) {
                                    Windows.showWindowBlend((this).MenuControl.this.shell.handle, 200);
                                } else {
                                    (this).MenuControl.this.shell.setVisible(true);
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    private Point generateDrawPositions() {
        int n;
        int n2;
        this.commands = new ArrayList();
        this.cellMinHeight = POSITION[4] + 16 + POSITION[6];
        int n3 = POSITION[5] + 16 + POSITION[7] + POSITION[8] + POSITION[9] + POSITION[10] + POSITION[11] + POSITION[12];
        GC gC = new GC((Drawable)this.holder.getShell());
        int n4 = gC.getFontMetrics().getHeight();
        if (n4 < this.cellMinHeight) {
            n4 = this.cellMinHeight;
        }
        int n5 = Display.getDefault().getClientArea().height;
        int n6 = POSITION[1];
        int n7 = n2 = POSITION[0];
        int n8 = n3;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        ArrayList<MenuDrawCommand> arrayList = new ArrayList<MenuDrawCommand>();
        this.shortCutWidth = 0;
        for (n = 0; this.menu != null && n < this.menu.getItemCount(); ++n) {
            MenuDrawCommand menuDrawCommand;
            Point point;
            CMenuItem cMenuItem = this.menu.getItem(n);
            if (!cMenuItem.isVisible() || cMenuItem.getMenu() != null && cMenuItem.getMenu().getItemCount() > 0 && !cMenuItem.getMenu().visibleItems()) continue;
            int n13 = 0;
            int n14 = 0;
            if (cMenuItem.getText().equals("-") || (cMenuItem.getStyle() & 2) != 0) {
                n13 = n3;
                n14 = POSITION[13];
            } else {
                n14 = n4;
                point = gC.textExtent(cMenuItem.getText(), DRAW_FLAGS);
                n13 = n3 + point.x + 1;
                if (cMenuItem.getShortcut() != null) {
                    point = gC.stringExtent(cMenuItem.getShortcut().toString());
                    if (point.x > this.shortCutWidth) {
                        this.shortCutWidth = point.x;
                    }
                }
            }
            if (n7 + n14 >= n5) {
                n11 = 0;
                ++n12;
                this.applySizeToColumnList(arrayList, n8);
                int n15 = POSITION[14];
                menuDrawCommand = new MenuDrawCommand(new Rectangle(n6 += n8, n2, n15, 0), false);
                this.commands.add(menuDrawCommand);
                n6 += n15;
                n7 = n2;
                n9 += n8 + n15;
                n8 = n3;
            }
            point = new Rectangle(n6, n7, n13, n14);
            menuDrawCommand = new MenuDrawCommand(cMenuItem, (Rectangle)point, n11, n12);
            if (this.commands.size() > 0) {
                for (int i = this.commands.size() - 1; i >= 0; --i) {
                    if (((MenuDrawCommand)this.commands.get(i)).isSeparator()) continue;
                    ((MenuDrawCommand)this.commands.get((int)i)).bottomBorder = true;
                    break;
                }
            }
            this.commands.add(menuDrawCommand);
            arrayList.add(menuDrawCommand);
            if (n13 > n8) {
                n8 = n13;
            }
            if ((n7 += n14) > n10) {
                n10 = n7;
            }
            ++n11;
        }
        this.applySizeToColumnList(arrayList, n8 += POSITION[15] + this.shortCutWidth + 1);
        gC.dispose();
        n = POSITION[1] + n9 + n8 + POSITION[3];
        int n16 = POSITION[0] + n10 + POSITION[2];
        return new Point(n, n16);
    }

    private void applySizeToColumnList(ArrayList arrayList, int n) {
        for (int i = 0; i < arrayList.size(); ++i) {
            MenuDrawCommand menuDrawCommand = (MenuDrawCommand)arrayList.get(i);
            Rectangle rectangle = menuDrawCommand.getDrawRect();
            menuDrawCommand.setDrawRect(new Rectangle(rectangle.x, rectangle.y, n, rectangle.height));
        }
        arrayList.clear();
    }

    private Point correctPositionForScreen(Point point) {
        Rectangle rectangle = !this.ignoreTaskbar ? this.holder.getShell().getMonitor().getClientArea() : this.holder.getShell().getMonitor().getBounds();
        Point point2 = this.screenPos;
        int n = rectangle.width;
        int n2 = rectangle.x;
        int n3 = n2 + n;
        int n4 = rectangle.height;
        int n5 = rectangle.y;
        int n6 = n5 + n4;
        this.excludeTop = true;
        this.excludeOffset = 0;
        if (point2.y + point.y > n6) {
            if (this.bar != null && this.parentMenu == null) {
                if (this.aboveScreenPos.y - point.y > n5) {
                    point2.y = this.aboveScreenPos.y - point.y;
                    this.excludeTop = false;
                    this.bar.drawSelectionUpwards();
                }
            } else if (this.isPopupMenu()) {
                point2.y -= point.y;
            }
            if (point2.y + point.y > n6) {
                if (this.parentMenu != null) {
                    point2.y = this.aboveScreenPos.y - point.y > n5 ? this.aboveScreenPos.y + 1 - point.y + this.cellMinHeight : n5;
                } else {
                    point2.y = n6 - point.y - 1;
                    if (this.parentMenuItem != null) {
                        GC gC = new GC((Drawable)this.holder.getShell());
                        Point point3 = gC.stringExtent(this.parentMenuItem.getText());
                        gC.dispose();
                        point2.x += point3.x;
                        this.borderGap = 0;
                    }
                }
            }
        }
        if (this.popupRight) {
            if (point2.x + point.x > n3) {
                if (this.parentMenu != null || this.isPopupMenu()) {
                    this.popupRight = false;
                    point2.x = this.leftScreenPos.x - point.x;
                    if (point2.x < n2) {
                        point2.x = n2;
                    }
                } else {
                    int n7 = n3 - point.x - 1;
                    this.excludeOffset = point2.x - n7;
                    point2.x = n7;
                }
            }
        } else {
            point2.x = this.leftScreenPos.x;
            if (point2.x - point.x < n2) {
                this.popupRight = true;
                point2.x = this.screenPos.x + point.x > n3 ? n3 - point.x - 1 : this.screenPos.x;
            } else {
                point2.x -= point.x;
            }
        }
        return point2;
    }

    private boolean isPopupMenu() {
        return this.isPopupMenu;
    }

    private void refreshAllCommands(GC gC) {
        this.drawBackground(gC, this.shell.getSize());
        this.drawAllCommands(gC);
        if (this.trackItemIndex != -1) {
            this.drawCommand(gC, this.trackItemIndex, true);
        }
    }

    private void drawAllCommands(GC gC) {
        for (int i = 0; i < this.commands.size(); ++i) {
            MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.commands.get(i);
            this.drawSingleCommand(gC, menuDrawCommand, false);
        }
    }

    private void drawBackground(GC gC, Point point) {
        Rectangle rectangle = new Rectangle(0, 0, point.x - 1, point.y - 1);
        int n = POSITION[5] + 16 + POSITION[7];
        int n2 = POSITION[1];
        int n3 = POSITION[0];
        int n4 = rectangle.height - n3 - POSITION[2] - 1;
        Rectangle rectangle2 = new Rectangle(n2, n3, n, n4);
        gC.setBackground(this.theme.getMenu_control_bg());
        gC.fillRectangle(rectangle);
        gC.setForeground(this.theme.getMenu_control_fg());
        gC.drawRectangle(rectangle);
        if (this.borderGap > 0) {
            gC.setBackground(this.theme.getMenu_control_bg());
            int n5 = this.borderGap - 1;
            if (this.theme instanceof GlossyThemeRender) {
                ++n5;
            }
            if (this.excludeTop) {
                gC.fillRectangle(rectangle.x + 1 + this.excludeOffset, rectangle.y, n5, 1);
            } else {
                gC.fillRectangle(rectangle.x + 1 + this.excludeOffset, rectangle.y + rectangle.height, n5, 1);
            }
        }
        if (this.theme instanceof GeneralThemeRender || this.theme instanceof GlossyThemeRender) {
            gC.setBackground(this.theme.getMenu_control_image_rect_bg());
            gC.setForeground(this.theme.getMenu_control_image_rect_fg());
            gC.fillGradientRectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, false);
        } else if (this.theme instanceof OfficeThemeRender) {
            gC.setBackground(this.theme.getMenu_control_image_rect_bg());
            gC.fillRectangle(rectangle2);
            gC.setForeground(this.theme.getMenu_control_image_rect_fg());
            gC.drawLine(rectangle2.x + rectangle2.width - 1, rectangle2.y + 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 2);
        }
    }

    private void drawSingleCommand(GC gC, MenuDrawCommand menuDrawCommand, boolean bl) {
        Rectangle rectangle = menuDrawCommand.getDrawRect();
        CMenuItem cMenuItem = menuDrawCommand.getMenuItem();
        int n = POSITION[8];
        int n2 = POSITION[5];
        int n3 = POSITION[7];
        int n4 = rectangle.x + n2;
        int n5 = n2 + 16 + n3;
        int n6 = rectangle.x + rectangle.width - POSITION[12] - POSITION[11];
        int n7 = n6 - POSITION[10] - POSITION[9];
        if (menuDrawCommand.isSeparator()) {
            gC.setForeground(this.theme.getMenu_control_item_separater_color());
            gC.drawLine(rectangle.x + n5 + n, rectangle.y + 2, rectangle.x + rectangle.width - 3, rectangle.y + 2);
        } else {
            Object object;
            Object object2;
            PaletteData paletteData;
            ImageData imageData;
            Pattern pattern;
            Rectangle rectangle2;
            Rectangle rectangle3;
            Rectangle rectangle4;
            Rectangle rectangle5;
            int n8 = rectangle.x + n5 + n;
            if (bl) {
                Color[] colorArray;
                ThemeRender themeRender;
                rectangle5 = new Rectangle(rectangle.x + 1, rectangle.y, rectangle.width - 3, rectangle.height - 1);
                if (this.theme instanceof GeneralThemeRender) {
                    gC.setBackground(((GeneralThemeRender)this.theme).getMenu_control_item_bg_track());
                    gC.fillRectangle(rectangle5);
                    gC.setForeground(((GeneralThemeRender)this.theme).getMenu_control_item_border_track());
                    gC.drawRectangle(rectangle5);
                } else if (this.theme instanceof OfficeThemeRender) {
                    themeRender = (OfficeThemeRender)this.theme;
                    colorArray = new Color[]{((OfficeThemeRender)themeRender).getMenu_control_item_outer_top_track1(), ((OfficeThemeRender)themeRender).getMenu_control_item_outer_top_track2(), ((OfficeThemeRender)themeRender).getMenu_control_item_outer_bottom_track1(), ((OfficeThemeRender)themeRender).getMenu_control_item_outer_bottom_track2(), ((OfficeThemeRender)themeRender).getMenu_control_item_inner_top_track1(), ((OfficeThemeRender)themeRender).getMenu_control_item_inner_top_track2(), ((OfficeThemeRender)themeRender).getMenu_control_item_inner_bottom_track1(), ((OfficeThemeRender)themeRender).getMenu_control_item_inner_bottom_track2(), ((OfficeThemeRender)themeRender).getMenu_control_item_border_track()};
                    this.drawGradientBack(gC, rectangle5, colorArray);
                    this.drawGradientBorder(gC, rectangle5, colorArray);
                } else if (this.theme instanceof GlossyThemeRender) {
                    themeRender = (GlossyThemeRender)this.theme;
                    colorArray = new Rectangle(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
                    rectangle4 = GraphicsUtil.inflate((Rectangle)colorArray, -1, -1);
                    rectangle3 = new Rectangle(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height / 2);
                    rectangle2 = GraphicsUtil.createRectangleFromLTRB(colorArray.x, colorArray.y + Math.round((float)colorArray.height * 0.5f), colorArray.x + colorArray.width, colorArray.y + colorArray.height);
                    gC.setBackground(((GlossyThemeRender)themeRender).getMenu_control_item_bg_track());
                    gC.fillRectangle(rectangle4);
                    gC.setAntialias(1);
                    pattern = new Pattern(null, 0.0f, (float)rectangle3.y, 0.0f, (float)(rectangle3.y + rectangle3.height), ((GlossyThemeRender)themeRender).getMenu_control_item_bg_color1(), ((GlossyThemeRender)themeRender).getMenu_control_item_bg_color1_alpha(), ((GlossyThemeRender)themeRender).getMenu_control_item_bg_color2(), ((GlossyThemeRender)themeRender).getMenu_control_item_bg_color2_alpha());
                    Path path = new Path(null);
                    path.addRectangle((float)rectangle3.x, (float)rectangle3.y, (float)rectangle3.width, (float)rectangle3.height);
                    gC.setBackgroundPattern(pattern);
                    gC.fillPath(path);
                    path.dispose();
                    path = GraphicsUtil.createRoundRectangle((Rectangle)colorArray, 2);
                    gC.setForeground(((GlossyThemeRender)themeRender).getMenu_control_item_outer_border());
                    gC.drawPath(path);
                    path.dispose();
                    pattern = new Pattern(null, 0.0f, (float)rectangle3.y, 0.0f, (float)(rectangle3.y + rectangle3.height), ((GlossyThemeRender)themeRender).getMenu_control_item_bg_glossy_track1(), ((GlossyThemeRender)themeRender).getMenu_control_item_bg_glossy_track1_alpha(), ((GlossyThemeRender)themeRender).getMenu_control_item_bg_glossy_track2(), ((GlossyThemeRender)themeRender).getMenu_control_item_bg_glossy_track2_alpha());
                    path = GraphicsUtil.createTopRoundRectangle(rectangle3, 2);
                    gC.setBackgroundPattern(pattern);
                    gC.fillPath(path);
                    path.dispose();
                    imageData = ((GlossyThemeRender)themeRender).getMenu_control_item_inner_border();
                    path = GraphicsUtil.createRoundRectangle(rectangle4, 2);
                    gC.setForeground((Color)imageData);
                    gC.drawPath(path);
                    path.dispose();
                    path = GraphicsUtil.createRoundRectangle(rectangle2, 2);
                    gC.setClipping(path);
                    path.dispose();
                    paletteData = ((GlossyThemeRender)themeRender).getMenu_control_item_bg_glow();
                    path = this.createBottomRadialPath(rectangle2);
                    object2 = new float[2];
                    float[] fArray = new float[4];
                    path.getBounds(fArray);
                    object2[0] = (ImageData)((fArray[0] + fArray[0] + fArray[2]) / 2.0f);
                    object2[1] = (ImageData)((fArray[1] + fArray[1] + fArray[3]) / 2.0f);
                    object = new GCExtension(gC);
                    ((GCExtension)object).fillGradientPath(path, (float[])object2, (Color)paletteData, 255, new Color[]{paletteData}, new int[]{0});
                    path.dispose();
                    gC.setClipping((Path)null);
                    gC.setAdvanced(false);
                }
            }
            if (cMenuItem != null) {
                rectangle5 = new Rectangle(n8, rectangle.y, n7 - n8, rectangle.height);
                if (menuDrawCommand.isEnabled()) {
                    gC.setForeground(this.theme.getMenu_control_item_fg());
                } else {
                    gC.setForeground(this.theme.getMenu_control_item_fg_disabled());
                }
                int n9 = gC.getFontMetrics().getHeight();
                gC.drawText(cMenuItem.getText(), rectangle5.x, rectangle5.y + (rectangle5.height - n9) / 2, DRAW_FLAGS);
                if (cMenuItem.getShortcut() != null) {
                    int n10 = this.shortCutWidth;
                    gC.drawText(cMenuItem.getShortcut().toString(), rectangle5.x + rectangle5.width - n10, rectangle5.y + (rectangle5.height - n9) / 2, DRAW_FLAGS);
                }
                int n11 = rectangle.y + (rectangle.height - 16) / 2;
                if (menuDrawCommand.hasSubMenu()) {
                    if (menuDrawCommand.isEnabled()) {
                        if (bl) {
                            gC.setBackground(this.theme.getMenu_control_item_arrow_bg_track());
                        } else {
                            gC.setBackground(this.theme.getMenu_control_item_arrow_bg());
                        }
                    } else {
                        gC.setBackground(this.theme.getMenu_control_item_arrow_bg_disabled());
                    }
                    GraphicsUtil.drawArrow(gC, new Rectangle(rectangle.x + rectangle.width - POSITION[11], rectangle.y, POSITION[12] - POSITION[11], rectangle.height), 131072);
                }
                if (((menuDrawCommand.getMenuItem().getStyle() & 0x20) != 0 || (menuDrawCommand.getMenuItem().getStyle() & 0x10) != 0) && menuDrawCommand.getMenuItem().getSelection()) {
                    rectangle4 = new Rectangle(n4 - 1, n11 - 1, 18, 18);
                    if (this.theme instanceof GeneralThemeRender) {
                        if (menuDrawCommand.isEnabled()) {
                            if (bl) {
                                gC.setBackground(this.theme.getMenu_control_item_check_rect_bg_track());
                                gC.setForeground(this.theme.getMenu_control_item_check_rect_border_track());
                            } else {
                                gC.setBackground(this.theme.getMenu_control_item_check_rect_bg());
                                gC.setForeground(this.theme.getMenu_control_item_check_rect_border());
                            }
                        } else {
                            gC.setBackground(this.theme.getMenu_control_item_check_rect_bg_disabled());
                            gC.setForeground(this.theme.getMenu_control_item_check_rect_border_disabled());
                        }
                        gC.fillRectangle(rectangle4);
                        gC.drawRectangle(rectangle4);
                    } else if (this.theme instanceof OfficeThemeRender || this.theme instanceof GlossyThemeRender) {
                        if (menuDrawCommand.isEnabled()) {
                            if (bl) {
                                rectangle3 = this.theme.getMenu_control_item_check_rect_bg_track();
                                rectangle2 = this.theme.getMenu_control_item_check_rect_border_track();
                            } else {
                                rectangle3 = this.theme.getMenu_control_item_check_rect_bg();
                                rectangle2 = this.theme.getMenu_control_item_check_rect_border();
                            }
                        } else {
                            rectangle3 = this.theme.getMenu_control_item_check_rect_bg_disabled();
                            rectangle2 = this.theme.getMenu_control_item_check_rect_border_disabled();
                        }
                        pattern = new Pattern[]{rectangle3, rectangle3, rectangle3, rectangle3, rectangle3, rectangle3, rectangle3, rectangle3, rectangle2};
                        if (this.theme instanceof GlossyThemeRender) {
                            rectangle4 = GraphicsUtil.inflate(rectangle4, -1, -1);
                        }
                        this.drawGradientBack(gC, rectangle4, (Color[])pattern);
                        this.drawGradientBorder(gC, rectangle4, (Color[])pattern);
                    }
                }
                rectangle4 = null;
                rectangle3 = null;
                if ((menuDrawCommand.getMenuItem().getStyle() & 0x20) != 0 && menuDrawCommand.getMenuItem().getSelection()) {
                    rectangle4 = this.theme.getCheckImage();
                } else if ((menuDrawCommand.getMenuItem().getStyle() & 0x10) != 0 && menuDrawCommand.getMenuItem().getSelection()) {
                    rectangle4 = this.theme.getRedioImage();
                } else {
                    rectangle4 = cMenuItem.getImage();
                    rectangle3 = cMenuItem.getDisableImage();
                }
                if (rectangle4 != null) {
                    rectangle2 = rectangle4.getImageData();
                    int n12 = n4 + (16 - rectangle2.width) / 2;
                    int n13 = n11 + (16 - rectangle2.height) / 2;
                    if (cMenuItem.isEnabled()) {
                        if (bl && this.theme.isShowMenuImageShadow() && GraphicsUtil.checkGdip() && (menuDrawCommand.getMenuItem().getStyle() & 0x20) == 0 && (menuDrawCommand.getMenuItem().getStyle() & 0x10) == 0) {
                            imageData = rectangle4.getImageData();
                            paletteData = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(154, 156, 146)});
                            object2 = new ImageData(imageData.width, imageData.height, 1, paletteData);
                            object2.transparentPixel = imageData.transparentPixel;
                            if (imageData.getTransparencyType() == 4) {
                                int n14;
                                for (n14 = 0; n14 < imageData.width; n14 += 1) {
                                    for (int i = 0; i < imageData.width; ++i) {
                                        int n15 = imageData.getPixel(n14, i);
                                        if (n15 != imageData.transparentPixel) {
                                            object2.setPixel(n14, i, 1);
                                            continue;
                                        }
                                        object2.setPixel(n14, i, 0);
                                    }
                                }
                                n14 = gC.getAdvanced() ? 1 : 0;
                                if (!n14) {
                                    gC.setAdvanced(true);
                                }
                                object = new Image(gC.getDevice(), object2);
                                gC.drawImage((Image)object, n12 + 1, n13 + 1);
                                object.dispose();
                                gC.setAdvanced(n14 != 0);
                                gC.drawImage((Image)rectangle4, n12 - 1, n13 - 1);
                            } else {
                                gC.drawImage((Image)rectangle4, n12, n13);
                            }
                        } else if (this.theme.isShowMenuImageShadow() && GraphicsUtil.checkGdip()) {
                            imageData = rectangle4.getImageData().palette.getRGBs();
                            if (imageData != null) {
                                for (int i = 0; i < ((RGB[])imageData).length; ++i) {
                                    object2 = imageData[i];
                                    object2.red = object2.red + 76 - (object2.red + 32) / 64 * 19;
                                    object2.green = object2.green + 76 - (object2.green + 32) / 64 * 19;
                                    object2.blue = object2.blue + 76 - (object2.blue + 32) / 64 * 19;
                                }
                                ImageData imageData2 = rectangle4.getImageData();
                                object2 = new ImageData(imageData2.width, imageData2.height, imageData2.depth, new PaletteData((RGB[])imageData));
                                object2.transparentPixel = imageData2.transparentPixel;
                                for (int i = 0; i < imageData2.width; ++i) {
                                    for (int j = 0; j < imageData2.width; ++j) {
                                        int n16 = imageData2.getPixel(i, j);
                                        if (n16 != imageData2.transparentPixel) {
                                            object2.setPixel(i, j, n16);
                                            continue;
                                        }
                                        object2.setPixel(i, j, imageData2.transparentPixel);
                                    }
                                }
                                Image image = new Image(null, object2);
                                gC.drawImage(image, n12, n13);
                                image.dispose();
                            }
                        } else {
                            gC.drawImage((Image)rectangle4, n12, n13);
                        }
                    } else if (rectangle3 == null) {
                        rectangle3 = new Image(null, (Image)rectangle4, 1);
                        gC.drawImage((Image)rectangle3, n12, n13);
                        rectangle3.dispose();
                    } else {
                        gC.drawImage((Image)rectangle3, n12, n13);
                    }
                }
            }
        }
    }

    private Path createBottomRadialPath(Rectangle rectangle) {
        float[] fArray = new float[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        fArray[0] = fArray[0] - fArray[2] * 0.35f;
        fArray[1] = fArray[1] - fArray[3] * 0.15f;
        fArray[2] = fArray[2] * 1.7f;
        fArray[3] = fArray[3] * 2.3f;
        return GraphicsUtil.createEllipsePath(fArray);
    }

    private void drawGradientBack(GC gC, Rectangle rectangle, Color[] colorArray) {
        gC.setAdvanced(true);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        Rectangle rectangle3 = GraphicsUtil.inflate(rectangle2, -1, -1);
        int n = rectangle3.height / 2;
        Rectangle rectangle4 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, n);
        Rectangle rectangle5 = new Rectangle(rectangle3.x, rectangle3.y + n, rectangle3.width, rectangle3.height - n);
        gC.setForeground(colorArray[0]);
        gC.setBackground(colorArray[1]);
        gC.fillGradientRectangle(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, true);
        gC.setForeground(colorArray[2]);
        gC.setBackground(colorArray[3]);
        gC.fillGradientRectangle(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height, true);
        Rectangle rectangle6 = GraphicsUtil.inflate(rectangle3, -1, -1);
        n = rectangle6.height / 2;
        rectangle4 = new Rectangle(rectangle6.x, rectangle6.y, rectangle6.width, n);
        rectangle5 = new Rectangle(rectangle6.x, rectangle6.y + n, rectangle6.width, rectangle6.height - n);
        gC.setForeground(colorArray[4]);
        gC.setBackground(colorArray[5]);
        gC.fillGradientRectangle(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, true);
        gC.setForeground(colorArray[6]);
        gC.setBackground(colorArray[7]);
        gC.fillGradientRectangle(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height, true);
        gC.setAdvanced(false);
    }

    private void drawGradientBorder(GC gC, Rectangle rectangle, Color[] colorArray) {
        if (GraphicsUtil.checkGdip()) {
            gC.setAdvanced(true);
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Path path = GraphicsUtil.createRoundPath(rectangle2, 1.2f);
            gC.setForeground(colorArray[8]);
            gC.drawPath(path);
            path.dispose();
            gC.setAdvanced(false);
        } else {
            gC.setForeground(colorArray[8]);
            gC.drawRectangle(rectangle);
        }
    }

    public void hideMenu() {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        this.trackItemIndex = -1;
        if (this.popupMenu != null) {
            this.popupMenu.hideMenu();
            this.popupMenu = null;
        }
        if (this.menu != null) {
            Event event = new Event();
            event.widget = this.shell;
            event.data = this;
            event.type = 64;
            this.menu.fireMenuEvent(event);
        }
        this.shell.dispose();
    }

    protected void drawCommand(int n, boolean bl) {
        if (n < 0 || n >= this.commands.size()) {
            return;
        }
        MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.commands.get(n);
        if (menuDrawCommand.isSeparator()) {
            return;
        }
        GC gC = new GC((Drawable)this.shell);
        this.drawSingleCommand(gC, (MenuDrawCommand)this.commands.get(n), bl);
        gC.dispose();
    }

    protected void drawCommand(GC gC, int n, boolean bl) {
        if (n < 0 || n >= this.commands.size()) {
            return;
        }
        MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.commands.get(n);
        if (menuDrawCommand.isSeparator()) {
            return;
        }
        this.drawSingleCommand(gC, (MenuDrawCommand)this.commands.get(n), bl);
    }

    private void refreshCurrentCommand() {
        if (this.trackItemIndex > -1) {
            Rectangle rectangle = ((MenuDrawCommand)this.commands.get(this.trackItemIndex)).getDrawRect();
            this.shell.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            this.hideSubMenu((MenuDrawCommand)this.commands.get(this.trackItemIndex));
        }
    }

    private void hideSubMenu(MenuDrawCommand menuDrawCommand) {
        this.trackItemIndex = -1;
        if (this.popupMenu != null) {
            this.popupMenu.hideMenu();
            this.popupMenu = null;
        }
    }

    private void showSubMenu(MenuDrawCommand menuDrawCommand) {
        if (menuDrawCommand.hasSubMenu() && menuDrawCommand.getMenuItem().isEnabled()) {
            if (this.popupMenu == null) {
                this.popupMenu = new MenuControl(this.holder, this.theme);
            } else {
                this.popupMenu.hideMenu();
            }
            this.popupMenu.menu = menuDrawCommand.getMenuItem().getMenu();
            this.popupMenu.screenPos = this.shell.toDisplay(new Point(menuDrawCommand.getDrawRect().x + menuDrawCommand.getDrawRect().width, menuDrawCommand.getDrawRect().y - POSITION[0]));
            this.popupMenu.leftScreenPos = this.shell.toDisplay(new Point(menuDrawCommand.getDrawRect().x, menuDrawCommand.getDrawRect().y - POSITION[0]));
            this.popupMenu.aboveScreenPos = this.shell.toDisplay(new Point(menuDrawCommand.getDrawRect().x, menuDrawCommand.getDrawRect().y + 1));
            this.popupMenu.menu = menuDrawCommand.getMenuItem().getMenu();
            this.popupMenu.parentMenu = this;
            this.popupMenu.ignoreTaskbar = this.ignoreTaskbar;
            this.popupMenu.popupRight = this.popupRight;
            Event event = new Event();
            event.data = this.popupMenu;
            event.type = 4096;
            this.popupMenu.menu.fireMenuEvent(event);
            this.popupMenu.createAndShowWindow();
        }
    }

    private void handleMouseMoveEvent(MouseEvent mouseEvent) {
        for (int i = 0; i < this.commands.size(); ++i) {
            MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.commands.get(i);
            if (!menuDrawCommand.getDrawRect().contains(mouseEvent.x, mouseEvent.y)) continue;
            if (this.trackItemIndex != i) {
                this.refreshCurrentCommand();
                this.trackItemIndex = i;
                this.drawCommand(this.trackItemIndex, true);
                this.showSubMenu(menuDrawCommand);
                return;
            }
            return;
        }
        this.refreshCurrentCommand();
        this.trackItemIndex = -1;
    }

    public Shell getShell() {
        return this.holder.getShell();
    }

    public boolean checkMouseDownEvent(Point point) {
        boolean bl;
        if (this.shell == null || this.shell.isDisposed()) {
            return true;
        }
        if (new Rectangle(0, 0, this.shell.getSize().x, this.shell.getSize().y).contains(this.shell.toControl(point))) {
            return false;
        }
        return this.popupMenu == null || this.popupMenu.getShell().isDisposed() || (bl = this.popupMenu.checkMouseDownEvent(point));
    }

    MenuControl getCurrentMenu() {
        if (this.trackItemIndex == -1) {
            return null;
        }
        if (this.popupMenu != null && this.popupMenu.trackItemIndex != -1) {
            return this.popupMenu.getCurrentMenu();
        }
        return this;
    }

    public void setSelection(int n) {
        if (this.shell.isDisposed()) {
            return;
        }
        if (this.getSelectionIndex() == n) {
            return;
        }
        if (n > -1 && n < this.commands.size()) {
            MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.commands.get(n);
            if (this.trackItemIndex != n) {
                this.refreshCurrentCommand();
            }
            this.trackItemIndex = n;
            this.drawCommand(this.trackItemIndex, true);
            if (this.popupMenu == null && this.getCurrentCommand() == menuDrawCommand) {
                this.showSubMenu(menuDrawCommand);
            }
        } else {
            this.refreshCurrentCommand();
            this.trackItemIndex = -1;
        }
    }

    protected MenuDrawCommand getCurrentCommand() {
        if (this.shell.isDisposed()) {
            return null;
        }
        if (this.trackItemIndex < 0 && this.trackItemIndex >= this.commands.size()) {
            return null;
        }
        return (MenuDrawCommand)this.commands.get(this.trackItemIndex);
    }

    public CMenuItem getSelection() {
        if (this.trackItemIndex == -1) {
            return null;
        }
        MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.commands.get(this.trackItemIndex);
        if (menuDrawCommand != null) {
            return menuDrawCommand.getMenuItem();
        }
        return null;
    }

    public int getSelectionIndex() {
        return this.trackItemIndex;
    }

    public void downSelected() {
        MenuDrawCommand menuDrawCommand;
        int n = this.trackItemIndex + 1;
        if (n >= this.commands.size()) {
            n = 0;
        }
        if ((menuDrawCommand = (MenuDrawCommand)this.commands.get(n)).isSeparator() && ++n >= this.commands.size()) {
            n = 0;
        }
        final int n2 = n;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MenuControl.this.setSelection(n2);
            }
        });
    }

    public void upSelected() {
        MenuDrawCommand menuDrawCommand;
        int n = this.trackItemIndex - 1;
        if (n <= -1) {
            n = this.commands.size() - 1;
        }
        if ((menuDrawCommand = (MenuDrawCommand)this.commands.get(n)).isSeparator() && --n == -1) {
            n = this.commands.size() - 1;
        }
        final int n2 = n;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MenuControl.this.setSelection(n2);
            }
        });
    }

    public boolean isSubMenuEnd() {
        if (this.trackItemIndex == -1) {
            return true;
        }
        MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.commands.get(this.trackItemIndex);
        return !menuDrawCommand.hasSubMenu() || !menuDrawCommand.isEnabled();
    }

    public void subMenuSelected() {
        if (this.trackItemIndex == -1) {
            return;
        }
        MenuDrawCommand menuDrawCommand = (MenuDrawCommand)this.commands.get(this.trackItemIndex);
        if (menuDrawCommand.hasSubMenu()) {
            if (this.popupMenu == null && menuDrawCommand.isEnabled()) {
                this.showSubMenu(menuDrawCommand);
            }
            this.popupMenu.setSelection(0);
        }
    }

    public void parentMenuSelected() {
        if (this.parentMenu != null) {
            this.refreshCurrentCommand();
            this.trackItemIndex = -1;
        }
    }

    protected void dealAltKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.keyCode;
        if (n == 0) {
            n = keyEvent.character;
        }
        String string = "&" + (char)n;
        for (int i = 0; i < this.menu.getItemCount(); ++i) {
            if (this.menu.getItem(i).getText().toLowerCase().indexOf(string.toLowerCase()) <= -1) continue;
            this.setSelection(i);
            if (this.popupMenu != null) {
                this.popupMenu.setSelection(0);
            } else {
                this.handleSelectedEvent();
            }
            return;
        }
    }

    void handleSelectedEvent() {
        if (this.trackItemIndex == -1) {
            return;
        }
        CMenuItem cMenuItem = this.menu.getItem(this.trackItemIndex);
        if (cMenuItem.getMenu() == null && !cMenuItem.isSeparator() && cMenuItem.isEnabled()) {
            this.holder.hideMenu();
            Event event = new Event();
            event.data = cMenuItem;
            event.widget = this.shell;
            cMenuItem.fireSelectionEvent(event);
            event = new Event();
            event.widget = this.shell;
            event.data = this;
            event.type = 2;
            this.menu.fireMenuEvent(event);
        }
    }

    public void refresh() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.redraw();
        }
    }

    public ThemeRender getTheme() {
        return this.theme;
    }

    public void setTheme(ThemeRender themeRender) {
        this.theme = themeRender;
    }

    public Control getControl() {
        return this.shell;
    }

    public CMenu getMenu() {
        return this.menu;
    }

    protected class PI {
        private static final int BorderTop = 0;
        private static final int BorderLeft = 1;
        private static final int BorderBottom = 2;
        private static final int BorderRight = 3;
        private static final int ImageGapTop = 4;
        private static final int ImageGapLeft = 5;
        private static final int ImageGapBottom = 6;
        private static final int ImageGapRight = 7;
        private static final int TextGapLeft = 8;
        private static final int TextGapRight = 9;
        private static final int SubMenuGapLeft = 10;
        private static final int SubMenuWidth = 11;
        private static final int SubMenuGapRight = 12;
        private static final int SeparatorHeight = 13;
        private static final int SeparatorWidth = 14;
        private static final int ShortcutGap = 15;

        protected PI() {
        }
    }
}

