/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.sf.feeling.swt.win32.internal.extension.widgets.ISkinable;

public class ImageSkin
implements ISkinable {
    private Device device;
    private Image image;
    private Image mouseHover;
    private Image activeImage;
    private Image mouseDown;
    private Image keyDown;
    private Image currentImage;

    public ImageSkin(Device device, Image image) {
        if (device == null) {
            throw new IllegalArgumentException("Device is null");
        }
        if (device.isDisposed()) {
            throw new IllegalArgumentException("Device is disposed");
        }
        if (image == null) {
            throw new IllegalArgumentException("Image is null");
        }
        this.device = device;
        this.image = image;
        this.activeImage = image;
        this.mouseHover = image;
        this.mouseDown = image;
        this.keyDown = image;
        this.currentImage = image;
    }

    public Color getForeground(Event event) {
        switch (event.type) {
            case 27: {
                return this.device.getSystemColor(1);
            }
        }
        return this.device.getSystemColor(2);
    }

    public int getInitHeight() {
        return this.image.getImageData().height;
    }

    public int getInitWidth() {
        return this.image.getImageData().width;
    }

    public Image getActiveImage() {
        return this.activeImage;
    }

    public void setActiveImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Image is null");
        }
        this.activeImage = image;
    }

    public Image getMouseHover() {
        return this.mouseHover;
    }

    public void setMouseHover(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Image is null");
        }
        this.mouseHover = image;
    }

    public Image getKeyDown() {
        return this.keyDown;
    }

    public void setKeyDown(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Image is null");
        }
        this.keyDown = image;
    }

    public Image getMouseDown() {
        return this.mouseDown;
    }

    public void setMouseDown(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Image is null");
        }
        this.mouseDown = image;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Image is null");
        }
        this.image = image;
    }

    public void configue(Event event) {
        switch (event.type) {
            case 26: {
                this.currentImage = this.activeImage;
                break;
            }
            case 6: {
                this.currentImage = this.mouseHover;
                break;
            }
            case 3: {
                this.currentImage = this.mouseDown;
                break;
            }
            case 4: {
                this.currentImage = this.mouseHover;
                break;
            }
            case 1: {
                this.currentImage = this.keyDown;
                break;
            }
            default: {
                this.currentImage = this.image;
            }
        }
    }

    public void paint(GC gC, int n, int n2, int n3, int n4) {
        if (this.currentImage != null) {
            gC.drawImage(this.currentImage, 0, 0, this.currentImage.getImageData().width, this.currentImage.getImageData().height, n, n2, n3, n4);
        }
    }

    public void paint(GC gC, int n, int n2) {
        if (this.currentImage != null) {
            gC.drawImage(this.currentImage, n, n2);
        }
    }
}

