/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension.widgets;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Event;
import org.sf.feeling.swt.win32.extension.graphics.GraphicsUtil;
import org.sf.feeling.swt.win32.extension.widgets.ThemeConstants;
import org.sf.feeling.swt.win32.internal.extension.util.ColorCache;
import org.sf.feeling.swt.win32.internal.extension.util.ImageCache;
import org.sf.feeling.swt.win32.internal.extension.widgets.ButtonCanvas;
import org.sf.feeling.swt.win32.internal.extension.widgets.IWindow;
import org.sf.feeling.swt.win32.internal.extension.widgets.ImageSkin;

public class UIManager {
    private static List themes = new ArrayList();
    private static HashMap themeProperties = new HashMap();

    private UIManager() {
    }

    public static void installTheme(IWindow iWindow) {
        if (GraphicsUtil.checkGdip()) {
            UIManager.installTheme("office2007", iWindow);
        }
    }

    public static void installTheme(String string) {
        for (int i = 0; i < themes.size(); ++i) {
            UIManager.installTheme(string, (IWindow)themes.get(i));
        }
    }

    public static void installTheme(String string, final IWindow iWindow) {
        if (themes.contains(iWindow)) {
            UIManager.unInstallTheme(iWindow);
        }
        if (!ThemeConstants.containTheme(string)) {
            string = "office2007";
        }
        Image image = ImageCache.getImage("/icons/" + string + "/w_n.gif");
        final String string2 = string;
        iWindow.setSkin(1, new ImageSkin((Device)iWindow.getDisplay(), image){

            public Color getForeground(Event event) {
                switch (event.type) {
                    case 27: {
                        return UIManager.getTitleBarDeactiveBackground(string2);
                    }
                }
                return UIManager.getTitleBarForeground(string2);
            }
        });
        Image image2 = ImageCache.getImage("/icons/" + string + "/w_s.gif");
        iWindow.setSkin(6, new ImageSkin((Device)iWindow.getDisplay(), image2));
        Image image3 = ImageCache.getImage("/icons/" + string + "/w_w.gif");
        iWindow.setSkin(3, new ImageSkin((Device)iWindow.getDisplay(), image3));
        Image image4 = ImageCache.getImage("/icons/" + string + "/w_e.gif");
        iWindow.setSkin(4, new ImageSkin((Device)iWindow.getDisplay(), image4));
        Image image5 = ImageCache.getImage("/icons/" + string + "/w_nw.gif");
        iWindow.setSkin(0, new ImageSkin((Device)iWindow.getDisplay(), image5));
        Image image6 = ImageCache.getImage("/icons/" + string + "/w_sw.gif");
        iWindow.setSkin(5, new ImageSkin((Device)iWindow.getDisplay(), image6));
        Image image7 = ImageCache.getImage("/icons/" + string + "/w_ne.gif");
        iWindow.setSkin(2, new ImageSkin((Device)iWindow.getDisplay(), image7));
        Image image8 = ImageCache.getImage("/icons/" + string + "/w_se.gif");
        iWindow.setSkin(7, new ImageSkin((Device)iWindow.getDisplay(), image8));
        Image image9 = ImageCache.getImage("/icons/" + string + "/w_c.gif");
        iWindow.setSkin(new ImageSkin((Device)iWindow.getDisplay(), image9));
        image9 = ImageCache.getImage("/icons/" + string + "/w_min.gif");
        Image image10 = ImageCache.getImage("/icons/" + string + "/w_min_h.gif");
        Image image11 = ImageCache.getImage("/icons/" + string + "/w_min_c.gif");
        ImageSkin imageSkin = new ImageSkin((Device)iWindow.getDisplay(), image9);
        imageSkin.setMouseHover(image10);
        imageSkin.setMouseDown(image11);
        iWindow.setButtonSkin(1, imageSkin);
        Image image12 = ImageCache.getImage("/icons/" + string + "/w_max.gif");
        Image image13 = ImageCache.getImage("/icons/" + string + "/w_max_h.gif");
        Image image14 = ImageCache.getImage("/icons/" + string + "/w_max_c.gif");
        ImageSkin imageSkin2 = new ImageSkin((Device)iWindow.getDisplay(), image12);
        imageSkin2.setMouseHover(image13);
        imageSkin2.setMouseDown(image14);
        iWindow.setButtonSkin(2, imageSkin2);
        Image image15 = ImageCache.getImage("/icons/" + string + "/w_rev.gif");
        Image image16 = ImageCache.getImage("/icons/" + string + "/w_rev_h.gif");
        Image image17 = ImageCache.getImage("/icons/" + string + "/w_rev_c.gif");
        ImageSkin imageSkin3 = new ImageSkin((Device)iWindow.getDisplay(), image15);
        imageSkin3.setMouseHover(image16);
        imageSkin3.setMouseDown(image17);
        iWindow.setButtonSkin(3, imageSkin3);
        Image image18 = ImageCache.getImage("/icons/" + string + "/w_cls.gif");
        Image image19 = ImageCache.getImage("/icons/" + string + "/w_cls_h.gif");
        Image image20 = ImageCache.getImage("/icons/" + string + "/w_cls_c.gif");
        ImageSkin imageSkin4 = new ImageSkin((Device)iWindow.getDisplay(), image18);
        imageSkin4.setMouseHover(image19);
        imageSkin4.setMouseDown(image20);
        iWindow.setButtonSkin(4, imageSkin4);
        try {
            Image image21 = ImageCache.getImage("/icons/" + string + "/w_hlp.gif");
            Image image22 = ImageCache.getImage("/icons/" + string + "/w_hlp_h.gif");
            Image image23 = ImageCache.getImage("/icons/" + string + "/w_hlp_c.gif");
            ImageSkin imageSkin5 = new ImageSkin((Device)iWindow.getDisplay(), image21);
            imageSkin5.setMouseHover(image22);
            imageSkin5.setMouseDown(image23);
            iWindow.setButtonSkin(0, imageSkin5);
        }
        catch (RuntimeException runtimeException) {
            iWindow.setButtonSkin(0, null);
        }
        themes.add(iWindow);
        iWindow.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                UIManager.unInstallTheme(iWindow);
            }
        });
        iWindow.layout();
    }

    public static void unInstallTheme(IWindow iWindow) {
        if (!themes.contains(iWindow)) {
            return;
        }
        themes.remove(iWindow);
    }

    public static boolean isInstall(IWindow iWindow) {
        return themes.contains(iWindow);
    }

    public static void transformWindowsButtonLayoutData(ButtonCanvas buttonCanvas, String string) {
        Properties properties;
        if (!themeProperties.containsKey(string) && (properties = UIManager.loadThemeProperties(string)) != null) {
            themeProperties.put(string, properties);
        }
        if ((properties = (Properties)themeProperties.get(string)) != null) {
            try {
                int n;
                String string2 = properties.getProperty("Button.LayoutData.VerticalIndent");
                GridData gridData = (GridData)buttonCanvas.getLayoutData();
                gridData.verticalIndent = n = Integer.parseInt(string2);
                buttonCanvas.setLayoutData(gridData);
                buttonCanvas.getParent().layout();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static Properties loadThemeProperties(String string) {
        try {
            Properties properties = new Properties();
            InputStream inputStream = UIManager.class.getResourceAsStream("/icons/" + string + "/" + string + ".properties");
            properties.load(inputStream);
            inputStream.close();
            return properties;
        }
        catch (Exception exception) {
            SWT.error((int)39, (Throwable)exception);
            return null;
        }
    }

    public static Color getTitleBarForeground(String string) {
        Properties properties;
        if (!themeProperties.containsKey(string) && (properties = UIManager.loadThemeProperties(string)) != null) {
            themeProperties.put(string, properties);
        }
        if ((properties = (Properties)themeProperties.get(string)) != null) {
            try {
                String string2 = properties.getProperty("TitlBar.Foreground");
                String[] stringArray = string2.split(",");
                if (stringArray.length == 3) {
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    return ColorCache.getInstance().getColor(n, n2, n3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ColorCache.getInstance().getBlack();
    }

    public static Color getTitleBarDeactiveBackground(String string) {
        Properties properties;
        if (!themeProperties.containsKey(string) && (properties = UIManager.loadThemeProperties(string)) != null) {
            themeProperties.put(string, properties);
        }
        if ((properties = (Properties)themeProperties.get(string)) != null) {
            try {
                String string2 = properties.getProperty("TitlBar.Foreground.Deactive");
                String[] stringArray = string2.split(",");
                if (stringArray.length == 3) {
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    return ColorCache.getInstance().getColor(n, n2, n3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ColorCache.getInstance().getWhite();
    }

    public static int getTitleBarFontStyle(String string) {
        Properties properties;
        if (!themeProperties.containsKey(string) && (properties = UIManager.loadThemeProperties(string)) != null) {
            themeProperties.put(string, properties);
        }
        properties = (Properties)themeProperties.get(string);
        int n = 0;
        if (properties != null) {
            try {
                String string2 = properties.getProperty("TitlBar.Font.Style");
                if ("bold".equalsIgnoreCase(string2)) {
                    n |= 1;
                }
                if ("italic".equalsIgnoreCase(string2)) {
                    n |= 2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static boolean isTitleUsedShadow(String string) {
        Properties properties;
        if (!themeProperties.containsKey(string) && (properties = UIManager.loadThemeProperties(string)) != null) {
            themeProperties.put(string, properties);
        }
        if ((properties = (Properties)themeProperties.get(string)) != null) {
            try {
                String string2 = properties.getProperty("TitlBar.Title.Shadow");
                return Boolean.valueOf(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

