/*
 * Decompiled with CFR 0.152.
 */
package ezvcard;

import ezvcard.VCardVersion;
import ezvcard.property.VCardProperty;
import ezvcard.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationWarnings
implements Iterable<WarningsGroup> {
    private final List<WarningsGroup> warnings;
    private final VCardVersion version;

    public ValidationWarnings(List<WarningsGroup> warnings, VCardVersion version) {
        this.warnings = warnings;
        this.version = version;
    }

    public List<WarningsGroup> getByProperty(Class<? extends VCardProperty> propertyClass) {
        ArrayList<WarningsGroup> warnings = new ArrayList<WarningsGroup>();
        for (WarningsGroup group : this.warnings) {
            VCardProperty property = group.getProperty();
            if (property == null) {
                if (propertyClass != null) continue;
                warnings.add(group);
                continue;
            }
            if (propertyClass != property.getClass()) continue;
            warnings.add(group);
        }
        return warnings;
    }

    public List<WarningsGroup> getWarnings() {
        return this.warnings;
    }

    public VCardVersion getVersion() {
        return this.version;
    }

    public boolean isEmpty() {
        return this.warnings.isEmpty();
    }

    public String toString() {
        return StringUtils.join(this.warnings, StringUtils.NEWLINE);
    }

    @Override
    public Iterator<WarningsGroup> iterator() {
        return this.warnings.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WarningsGroup {
        private final VCardProperty property;
        private final List<String> messages;

        public WarningsGroup(VCardProperty property, List<String> messages) {
            this.property = property;
            this.messages = messages;
        }

        public VCardProperty getProperty() {
            return this.property;
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public String toString() {
            final String prefix = this.property == null ? "" : "[" + this.property.getClass().getSimpleName() + "]: ";
            return StringUtils.join(this.messages, StringUtils.NEWLINE, new StringUtils.JoinCallback<String>(){

                @Override
                public void handle(StringBuilder sb, String message) {
                    sb.append(prefix).append(message);
                }
            });
        }
    }
}

