/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.html;

import ezvcard.util.HtmlUtils;
import ezvcard.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HCardElement {
    private final Element element;

    public HCardElement(Element element) {
        this.element = element;
    }

    public String tagName() {
        return this.element.tagName();
    }

    public String attr(String name) {
        return this.element.attr(name);
    }

    public String absUrl(String name) {
        String url = this.element.absUrl(name);
        if (url.length() == 0) {
            url = this.element.attr(name);
        }
        return url;
    }

    public Set<String> classNames() {
        return this.element.classNames();
    }

    public String value() {
        return this.value(this.element);
    }

    public String firstValue(String cssClass) {
        Elements elements = this.element.getElementsByClass(cssClass);
        return elements.isEmpty() ? null : this.value(elements.first());
    }

    public List<String> allValues(String cssClass) {
        Elements elements = this.element.getElementsByClass(cssClass);
        ArrayList<String> values = new ArrayList<String>(elements.size());
        for (Element e : elements) {
            values.add(this.value(e));
        }
        return values;
    }

    public List<String> types() {
        List<String> types = this.allValues("type");
        for (int i = 0; i < types.size(); ++i) {
            String type = types.get(i);
            types.set(i, type.toLowerCase());
        }
        return types;
    }

    public void append(String text) {
        String[] split = text.split("\\r\\n|\\n|\\r");
        if (split[0].length() > 0) {
            this.element.appendText(split[0]);
        }
        for (int i = 1; i < split.length; ++i) {
            String s = split[i];
            this.element.appendElement("br");
            if (s.length() <= 0) continue;
            this.element.appendText(s);
        }
    }

    public Element getElement() {
        return this.element;
    }

    private String value(Element element) {
        String title;
        if ("abbr".equals(element.tagName()) && (title = element.attr("title")).length() > 0) {
            return title;
        }
        StringBuilder value = new StringBuilder();
        Elements valueElements = element.getElementsByClass("value");
        if (valueElements.isEmpty()) {
            this.visitForValue(element, value);
        } else {
            for (Element valueElement : valueElements) {
                String title2;
                if (HtmlUtils.isChildOf(valueElement, valueElements)) continue;
                if ("abbr".equals(valueElement.tagName()) && (title2 = valueElement.attr("title")).length() > 0) {
                    value.append(title2);
                    continue;
                }
                this.visitForValue(valueElement, value);
            }
        }
        return value.toString().trim();
    }

    private void visitForValue(Element element, StringBuilder value) {
        for (Node node : element.childNodes()) {
            if (node instanceof Element) {
                Element e = (Element)node;
                if (e.classNames().contains("type")) continue;
                if ("br".equals(e.tagName())) {
                    value.append(StringUtils.NEWLINE);
                    continue;
                }
                if ("del".equals(e.tagName())) continue;
                this.visitForValue(e, value);
                continue;
            }
            if (!(node instanceof TextNode)) continue;
            TextNode t = (TextNode)node;
            value.append(t.text());
        }
    }
}

