/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.json.JCardRawWriter;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.ProductId;
import ezvcard.property.RawProperty;
import ezvcard.property.TextProperty;
import ezvcard.property.VCardProperty;
import ezvcard.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCardWriter
implements Closeable,
Flushable {
    private ScribeIndex index = new ScribeIndex();
    private final JCardRawWriter writer;
    private final VCardVersion targetVersion = VCardVersion.V4_0;
    private boolean addProdId = true;
    private boolean versionStrict = true;

    public JCardWriter(OutputStream out) {
        this(IOUtils.utf8Writer(out));
    }

    public JCardWriter(OutputStream out, boolean wrapInArray) {
        this(IOUtils.utf8Writer(out), wrapInArray);
    }

    public JCardWriter(File file) throws IOException {
        this(IOUtils.utf8Writer(file));
    }

    public JCardWriter(File file, boolean wrapInArray) throws IOException {
        this(IOUtils.utf8Writer(file), wrapInArray);
    }

    public JCardWriter(Writer writer) {
        this(writer, false);
    }

    public JCardWriter(Writer writer, boolean wrapInArray) {
        this.writer = new JCardRawWriter(writer, wrapInArray);
    }

    public void write(VCard vcard) throws IOException {
        ArrayList<VCardProperty> typesToAdd = new ArrayList<VCardProperty>();
        for (VCardProperty type : vcard) {
            if (this.addProdId && type instanceof ProductId || this.versionStrict && !type.getSupportedVersions().contains((Object)this.targetVersion)) continue;
            if (this.index.getPropertyScribe(type) == null) {
                throw new IllegalArgumentException("No scribe found for property class \"" + type.getClass().getName() + "\".");
            }
            typesToAdd.add(type);
        }
        if (this.addProdId) {
            TextProperty property = this.targetVersion == VCardVersion.V2_1 ? new RawProperty("X-PRODID", "ezvcard " + Ezvcard.VERSION) : new ProductId("ezvcard " + Ezvcard.VERSION);
            typesToAdd.add(property);
        }
        this.writer.writeStartVCard();
        this.writer.writeProperty("version", VCardDataType.TEXT, JCardValue.single(this.targetVersion.getVersion()));
        for (VCardProperty type : typesToAdd) {
            VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(type);
            try {
                JCardValue value = scribe.writeJson(type);
                value = new JCardValue(value.getValues());
                VCardParameters subTypes = scribe.prepareParameters(type, this.targetVersion, vcard);
                this.writer.writeProperty(type.getGroup(), scribe.getPropertyName().toLowerCase(), subTypes, scribe.dataType(type, this.targetVersion), value);
            }
            catch (SkipMeException e) {
            }
            catch (EmbeddedVCardException e) {}
        }
        this.writer.writeEndVCard();
    }

    public boolean isAddProdId() {
        return this.addProdId;
    }

    public void setAddProdId(boolean addProdId) {
        this.addProdId = addProdId;
    }

    public boolean isVersionStrict() {
        return this.versionStrict;
    }

    public void setVersionStrict(boolean versionStrict) {
        this.versionStrict = versionStrict;
    }

    public boolean isIndent() {
        return this.writer.isIndent();
    }

    public void setIndent(boolean indent) {
        this.writer.setIndent(indent);
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public void closeJsonStream() throws IOException {
        this.writer.closeJsonStream();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

