/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Organization;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationScribe
extends VCardPropertyScribe<Organization> {
    public OrganizationScribe() {
        super(Organization.class, "ORG");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(Organization property, VCardVersion version) {
        return OrganizationScribe.structured(property.getValues());
    }

    @Override
    protected Organization _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        Organization property = new Organization();
        VCardPropertyScribe.SemiStructuredIterator it = OrganizationScribe.semistructured(value);
        while (it.hasNext()) {
            property.addValue(it.next());
        }
        return property;
    }

    @Override
    protected void _writeXml(Organization property, XCardElement parent) {
        parent.append(VCardDataType.TEXT.getName().toLowerCase(), property.getValues());
    }

    @Override
    protected Organization _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        List<String> values = element.all(VCardDataType.TEXT);
        if (!values.isEmpty()) {
            Organization property = new Organization();
            property.getValues().addAll(values);
            return property;
        }
        throw OrganizationScribe.missingXmlElements(VCardDataType.TEXT);
    }

    @Override
    protected Organization _parseHtml(HCardElement element, List<String> warnings) {
        String orgUnit;
        Organization property = new Organization();
        String orgName = element.firstValue("organization-name");
        if (orgName != null) {
            property.addValue(orgName);
        }
        if ((orgUnit = element.firstValue("organization-unit")) != null) {
            property.addValue(orgUnit);
        }
        if (property.getValues().isEmpty()) {
            property.addValue(element.value());
        }
        return property;
    }

    @Override
    protected JCardValue _writeJson(Organization property) {
        List values = property.getValues();
        if (values.isEmpty()) {
            return JCardValue.single("");
        }
        if (values.size() == 1) {
            return JCardValue.single(values.get(0));
        }
        return JCardValue.structured(new Object[]{values});
    }

    @Override
    protected Organization _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        Organization property = new Organization();
        VCardPropertyScribe.StructuredIterator it = OrganizationScribe.structured(value);
        while (it.hasNext()) {
            property.addValue(it.nextString());
        }
        return property;
    }
}

