/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.VCardProperty;
import ezvcard.util.ISOFormat;
import ezvcard.util.StringUtils;
import ezvcard.util.VCardDateFormatter;
import ezvcard.util.XmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VCardPropertyScribe<T extends VCardProperty> {
    protected final Class<T> clazz;
    protected final String propertyName;
    protected final QName qname;

    public VCardPropertyScribe(Class<T> clazz, String propertyName) {
        this(clazz, propertyName, new QName(VCardVersion.V4_0.getXmlNamespace(), propertyName.toLowerCase()));
    }

    public VCardPropertyScribe(Class<T> clazz, String propertyName, QName qname) {
        this.clazz = clazz;
        this.propertyName = propertyName;
        this.qname = qname;
    }

    public Class<T> getPropertyClass() {
        return this.clazz;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public QName getQName() {
        return this.qname;
    }

    public final VCardParameters prepareParameters(T property, VCardVersion version, VCard vcard) {
        VCardParameters copy = new VCardParameters(((VCardProperty)property).getParameters());
        this._prepareParameters(property, copy, version, vcard);
        return copy;
    }

    public final VCardDataType defaultDataType(VCardVersion version) {
        return this._defaultDataType(version);
    }

    public final VCardDataType dataType(T property, VCardVersion version) {
        return this._dataType(property, version);
    }

    public final String writeText(T property, VCardVersion version) {
        return this._writeText(property, version);
    }

    public final void writeXml(T property, Element element) {
        XCardElement xCardElement = new XCardElement(element);
        this._writeXml(property, xCardElement);
    }

    public final JCardValue writeJson(T property) {
        return this._writeJson(property);
    }

    public final Result<T> parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters) {
        ArrayList<String> warnings = new ArrayList<String>(0);
        T property = this._parseText(value, dataType, version, parameters, warnings);
        ((VCardProperty)property).setParameters(parameters);
        return new Result<T>(property, warnings);
    }

    public final Result<T> parseXml(Element element, VCardParameters parameters) {
        ArrayList<String> warnings = new ArrayList<String>(0);
        T property = this._parseXml(new XCardElement(element), parameters, warnings);
        ((VCardProperty)property).setParameters(parameters);
        return new Result<T>(property, warnings);
    }

    public final Result<T> parseHtml(org.jsoup.nodes.Element element) {
        HCardElement hcardElement = new HCardElement(element);
        ArrayList<String> warnings = new ArrayList<String>(0);
        T property = this._parseHtml(hcardElement, warnings);
        return new Result<T>(property, warnings);
    }

    public final Result<T> parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters) {
        ArrayList<String> warnings = new ArrayList<String>(0);
        T property = this._parseJson(value, dataType, parameters, warnings);
        ((VCardProperty)property).setParameters(parameters);
        return new Result<T>(property, warnings);
    }

    protected void _prepareParameters(T property, VCardParameters copy, VCardVersion version, VCard vcard) {
    }

    protected abstract VCardDataType _defaultDataType(VCardVersion var1);

    protected VCardDataType _dataType(T property, VCardVersion version) {
        return this._defaultDataType(version);
    }

    protected abstract String _writeText(T var1, VCardVersion var2);

    protected void _writeXml(T property, XCardElement element) {
        String value = this.writeText(property, VCardVersion.V4_0);
        VCardDataType dataType = this.dataType(property, VCardVersion.V4_0);
        element.append(dataType, value);
    }

    protected JCardValue _writeJson(T property) {
        String value = this.writeText(property, VCardVersion.V4_0);
        return JCardValue.single(value);
    }

    protected abstract T _parseText(String var1, VCardDataType var2, VCardVersion var3, VCardParameters var4, List<String> var5);

    protected T _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String value = null;
        VCardDataType dataType = null;
        Element rawElement = element.element();
        List<Element> children = XmlUtils.toElementList(rawElement.getChildNodes());
        for (Element child : children) {
            if (!element.version().getXmlNamespace().equals(child.getNamespaceURI())) continue;
            dataType = VCardDataType.get(child.getLocalName());
            value = child.getTextContent();
            break;
        }
        if (dataType == null) {
            value = rawElement.getTextContent();
        }
        value = VCardPropertyScribe.escape(value);
        return this._parseText(value, dataType, element.version(), parameters, warnings);
    }

    protected T _parseHtml(HCardElement element, List<String> warnings) {
        String value = VCardPropertyScribe.escape(element.value());
        VCardParameters parameters = new VCardParameters();
        T property = this._parseText(value, null, VCardVersion.V3_0, parameters, warnings);
        ((VCardProperty)property).setParameters(parameters);
        return property;
    }

    protected T _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        return this._parseText(VCardPropertyScribe.jcardValueToString(value), dataType, VCardVersion.V4_0, parameters, warnings);
    }

    private static String jcardValueToString(JCardValue value) {
        List<List<String>> structured;
        List<String> multi;
        if (value.getValues().size() > 1 && !(multi = value.asMulti()).isEmpty()) {
            return VCardPropertyScribe.list(multi);
        }
        if (!value.getValues().isEmpty() && value.getValues().get(0).getArray() != null && !(structured = value.asStructured()).isEmpty()) {
            return VCardPropertyScribe.structured(structured.toArray());
        }
        return VCardPropertyScribe.escape(value.asSingle());
    }

    public static String unescape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = null;
        boolean escaped = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (escaped) {
                if (sb == null) {
                    sb = new StringBuilder(text.length());
                    sb.append(text.substring(0, i - 1));
                }
                escaped = false;
                if (ch == 'n' || ch == 'N') {
                    sb.append(StringUtils.NEWLINE);
                    continue;
                }
                sb.append(ch);
                continue;
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? text : sb.toString();
    }

    public static String escape(String text) {
        if (text == null) {
            return null;
        }
        String chars = "\\,;";
        StringBuilder sb = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (chars.indexOf(ch) >= 0) {
                if (sb == null) {
                    sb = new StringBuilder(text.length());
                    sb.append(text.substring(0, i));
                }
                sb.append('\\');
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? text : sb.toString();
    }

    protected static Splitter split(String string, String delimiter) {
        return new Splitter(string, delimiter);
    }

    protected static List<String> list(String value) {
        if (value.length() == 0) {
            return new ArrayList<String>(0);
        }
        return VCardPropertyScribe.split(value, ",").unescape(true).split();
    }

    protected static String list(Object ... values) {
        return VCardPropertyScribe.list(Arrays.asList(values));
    }

    protected static <T> String list(Collection<T> values) {
        return StringUtils.join(values, ",", new StringUtils.JoinCallback<T>(){

            @Override
            public void handle(StringBuilder sb, T value) {
                if (value == null) {
                    return;
                }
                sb.append(VCardPropertyScribe.escape(value.toString()));
            }
        });
    }

    protected static SemiStructuredIterator semistructured(String value) {
        return VCardPropertyScribe.semistructured(value, -1);
    }

    protected static SemiStructuredIterator semistructured(String value, int limit) {
        List<String> split = VCardPropertyScribe.split(value, ";").unescape(true).limit(limit).split();
        return new SemiStructuredIterator(split.iterator());
    }

    protected static StructuredIterator structured(String value) {
        List<String> split = VCardPropertyScribe.split(value, ";").split();
        ArrayList<List<String>> components = new ArrayList<List<String>>(split.size());
        for (String s : split) {
            components.add(VCardPropertyScribe.list(s));
        }
        return new StructuredIterator(components.iterator());
    }

    protected static StructuredIterator structured(JCardValue value) {
        return new StructuredIterator(value.asStructured().iterator());
    }

    protected static String structured(Object ... values) {
        return StringUtils.join(Arrays.asList(values), ";", new StringUtils.JoinCallback<Object>(){

            @Override
            public void handle(StringBuilder sb, Object value) {
                if (value == null) {
                    return;
                }
                if (value instanceof Collection) {
                    Collection list = (Collection)value;
                    sb.append(VCardPropertyScribe.list(list));
                    return;
                }
                sb.append(VCardPropertyScribe.escape(value.toString()));
            }
        });
    }

    protected static Date date(String value) {
        return VCardDateFormatter.parse(value);
    }

    protected static DateWriter date(Date date) {
        return new DateWriter(date);
    }

    protected static CannotParseException missingXmlElements(VCardDataType ... dataTypes) {
        String[] elements = new String[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            VCardDataType dataType = dataTypes[i];
            elements[i] = dataType == null ? "unknown" : dataType.getName().toLowerCase();
        }
        return VCardPropertyScribe.missingXmlElements(elements);
    }

    protected static CannotParseException missingXmlElements(String ... elements) {
        String message;
        switch (elements.length) {
            case 0: {
                message = "Property value empty.";
                break;
            }
            case 1: {
                message = "Property value empty (no <" + elements[0] + "> element found).";
                break;
            }
            case 2: {
                message = "Property value empty (no <" + elements[0] + "> or <" + elements[1] + "> elements found).";
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder();
                sb.append("Property value empty (no ");
                StringUtils.join(Arrays.asList(elements).subList(0, elements.length - 1), ", ", sb, new StringUtils.JoinCallback<String>(){

                    @Override
                    public void handle(StringBuilder sb, String value) {
                        sb.append('<').append(value).append('>');
                    }
                });
                sb.append(", or <").append(elements[elements.length - 1]).append("> elements found).");
                message = sb.toString();
            }
        }
        return new CannotParseException(message);
    }

    protected static void handlePrefParam(VCardProperty property, VCardParameters copy, VCardVersion version, VCard vcard) {
        block0 : switch (version) {
            case V2_1: 
            case V3_0: {
                copy.setPref(null);
                VCardProperty mostPreferred = null;
                for (VCardProperty p : vcard.getProperties(property.getClass())) {
                    Integer pref = p.getParameters().getPref();
                    if (pref == null || mostPreferred != null && pref >= mostPreferred.getParameters().getPref()) continue;
                    mostPreferred = p;
                }
                if (property != mostPreferred) break;
                copy.addType("pref");
                break;
            }
            case V4_0: {
                for (String type : property.getParameters().getTypes()) {
                    if (!"pref".equalsIgnoreCase(type)) continue;
                    copy.removeType(type);
                    copy.setPref(1);
                    break block0;
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Result<T extends VCardProperty> {
        private final T property;
        private final List<String> warnings;

        public Result(T property, List<String> warnings) {
            this.property = property;
            this.warnings = warnings;
        }

        public List<String> getWarnings() {
            return this.warnings;
        }

        public T getProperty() {
            return this.property;
        }
    }

    protected static class DateWriter {
        private Date date;
        private boolean hasTime = true;
        private boolean extended = false;
        private boolean utc = true;

        public DateWriter(Date date) {
            this.date = date;
        }

        public DateWriter time(boolean hasTime) {
            this.hasTime = hasTime;
            return this;
        }

        public DateWriter extended(boolean extended) {
            this.extended = extended;
            return this;
        }

        public DateWriter utc(boolean utc) {
            this.utc = utc;
            return this;
        }

        public String write() {
            ISOFormat format = this.hasTime ? (this.utc ? (this.extended ? ISOFormat.UTC_TIME_EXTENDED : ISOFormat.UTC_TIME_BASIC) : (this.extended ? ISOFormat.TIME_EXTENDED : ISOFormat.TIME_BASIC)) : (this.extended ? ISOFormat.DATE_EXTENDED : ISOFormat.DATE_BASIC);
            return VCardDateFormatter.format(this.date, format);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SemiStructuredIterator {
        private final Iterator<String> it;

        public SemiStructuredIterator(Iterator<String> it) {
            this.it = it;
        }

        public String next() {
            if (!this.hasNext()) {
                return null;
            }
            String value = this.it.next();
            return value.length() == 0 ? null : value;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StructuredIterator {
        private final Iterator<List<String>> it;

        public StructuredIterator(Iterator<List<String>> it) {
            this.it = it;
        }

        public String nextString() {
            if (!this.hasNext()) {
                return null;
            }
            List<String> list = this.it.next();
            if (list.isEmpty()) {
                return null;
            }
            String value = list.get(0);
            return value.length() == 0 ? null : value;
        }

        public List<String> nextComponent() {
            if (!this.hasNext()) {
                return new ArrayList<String>(0);
            }
            List<String> list = this.it.next();
            if (list.size() == 1 && list.get(0).length() == 0) {
                return new ArrayList<String>(0);
            }
            return list;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Splitter {
        private String string;
        private String delimiter;
        private boolean removeEmpties = false;
        private boolean unescape = false;
        private int limit = -1;

        public Splitter(String string, String delimiter) {
            this.string = string;
            this.delimiter = delimiter;
        }

        public Splitter removeEmpties(boolean removeEmpties) {
            this.removeEmpties = removeEmpties;
            return this;
        }

        public Splitter unescape(boolean unescape) {
            this.unescape = unescape;
            return this;
        }

        public Splitter limit(int limit) {
            this.limit = limit;
            return this;
        }

        public List<String> split() {
            String[] split = this.string.split("\\s*(?<!\\\\)" + Pattern.quote(this.delimiter) + "\\s*", this.limit);
            ArrayList<String> list = new ArrayList<String>(split.length);
            for (String s : split) {
                if (s.length() == 0 && this.removeEmpties) continue;
                if (this.unescape) {
                    s = VCardPropertyScribe.unescape(s);
                }
                list.add(s);
            }
            return list;
        }
    }
}

