/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.text;

import ezvcard.VCardException;
import ezvcard.VCardVersion;
import ezvcard.io.text.FoldedLineReader;
import ezvcard.parameter.VCardParameters;
import ezvcard.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;

public class VCardRawReader
implements Closeable {
    private final FoldedLineReader reader;
    private boolean caretDecodingEnabled = true;
    private boolean eof = false;
    private VCardVersion version = VCardVersion.V2_1;

    public VCardRawReader(Reader reader) {
        this.reader = new FoldedLineReader(reader);
    }

    public int getLineNum() {
        return this.reader.getLineNum();
    }

    public void start(VCardDataStreamListener listener) throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null) {
            try {
                this.parseLine(line, listener);
            }
            catch (StopReadingException e) {
                return;
            }
        }
        this.eof = true;
    }

    private void parseLine(String line, VCardDataStreamListener listener) {
        String group = null;
        String propertyName = null;
        VCardParameters parameters = new VCardParameters();
        String value = null;
        char escapeChar = '\u0000';
        boolean inQuotes = false;
        StringBuilder buffer = new StringBuilder();
        String curParamName = null;
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (escapeChar != '\u0000') {
                if (escapeChar == '\\') {
                    if (ch == '\\') {
                        buffer.append(ch);
                    } else if (ch == 'n' || ch == 'N') {
                        buffer.append(StringUtils.NEWLINE);
                    } else if (ch == '\"' && this.version != VCardVersion.V2_1) {
                        buffer.append(ch);
                    } else if (ch == ';' && this.version == VCardVersion.V2_1) {
                        buffer.append(ch);
                    } else {
                        buffer.append(escapeChar).append(ch);
                    }
                } else if (escapeChar == '^') {
                    if (ch == '^') {
                        buffer.append(ch);
                    } else if (ch == 'n') {
                        buffer.append(StringUtils.NEWLINE);
                    } else if (ch == '\'') {
                        buffer.append('\"');
                    } else {
                        buffer.append(escapeChar).append(ch);
                    }
                }
                escapeChar = '\u0000';
                continue;
            }
            if (ch == '\\' || ch == '^' && this.version != VCardVersion.V2_1 && this.caretDecodingEnabled) {
                escapeChar = ch;
                continue;
            }
            if (ch == '.' && group == null && propertyName == null) {
                group = buffer.toString();
                buffer.setLength(0);
                continue;
            }
            if (!(ch != ';' && ch != ':' || inQuotes)) {
                if (propertyName == null) {
                    propertyName = buffer.toString();
                } else {
                    String paramValue = buffer.toString();
                    if (this.version == VCardVersion.V2_1) {
                        paramValue = StringUtils.ltrim(paramValue);
                    }
                    parameters.put(curParamName, paramValue);
                    curParamName = null;
                }
                buffer.setLength(0);
                if (ch != ':') continue;
                if (i < line.length() - 1) {
                    value = line.substring(i + 1);
                    break;
                }
                value = "";
                break;
            }
            if (ch == ',' && !inQuotes && this.version != VCardVersion.V2_1) {
                parameters.put(curParamName, buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (ch == '=' && curParamName == null) {
                String paramName = buffer.toString();
                if (this.version == VCardVersion.V2_1) {
                    paramName = StringUtils.rtrim(paramName);
                }
                curParamName = paramName;
                buffer.setLength(0);
                continue;
            }
            if (ch == '\"' && this.version != VCardVersion.V2_1) {
                inQuotes = !inQuotes;
                continue;
            }
            buffer.append(ch);
        }
        if (propertyName == null || value == null) {
            listener.invalidLine(line);
            return;
        }
        if ("VERSION".equalsIgnoreCase(propertyName)) {
            VCardVersion version = VCardVersion.valueOfByStr(value.trim());
            if (version == null) {
                listener.invalidVersion(value);
            } else {
                this.version = version;
                listener.readVersion(version);
            }
            return;
        }
        if ("BEGIN".equalsIgnoreCase(propertyName)) {
            listener.beginComponent(value.trim());
            return;
        }
        if ("END".equalsIgnoreCase(propertyName)) {
            listener.endComponent(value.trim());
            return;
        }
        listener.readProperty(group, propertyName, parameters, value);
    }

    public boolean isCaretDecodingEnabled() {
        return this.caretDecodingEnabled;
    }

    public void setCaretDecodingEnabled(boolean enable) {
        this.caretDecodingEnabled = enable;
    }

    public boolean eof() {
        return this.eof;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public static class StopReadingException
    extends VCardException {
    }

    public static interface VCardDataStreamListener {
        public void beginComponent(String var1);

        public void readProperty(String var1, String var2, VCardParameters var3, String var4);

        public void readVersion(VCardVersion var1);

        public void endComponent(String var1);

        public void invalidLine(String var1);

        public void invalidVersion(String var1);
    }
}

