/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.text;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.scribe.RawPropertyScribe;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.VCardRawReader;
import ezvcard.parameter.Encoding;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Address;
import ezvcard.property.Label;
import ezvcard.property.RawProperty;
import ezvcard.property.VCardProperty;
import ezvcard.util.IOUtils;
import ezvcard.util.StringUtils;
import ezvcard.util.org.apache.commons.codec.DecoderException;
import ezvcard.util.org.apache.commons.codec.net.QuotedPrintableCodec;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardReader
implements Closeable {
    private final List<String> warnings = new ArrayList<String>();
    private ScribeIndex index = new ScribeIndex();
    private final VCardRawReader reader;

    public VCardReader(String str) {
        this(new StringReader(str));
    }

    public VCardReader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public VCardReader(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public VCardReader(Reader reader) {
        this.reader = new VCardRawReader(reader);
    }

    public boolean isCaretDecodingEnabled() {
        return this.reader.isCaretDecodingEnabled();
    }

    public void setCaretDecodingEnabled(boolean enable) {
        this.reader.setCaretDecodingEnabled(enable);
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public List<String> getWarnings() {
        return new ArrayList<String>(this.warnings);
    }

    public VCard readNext() throws IOException {
        if (this.reader.eof()) {
            return null;
        }
        this.warnings.clear();
        VCardDataStreamListenerImpl listener = new VCardDataStreamListenerImpl();
        this.reader.start(listener);
        return listener.root;
    }

    private void handleNamelessParameters(VCardParameters parameters) {
        List namelessParamValues = parameters.get(null);
        for (String paramValue : namelessParamValues) {
            String paramName = VCardDataType.find(paramValue) != null ? "VALUE" : (Encoding.find(paramValue) != null ? "ENCODING" : "TYPE");
            parameters.put(paramName, paramValue);
        }
        parameters.removeAll(null);
    }

    private void handleQuotedMultivaluedTypeParams(VCardParameters parameters) {
        for (String typeParam : parameters.getTypes()) {
            if (!typeParam.contains(",")) continue;
            parameters.removeTypes();
            for (String splitValue : typeParam.split(",")) {
                parameters.addType(splitValue);
            }
        }
    }

    private String decodeQuotedPrintable(String name, VCardParameters parameters, String value) {
        if (parameters.getEncoding() != Encoding.QUOTED_PRINTABLE) {
            return value;
        }
        parameters.setEncoding(null);
        QuotedPrintableCodec codec = new QuotedPrintableCodec();
        String charset = parameters.getCharset();
        try {
            if (charset == null) {
                return codec.decode(value);
            }
            try {
                return codec.decode(value, charset);
            }
            catch (UnsupportedEncodingException e) {
                this.addWarning("The specified charset is not supported.  Using default charset instead: " + charset, name);
                return codec.decode(value);
            }
        }
        catch (DecoderException e) {
            this.addWarning("Property value was marked as \"quoted-printable\", but it could not be decoded.  Treating the value as plain text.", name);
            return value;
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private void addWarning(String message) {
        this.addWarning(message, null);
    }

    private void addWarning(String message, String propertyName) {
        StringBuilder sb = new StringBuilder();
        sb.append("Line ").append(this.reader.getLineNum());
        if (propertyName != null) {
            sb.append(" (").append(propertyName).append(" property)");
        }
        sb.append(": ").append(message);
        this.warnings.add(sb.toString());
    }

    private class VCardDataStreamListenerImpl
    implements VCardRawReader.VCardDataStreamListener {
        private VCard root;
        private final List<Label> labels = new ArrayList<Label>();
        private final LinkedList<VCard> vcardStack = new LinkedList();
        private EmbeddedVCardException embeddedVCardException;

        private VCardDataStreamListenerImpl() {
        }

        public void beginComponent(String name) {
            if (!"VCARD".equalsIgnoreCase(name)) {
                return;
            }
            VCard vcard = new VCard();
            vcard.setVersion(VCardVersion.V2_1);
            this.vcardStack.add(vcard);
            if (this.root == null) {
                this.root = vcard;
            }
            if (this.embeddedVCardException != null) {
                this.embeddedVCardException.injectVCard(vcard);
                this.embeddedVCardException = null;
            }
        }

        public void readVersion(VCardVersion version) {
            if (this.vcardStack.isEmpty()) {
                return;
            }
            this.vcardStack.getLast().setVersion(version);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readProperty(String group, String name, VCardParameters parameters, String value) {
            VCardProperty property;
            VCardDataType dataType;
            if (this.vcardStack.isEmpty()) {
                return;
            }
            if (this.embeddedVCardException != null) {
                this.embeddedVCardException.injectVCard(null);
                this.embeddedVCardException = null;
            }
            VCard curVCard = this.vcardStack.getLast();
            VCardVersion version = curVCard.getVersion();
            VCardReader.this.handleNamelessParameters(parameters);
            VCardReader.this.handleQuotedMultivaluedTypeParams(parameters);
            value = VCardReader.this.decodeQuotedPrintable(name, parameters, value);
            RawPropertyScribe scribe = VCardReader.this.index.getPropertyScribe(name);
            if (scribe == null) {
                scribe = new RawPropertyScribe(name);
            }
            if ((dataType = parameters.getValue()) == null) {
                dataType = scribe.defaultDataType(version);
            } else {
                parameters.setValue(null);
            }
            try {
                VCardPropertyScribe.Result result = scribe.parseText(value, dataType, version, parameters);
                for (String warning : result.getWarnings()) {
                    VCardReader.this.addWarning(warning, name);
                }
                property = result.getProperty();
                property.setGroup(group);
                if (property instanceof Label) {
                    this.labels.add((Label)property);
                    return;
                }
            }
            catch (SkipMeException e) {
                VCardReader.this.addWarning("Property has requested that it be skipped: " + e.getMessage(), name);
                return;
            }
            catch (CannotParseException e) {
                VCardReader.this.addWarning("Property value could not be parsed.  Property will be saved as an extended property instead." + StringUtils.NEWLINE + "  Value: " + value + StringUtils.NEWLINE + "  Reason: " + e.getMessage(), name);
                property = new RawProperty(name, value);
                property.setGroup(group);
            }
            catch (EmbeddedVCardException e) {
                property = e.getProperty();
                if (value.length() == 0 || version == VCardVersion.V2_1) {
                    this.embeddedVCardException = e;
                }
                value = VCardPropertyScribe.unescape(value);
                VCardReader agentReader = new VCardReader(value);
                try {
                    VCard nestedVCard = agentReader.readNext();
                    if (nestedVCard != null) {
                        e.injectVCard(nestedVCard);
                    }
                }
                catch (IOException e2) {
                }
                finally {
                    for (String w : agentReader.getWarnings()) {
                        VCardReader.this.addWarning("Problem unmarshalling nested vCard value: " + w, name);
                    }
                    IOUtils.closeQuietly(agentReader);
                }
            }
            curVCard.addProperty(property);
        }

        public void endComponent(String name) {
            if (this.vcardStack.isEmpty()) {
                return;
            }
            if (!"VCARD".equalsIgnoreCase(name)) {
                return;
            }
            VCard curVCard = this.vcardStack.removeLast();
            for (Label label : this.labels) {
                boolean orphaned = true;
                for (Address adr : curVCard.getAddresses()) {
                    if (adr.getLabel() != null || !((Object)adr.getTypes()).equals(label.getTypes())) continue;
                    adr.setLabel((String)label.getValue());
                    orphaned = false;
                    break;
                }
                if (!orphaned) continue;
                curVCard.addOrphanedLabel(label);
            }
            if (this.vcardStack.isEmpty()) {
                throw new VCardRawReader.StopReadingException();
            }
        }

        public void invalidLine(String line) {
            if (this.vcardStack.isEmpty()) {
                return;
            }
            VCardReader.this.addWarning("Skipping malformed line: \"" + line + "\"");
        }

        public void invalidVersion(String version) {
            if (this.vcardStack.isEmpty()) {
                return;
            }
            VCardReader.this.addWarning("Ignoring invalid version value: " + version, "VERSION");
        }
    }
}

