/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.text;

import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.FoldingScheme;
import ezvcard.io.text.VCardRawWriter;
import ezvcard.parameter.AddressType;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Address;
import ezvcard.property.Label;
import ezvcard.property.ProductId;
import ezvcard.property.RawProperty;
import ezvcard.property.TextProperty;
import ezvcard.property.VCardProperty;
import ezvcard.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardWriter
implements Closeable,
Flushable {
    private ScribeIndex index = new ScribeIndex();
    private boolean addProdId = true;
    private boolean versionStrict = true;
    private final VCardRawWriter writer;

    public VCardWriter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public VCardWriter(OutputStream out, VCardVersion targetVersion) {
        this(targetVersion == VCardVersion.V4_0 ? IOUtils.utf8Writer(out) : new OutputStreamWriter(out), targetVersion);
    }

    public VCardWriter(OutputStream out, VCardVersion targetVersion, FoldingScheme foldingScheme, String newline) {
        this(targetVersion == VCardVersion.V4_0 ? IOUtils.utf8Writer(out) : new OutputStreamWriter(out), targetVersion, foldingScheme, newline);
    }

    public VCardWriter(File file) throws IOException {
        this(new FileWriter(file, false));
    }

    public VCardWriter(File file, boolean append) throws IOException {
        this(new FileWriter(file, append));
    }

    public VCardWriter(File file, boolean append, VCardVersion targetVersion) throws IOException {
        this(targetVersion == VCardVersion.V4_0 ? IOUtils.utf8Writer(file, append) : new FileWriter(file, append), targetVersion);
    }

    public VCardWriter(File file, boolean append, VCardVersion targetVersion, FoldingScheme foldingScheme, String newline) throws IOException {
        this(targetVersion == VCardVersion.V4_0 ? IOUtils.utf8Writer(file, append) : new FileWriter(file, append), targetVersion, foldingScheme, newline);
    }

    public VCardWriter(Writer writer) {
        this(writer, VCardVersion.V3_0);
    }

    public VCardWriter(Writer writer, VCardVersion targetVersion) {
        this(writer, targetVersion, FoldingScheme.MIME_DIR, "\r\n");
    }

    public VCardWriter(Writer writer, VCardVersion targetVersion, FoldingScheme foldingScheme, String newline) {
        this.writer = new VCardRawWriter(writer, targetVersion, foldingScheme, newline);
    }

    public VCardVersion getTargetVersion() {
        return this.writer.getVersion();
    }

    public void setTargetVersion(VCardVersion targetVersion) {
        this.writer.setVersion(targetVersion);
    }

    public boolean isAddProdId() {
        return this.addProdId;
    }

    public void setAddProdId(boolean addProdId) {
        this.addProdId = addProdId;
    }

    public boolean isVersionStrict() {
        return this.versionStrict;
    }

    public void setVersionStrict(boolean versionStrict) {
        this.versionStrict = versionStrict;
    }

    public boolean isCaretEncodingEnabled() {
        return this.writer.isCaretEncodingEnabled();
    }

    public void setCaretEncodingEnabled(boolean enable) {
        this.writer.setCaretEncodingEnabled(enable);
    }

    public String getNewline() {
        return this.writer.getNewline();
    }

    public FoldingScheme getFoldingScheme() {
        return this.writer.getFoldingScheme();
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public void write(VCard vcard) throws IOException {
        this.write(vcard, this.addProdId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(VCard vcard, boolean addProdId) throws IOException {
        VCardVersion targetVersion = this.writer.getVersion();
        ArrayList<VCardProperty> typesToAdd = new ArrayList<VCardProperty>();
        for (VCardProperty type : vcard) {
            Address adr;
            String labelStr;
            if (addProdId && type instanceof ProductId || this.versionStrict && !type.getSupportedVersions().contains((Object)targetVersion)) continue;
            if (this.index.getPropertyScribe(type) == null) {
                throw new IllegalArgumentException("No scribe found for property class \"" + type.getClass().getName() + "\".");
            }
            typesToAdd.add(type);
            if (!(type instanceof Address) || targetVersion != VCardVersion.V2_1 && targetVersion != VCardVersion.V3_0 || (labelStr = (adr = (Address)type).getLabel()) == null) continue;
            Label label = new Label(labelStr);
            for (AddressType t : adr.getTypes()) {
                label.addType(t);
            }
            typesToAdd.add(label);
        }
        if (addProdId) {
            TextProperty property = targetVersion == VCardVersion.V2_1 ? new RawProperty("X-PRODID", "ezvcard " + Ezvcard.VERSION) : new ProductId("ezvcard " + Ezvcard.VERSION);
            typesToAdd.add(property);
        }
        this.writer.writeBeginComponent("VCARD");
        this.writer.writeVersion();
        for (VCardProperty type : typesToAdd) {
            VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(type);
            String value = null;
            VCard nestedVCard = null;
            try {
                value = scribe.writeText(type, targetVersion);
            }
            catch (SkipMeException e) {
                continue;
            }
            catch (EmbeddedVCardException e) {
                nestedVCard = e.getVCard();
            }
            VCardParameters parameters = scribe.prepareParameters(type, targetVersion, vcard);
            if (nestedVCard == null) {
                VCardDataType defaultDataType;
                VCardDataType dataType = scribe.dataType(type, targetVersion);
                if (dataType != null && dataType != (defaultDataType = scribe.defaultDataType(targetVersion)) && (defaultDataType != VCardDataType.DATE_AND_OR_TIME || dataType != VCardDataType.DATE && dataType != VCardDataType.DATE_TIME && dataType != VCardDataType.TIME)) {
                    parameters.setValue(dataType);
                }
                this.writer.writeProperty(type.getGroup(), scribe.getPropertyName(), parameters, value);
                continue;
            }
            if (targetVersion == VCardVersion.V2_1) {
                this.writer.writeProperty(type.getGroup(), scribe.getPropertyName(), parameters, value);
                this.write(nestedVCard, false);
                continue;
            }
            StringWriter sw = new StringWriter();
            VCardWriter agentWriter = new VCardWriter(sw, targetVersion, null, "\n");
            agentWriter.setAddProdId(false);
            agentWriter.setVersionStrict(this.versionStrict);
            try {
                agentWriter.write(nestedVCard);
            }
            catch (IOException e) {
            }
            finally {
                IOUtils.closeQuietly(agentWriter);
            }
            String vCardStr = sw.toString();
            vCardStr = VCardPropertyScribe.escape(vCardStr);
            this.writer.writeProperty(type.getGroup(), scribe.getPropertyName(), parameters, vCardStr);
        }
        this.writer.writeEndComponent("VCARD");
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

