/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import ezvcard.util.UtcOffset;
import ezvcard.util.VCardDateFormatter;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timezone
extends VCardProperty
implements HasAltId {
    private UtcOffset offset;
    private String text;

    public Timezone(String text) {
        this(null, text);
    }

    public Timezone(Integer hourOffset, Integer minuteOffset) {
        this(new UtcOffset(hourOffset, minuteOffset));
    }

    public Timezone(UtcOffset offset) {
        this(offset, null);
    }

    public Timezone(Integer hourOffset, Integer minuteOffset, String text) {
        this(new UtcOffset(hourOffset, minuteOffset), text);
    }

    public Timezone(UtcOffset offset, String text) {
        this.setOffset(offset);
        this.setText(text);
    }

    public Timezone(TimeZone timezone) {
        this(UtcOffset.parse(timezone), timezone.getID());
    }

    public Integer getHourOffset() {
        return this.offset == null ? null : Integer.valueOf(this.offset.getHour());
    }

    public Integer getMinuteOffset() {
        return this.offset == null ? null : Integer.valueOf(this.offset.getMinute());
    }

    public UtcOffset getOffset() {
        return this.offset;
    }

    public void setOffset(int hourOffset, int minuteOffset) {
        this.setOffset(new UtcOffset(hourOffset, minuteOffset));
    }

    public void setOffset(UtcOffset offset) {
        this.offset = offset;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public TimeZone toTimeZone() {
        TimeZone timezone;
        if (this.text != null && (timezone = VCardDateFormatter.parseTimeZoneId(this.text)) != null) {
            return timezone;
        }
        if (this.offset != null) {
            int rawHourOffset = this.offset.getHour() * 60 * 60 * 1000;
            int rawMinuteOffset = this.offset.getMinute() * 60 * 1000;
            if (rawHourOffset < 0) {
                rawMinuteOffset *= -1;
            }
            int rawOffset = rawHourOffset + rawMinuteOffset;
            String id = this.text == null ? "" : this.text;
            return new SimpleTimeZone(rawOffset, id);
        }
        return null;
    }

    public String getType() {
        return this.parameters.getType();
    }

    public void setType(String type) {
        this.parameters.setType(type);
    }

    public String getMediaType() {
        return this.parameters.getMediaType();
    }

    public void setMediaType(String mediaType) {
        this.parameters.setMediaType(mediaType);
    }

    @Override
    public List<Integer[]> getPids() {
        return super.getPids();
    }

    @Override
    public void addPid(int localId, int clientPidMapRef) {
        super.addPid(localId, clientPidMapRef);
    }

    @Override
    public void removePids() {
        super.removePids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<String> warnings, VCardVersion version, VCard vcard) {
        if (this.offset == null && this.text == null) {
            warnings.add("Property does not have text or UTC offset values associated with it.");
        }
        if (this.offset == null && version == VCardVersion.V2_1) {
            warnings.add("Property requires a UTC offset for its value in version " + version.getVersion() + ".");
        }
        if (this.offset != null && (this.offset.getMinute() < 0 || this.offset.getMinute() > 59)) {
            warnings.add("Minute offset must be between 0 and 59.");
        }
    }
}

