/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ISOFormat {
    DATE_BASIC("\\d{8}", "yyyyMMdd"),
    DATE_EXTENDED("\\d{4}-\\d{2}-\\d{2}", "yyyy-MM-dd"),
    TIME_BASIC("\\d{8}T\\d{6}[-\\+]\\d{4}", "yyyyMMdd'T'HHmmssZ"),
    TIME_EXTENDED("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[-\\+]\\d{2}:\\d{2}", "yyyy-MM-dd'T'HH:mm:ssZ"),
    UTC_TIME_BASIC("\\d{8}T\\d{6}Z", "yyyyMMdd'T'HHmmssZ", "yyyyMMdd'T'HHmmss'Z'"),
    UTC_TIME_EXTENDED("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss'Z'"),
    HCARD_TIME_TAG("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[-\\+]\\d{2}:?\\d{2}", "yyyy-MM-dd'T'HH:mm:ssZ");

    private final Pattern pattern;
    private final String parseFormat;
    private final String formatFormat;

    private ISOFormat(String regex, String format) {
        this(regex, format, format);
    }

    private ISOFormat(String regex, String parseFormat, String formatFormat) {
        this.pattern = Pattern.compile(regex);
        this.parseFormat = parseFormat;
        this.formatFormat = formatFormat;
    }

    public boolean matches(String dateStr) {
        return this.pattern.matcher(dateStr).matches();
    }

    public DateFormat getParseDateFormat() {
        return new SimpleDateFormat(this.parseFormat);
    }

    public DateFormat getFormatDateFormat() {
        return new SimpleDateFormat(this.formatFormat);
    }
}

