/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.prefixmapper.PrefixTimeZonesMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhoneNumberToTimeZonesMapper {
    private static final String MAPPING_DATA_DIRECTORY = "/com/google/i18n/phonenumbers/timezones/data/";
    private static final String MAPPING_DATA_FILE_NAME = "map_data";
    private static final String UNKNOWN_TIMEZONE = "Etc/Unknown";
    static final List<String> UNKNOWN_TIME_ZONE_LIST = new ArrayList<String>(1);
    private static final Logger LOGGER;
    private PrefixTimeZonesMap prefixTimeZonesMap = null;

    static {
        UNKNOWN_TIME_ZONE_LIST.add(UNKNOWN_TIMEZONE);
        LOGGER = Logger.getLogger(PhoneNumberToTimeZonesMapper.class.getName());
    }

    PhoneNumberToTimeZonesMapper(String prefixTimeZonesMapDataDirectory) {
        this.prefixTimeZonesMap = PhoneNumberToTimeZonesMapper.loadPrefixTimeZonesMapFromFile(String.valueOf(prefixTimeZonesMapDataDirectory) + MAPPING_DATA_FILE_NAME);
    }

    private PhoneNumberToTimeZonesMapper(PrefixTimeZonesMap prefixTimeZonesMap) {
        this.prefixTimeZonesMap = prefixTimeZonesMap;
    }

    private static PrefixTimeZonesMap loadPrefixTimeZonesMapFromFile(String path) {
        PrefixTimeZonesMap map;
        block5: {
            InputStream source = PhoneNumberToTimeZonesMapper.class.getResourceAsStream(path);
            ObjectInputStream in = null;
            map = new PrefixTimeZonesMap();
            try {
                try {
                    in = new ObjectInputStream(source);
                    map.readExternal(in);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.toString());
                    PhoneNumberToTimeZonesMapper.close(in);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                PhoneNumberToTimeZonesMapper.close(in);
                throw throwable;
            }
            PhoneNumberToTimeZonesMapper.close(in);
        }
        return map;
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.toString());
            }
        }
    }

    public static synchronized PhoneNumberToTimeZonesMapper getInstance() {
        return LazyHolder.INSTANCE;
    }

    public List<String> getTimeZonesForGeographicalNumber(Phonenumber.PhoneNumber number) {
        return this.getTimeZonesForGeocodableNumber(number);
    }

    public List<String> getTimeZonesForNumber(Phonenumber.PhoneNumber number) {
        PhoneNumberUtil.PhoneNumberType numberType = PhoneNumberUtil.getInstance().getNumberType(number);
        if (numberType == PhoneNumberUtil.PhoneNumberType.UNKNOWN) {
            return UNKNOWN_TIME_ZONE_LIST;
        }
        if (!this.canBeGeocoded(numberType)) {
            return this.getCountryLevelTimeZonesforNumber(number);
        }
        return this.getTimeZonesForGeographicalNumber(number);
    }

    private boolean canBeGeocoded(PhoneNumberUtil.PhoneNumberType numberType) {
        return numberType == PhoneNumberUtil.PhoneNumberType.FIXED_LINE || numberType == PhoneNumberUtil.PhoneNumberType.MOBILE || numberType == PhoneNumberUtil.PhoneNumberType.FIXED_LINE_OR_MOBILE;
    }

    public static String getUnknownTimeZone() {
        return UNKNOWN_TIMEZONE;
    }

    private List<String> getTimeZonesForGeocodableNumber(Phonenumber.PhoneNumber number) {
        List<String> timezones = this.prefixTimeZonesMap.lookupTimeZonesForNumber(number);
        return Collections.unmodifiableList(timezones.isEmpty() ? UNKNOWN_TIME_ZONE_LIST : timezones);
    }

    private List<String> getCountryLevelTimeZonesforNumber(Phonenumber.PhoneNumber number) {
        List<String> timezones = this.prefixTimeZonesMap.lookupCountryLevelTimeZonesForNumber(number);
        return Collections.unmodifiableList(timezones.isEmpty() ? UNKNOWN_TIME_ZONE_LIST : timezones);
    }

    /* synthetic */ PhoneNumberToTimeZonesMapper(PrefixTimeZonesMap prefixTimeZonesMap, PhoneNumberToTimeZonesMapper phoneNumberToTimeZonesMapper) {
        this(prefixTimeZonesMap);
    }

    private static class LazyHolder {
        private static final PhoneNumberToTimeZonesMapper INSTANCE;

        static {
            PrefixTimeZonesMap map = PhoneNumberToTimeZonesMapper.loadPrefixTimeZonesMapFromFile("/com/google/i18n/phonenumbers/timezones/data/map_data");
            INSTANCE = new PhoneNumberToTimeZonesMapper(map, null);
        }

        private LazyHolder() {
        }
    }
}

