/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.prefixmapper;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.SortedMap;
import java.util.TreeSet;

abstract class PhonePrefixMapStorageStrategy {
    protected int numOfEntries = 0;
    protected final TreeSet<Integer> possibleLengths = new TreeSet();

    PhonePrefixMapStorageStrategy() {
    }

    public abstract int getPrefix(int var1);

    public abstract String getDescription(int var1);

    public abstract void readFromSortedMap(SortedMap<Integer, String> var1);

    public abstract void readExternal(ObjectInput var1) throws IOException;

    public abstract void writeExternal(ObjectOutput var1) throws IOException;

    public int getNumOfEntries() {
        return this.numOfEntries;
    }

    public TreeSet<Integer> getPossibleLengths() {
        return this.possibleLengths;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        int numOfEntries = this.getNumOfEntries();
        int i = 0;
        while (i < numOfEntries) {
            output.append(this.getPrefix(i)).append("|").append(this.getDescription(i)).append("\n");
            ++i;
        }
        return output.toString();
    }
}

