/**
 * @class Ext.calendar.data.EventMappings
 * @extends Object
 * A simple object that provides the field definitions for Event records so that they can be easily overridden.
 */
Ext.ns('Ext.calendar.data');

Ext.calendar.data.EventMappings = {
    EventId: {
        name: 'EventId',
        mapping: 'id',
        type: 'int'
    },
    CalendarId: {
        name: 'CalendarId',
        mapping: 'cid',
        type: 'int'
    },
    Title: {
        name: 'Title',
        mapping: 'title',
        type: 'string'
    },
    StartDate: {
        name: 'StartDate',
        mapping: 'start',
        type: 'date',
        dateFormat: 'c'
    },
    EndDate: {
        name: 'EndDate',
        mapping: 'end',
        type: 'date',
        dateFormat: 'c'
    },
    Notes: {
        name: 'Notes',
        mapping: 'notes',
        type: 'string'
    },
    Url: {
        name: 'Url',
        mapping: 'url',
        type: 'string'
    },
    IsAllDay: {
        name: 'IsAllDay',
        mapping: 'ad',
        type: 'boolean'
    },
    Reminder: {
        name: 'Reminder',
        mapping: 'rem',
        type: 'string'
    },
    IsNew: {
        name: 'IsNew',
        mapping: 'n',
        type: 'boolean'
    },
    QTGX:{
    	name:'QTGX',
    	mapping: 'gx',
        type: 'boolean'
    },
    Faburen:{
    	name:'Faburen',
    	 mapping: 'fabuRen',
         type: 'string'
    },
    IsEditor:{
    	name:'IsEditor',
   	 	mapping: 'isEditor',
        type: 'string'
    },
    NoticeType:{
    	name:'NoticeType',
   	 	mapping: 'noticeType',
        type: 'string'
    },
    AssPid:{
    	name:'AssPid',
   	 	mapping: 'assPid',
        type: 'string'
    },
    Source:{
    	name:'Source',
   	 	mapping: 'source',
        type: 'string'
    },
    Creater:{
    	name:'Creater',
   	 	mapping: 'creater',
        type: 'string'
    },
    CreateTime:{
    	name:'CreateTime',
   	 	mapping: 'createTime',
        type: 'string'
    }
};
