/*
 * Decompiled with CFR 0.152.
 */
package kirito.Power;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.RemoveSpecificPowerAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardQueueItem;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class DoubleCutPower
extends AbstractPower {
    public static final String POWER_ID = "DoubleCutPower";
    public static final String NAME = "\u53cc\u5203";
    public static final String[] DESCRIPTIONS = new String[]{"\u4f60\u63a5\u4e0b\u6765\u4f7f\u7528\u7684", "\u5f20\u975e\u80fd\u529b\u5361\u5c06\u6253\u51fa2\u6b21."};

    public DoubleCutPower(AbstractCreature owner, int amount) {
        this.name = "\u53cc\u65a9";
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = amount;
        this.updateDescription();
        this.img = ImageMaster.loadImage((String)"images/powers/32/burst.png");
    }

    public void updateDescription() {
        this.description = String.valueOf(DESCRIPTIONS[0]) + this.amount + DESCRIPTIONS[1];
    }

    public void onPlayCard(AbstractCard card, AbstractMonster m) {
        if (!card.purgeOnUse && this.amount > 0 && card.type != AbstractCard.CardType.POWER) {
            this.flash();
            AbstractCard tmp = card.makeStatEquivalentCopy();
            AbstractDungeon.player.limbo.addToBottom(tmp);
            tmp.current_x = card.current_x;
            tmp.current_y = card.current_y;
            tmp.target_x = (float)Settings.WIDTH / 2.0f - 300.0f * Settings.scale;
            tmp.target_y = (float)Settings.HEIGHT / 2.0f;
            tmp.freeToPlayOnce = true;
            tmp.calculateCardDamage(m);
            tmp.purgeOnUse = true;
            AbstractDungeon.actionManager.cardQueue.add(new CardQueueItem(tmp, m));
            --this.amount;
            if (this.amount == 0) {
                AbstractDungeon.actionManager.addToBottom((AbstractGameAction)new RemoveSpecificPowerAction(this.owner, this.owner, POWER_ID));
            }
        }
    }

    public void atEndOfTurn(boolean isPlayer) {
        if (isPlayer) {
            AbstractDungeon.actionManager.addToBottom((AbstractGameAction)new RemoveSpecificPowerAction(this.owner, this.owner, POWER_ID));
        }
    }
}

