//
//  BeanstalkAPIHelpers.h
//  BeanstalkAPI
//
//  Created by Alexander Rinass on 08.02.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface BeanstalkAPIHelpers : NSObject

/** @name Generating API URLs */

+ (NSString *)apiPath;
+ (NSURL *)apiHostURLWithAccountName:(NSString *)accountName;
+ (NSURL *)apiRootURLWithAccountName:(NSString *)accountName;
+ (NSString *)apiResourcePathWithPathComponents:(NSArray *)pathComponents;
+ (NSURL *)apiURLWithAccountName:(NSString *)accountName resourcePath:(NSString *)resourcePath params:(NSDictionary *)params;

/** @name Generating Web URLs */

+ (NSURL *)webURLWithAccountName:(NSString *)accountName;
+ (NSURL *)userWebURLWithAccountName:(NSString *)accountName;
+ (NSURL *)repositoryWebURLWithAccountName:(NSString *)accountName repositoryName:(NSString *)repositoryName;

/** @name Generating Request Parameters */

+ (NSDictionary *)requestParamsFromOptions:(NSDictionary *)options defaultOptions:(NSDictionary *)defaultOptions;

@end
