//
//  BitbucketAPIHelpers.h
//  BitbucketAPI
//
//  Created by Marc Beyerlin on 04.07.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface BitbucketAPIHelpers : NSObject

+ (NSURL *)apiRootURL;
+ (NSString *)apiPath;

+ (NSURL *)apiURLWithResourcePath:(NSString *)resourcePath;

+ (NSString *)resourcePathWithPathComponents:(NSArray *)pathComponents;

+ (NSURL *)userWebURLForUser:(NSString *)userName;
+ (NSURL *)repositoryWebURLForUser:(NSString *)userName repository:(NSString *)repositoryName;

+ (NSDictionary *)requestParamsFromOptions:(NSDictionary *)options defaultOptions:(NSDictionary *)defaultOptions;

+ (NSURL *)authorizationRequestURLWithClientID:(NSString *)clientID;

@end
