//
//  BitbucketAPIRequestOperation.h
//  BitbucketAPI
//
//  Created by Patrick Dinger on 07.02.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>
#import "BitbucketAPIModels.h"
#import "BitbucketAPIParsers.h"
#import "BitbucketAPIHelpers.h"
#import "BitbucketAPIConstants.h"

@class BitbucketAPIResponse;

typedef void (^BitbucketAPIRequestCompletionHandler)(BitbucketAPIResponse *response);

@class BitbucketAPICredentials;
@interface BitbucketAPIRequestOperation : FNRESTAPIRequestOperation
@property (nonatomic, readonly) BitbucketAPICredentials *credentials;
@property (nonatomic, copy) BitbucketAPIRequestCompletionHandler completionHandler;
@property (nonatomic) id result;
@property (nonatomic, readonly) NSDictionary *defaultOptions;
@property (nonatomic, readonly) BitbucketAPIResponse *APIResponse;

- (instancetype)initWithRequestURL:(NSURL *)requestURL method:(NSString *)method params:(NSDictionary *)params contentType:(NSString *)contentType credentials:(BitbucketAPICredentials *)credentials  NS_DESIGNATED_INITIALIZER;

@end
