//
//  FNGitSubmodule.h
//  FNGit
//
//  Created by Alexander Rinass on 14.01.11.
//  Copyright 2011 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNGitSubmoduleConfig.h"
#import "FNGitSubmoduleStatus.h"
#import "FNGitSubmoduleIgnoreMode.h"
#import "FNGitSubmoduleUpdateStrategy.h"
#import "FNGitSubmoduleLayout.h"
#import "FNGitSubmoduleRecurseSubmodulesOption.h"
#import "FNGitRemoveSubmoduleOptions.h"
#import "FNGitDefines.h"
#import "FNGitCommitish.h"

/**
 Some settings can be overridden by the local config. The values on the 
 submodule are the effective (config) values.
 */

@class FNGitRepository;
@class FNGitCommit;
@class FNGitRemote;
@class FNGitSubmoduleConfig;
@interface FNGitSubmodule : NSObject <FNGitCommitIsh>
@property (nonatomic, weak, readonly) FNGitRepository *repository;
@property (nonatomic, readonly) NSString *name;
@property (nonatomic, readonly) NSString *path;
@property (nonatomic, readonly) NSString *URL;
@property (nonatomic, readonly) NSString *commitHash;
@property (nonatomic, readonly) NSString *indexCommitHash;
@property (nonatomic, readonly) NSString *describe;
@property (nonatomic, readonly) NSUInteger updatedCommitsAhead;
@property (nonatomic, readonly) NSUInteger updatedCommitsBehind;
@property (nonatomic, readonly, getter = isRegistered) BOOL registered;
@property (nonatomic, readonly, getter = isDirty) BOOL dirty;
@property (nonatomic, readonly) NSUInteger numberOfDirtyChanges;
@property (nonatomic, readonly, getter = isValid) BOOL valid;
@property (nonatomic, readonly) FNGitSubmoduleStatus status;
@property (nonatomic, readonly) FNGitSubmoduleStatusIgnoreMode statusIgnoreMode;
@property (nonatomic, readonly) FNGitSubmoduleUpdateStrategy updateStrategy;
@property (nonatomic, readonly) FNGitSubmoduleFormat layoutFormat;
@property (nonatomic, readonly) FNGitSubmoduleRecurseSubmodulesOption recurseSubmodules;
@property (nonatomic, readonly) NSString *upstreamBranch;
@property (nonatomic, readonly) FNGitSubmoduleConfig *config;
@property (nonatomic, readonly) FNGitSubmoduleConfig *localConfig;

/** @name Getting the Current Commit */

@property (nonatomic, readonly) FNGitCommit *commit;

/** @name Getting the Origin Remote */

@property (nonatomic, readonly) FNGitRemote *originRemote;

/** @name Getting the Submodule's Repository */

@property (nonatomic, readonly) FNGitRepository *submoduleRepository;

/** @name Creating Submodule Objects */

+ (instancetype)submoduleWithRepository:(FNGitRepository *)repository name:(NSString *)name path:(NSString *)path;
- (instancetype)initWithRepository:(FNGitRepository *)repository name:(NSString *)name path:(NSString *)path;

@end
