//
//  NSError+FNGit.h
//  FNGit
//
//  Created by Alexander Rinass on 26.05.11.
//  Copyright 2011 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

/** @name Error Domain */

extern NSString *const FNGitErrorDomain;

/** @name Error UserInfo Keys */

extern NSString *const FNGitBinaryVersionErrorKey;
extern NSString *const FNGitCommandCallErrorKey;
extern NSString *const FNGitErrorOutputErrorKey;
extern NSString *const FNGitCommandExitCodeErrorKey;
extern NSString *const FNGitCommandErrorOutputErrorKey;
extern NSString *const FNGitCommandStandardOutputErrorKey;
extern NSString *const FNGitCommandEnvironmentErrorKey;
extern NSString *const FNGitConfigFileErrorKey;
extern NSString *const FNGitConfigKeyErrorKey;
extern NSString *const FNGitConfigValueErrorKey;
extern NSString *const FNGitConfigNewSectionNameErrorKey;
extern NSString *const FNGitConfigSectionNameErrorKey;
extern NSString *const FNGitDestinationFilePathErrorKey;
extern NSString *const FNGitFilePathErrorKey;
extern NSString *const FNGitFilePathsErrorKey;
extern NSString *const FNGitIgnoresPathErrorKey;
extern NSString *const FNGitNewRefNameErrorKey;
extern NSString *const FNGitNewRemoteNameErrorKey;
extern NSString *const FNGitNewSubmoduleNameErrorKey;
extern NSString *const FNGitObjectHashErrorKey;
extern NSString *const FNGitObjectReferenceErrorKey;
extern NSString *const FNGitOutputParserNameErrorKey;
extern NSString *const FNGitOutputParserLineErrorKey;
extern NSString *const FNGitPatchErrorKey;
extern NSString *const FNGitPatchLineNumberErrorKey;
extern NSString *const FNGitRebaseCurrentStepErrorKey;
extern NSString *const FNGitRebaseLastStepErrorKey;
extern NSString *const FNGitRebaseSubjectErrorKey;
extern NSString *const FNGitRefNameErrorKey;
extern NSString *const FNGitRefSpecErrorKey;
extern NSString *const FNGitRemoteNameErrorKey;
extern NSString *const FNGitRemoteURLErrorKey;
extern NSString *const FNGitRepositoryPathErrorKey;
extern NSString *const FNGitRevisionErrorKey;
extern NSString *const FNGitSourceFilePathErrorKey;
extern NSString *const FNGitSubmoduleNameErrorKey;
extern NSString *const FNGitSubmodulePathErrorKey;
extern NSString *const FNGitStashIndexErrorKey;

/** @name Error Codes */

typedef NS_ENUM(NSInteger, FNGitError) {
    FNGitGenericError = 1,
    
    FNGitCommandUsageError,
    FNGitOutputParserError,
    
    // Common Errors
    FNGitNoGitRepoError,
    FNGitNoRefsError,
    FNGitNoWorkTreeError,
    FNGitIndexLockError,
    FNGitRefsReadError,
    FNGitBadDefaultRevisionError,
    FNGitBadRevisionError,
    
    // Common Synchronization Errors
    FNGitAskpassError,
    FNGitRemoteSyncError,
    FNGitRemoteAuthError,
    FNGitRemoteConnectionError,
    
    // Description File Read/Write Errors
    FNGitDescriptionReadError,
    FNGitDescriptionWriteError,
    
    // Ignores Files Read/Write Errors
    FNGitIgnoresReadError,
    FNGitIgnoresWriteError,
    
    // git config
    FNGitConfigBadValueError,
    FNGitConfigInvalidFileError,
    FNGitConfigKeyNotFoundError,
    FNGitConfigMultipleValuesForKeyError,
    FNGitConfigReadError,
    FNGitConfigSectionNotFoundError,
    FNGitConfigWriteError,
    
    // git init
    FNGitInitRepositoryFileExistsError,
    FNGitInitRepositoryPathNotWritableError,
    FNGitInitRepositoryInvalidPathError,
    
    // git show
    FNGitBlobReadError,
    FNGitBlobNotFoundError,
    
    // git add
    FNGitAddFilesError,
    
    // git apply
    FNGitApplyPatchCorruptError,
    FNGitApplyPatchWithNoChangesError,
    FNGitApplyPatchWithNoTargetError,
    
    // git archive
    FNGitArchiveFilesError,
    
    // git checkout
    FNGitCheckoutUncommittedChangesError,
    
    // git tag
    FNGitCreateTagAlreadyExistsError,
    FNGitCreateTagInvalidObjectError,
    FNGitDeleteTagNotFoundError,
    
    // git svn
    FNGitSVNInstallationError,
    
    // git log
    FNGitLogNoSuchRevisionError,
    
    // git merge(+pull|cherry-pick|revert)
    FNGitMergeConflictsError,
    FNGitMergeUncommittedChangesError,
    FNGitMergeUnmergedChangesError,
    FNGitMergetoolMergeFailedError,
    FNGitNoDefaultMergeBranchError,
    
    // git move
    FNGitMoveFileAlreadyExistsError,
    FNGitMoveFileDestinationDirectoryMissingError,
    FNGitMoveFileNotUnderVersionControlError,
    FNGitMoveFileOutsideRepositoryError,
    FNGitMoveFileSelfTargetError,
    FNGitMoveFileSourceDirectoryEmptyError,
    FNGitMoveFileSourceNotFoundError,
    
    // git rebase
    FNGitRebaseConflictsError,
    FNGitRebaseUncommittedChangesError,
    FNGitRebaseUnmergedChangesError,
    
    // git remote
    FNGitCreateRemoteAlreadyExistsError,
    FNGitCreateRemoteInvalidNameError,
    FNGitRenameRemoteAlreadyExistsError,
    FNGitRenameRemoteInvalidNameError,
    
    // git push
    FNGitRemotePushNoUpstreamBranchError,
    FNGitRemotePushRejectedError,
    
    // git branch
    FNGitCreateBranchFromStashInvalidNameError,
    FNGitCreateBranchFromStashNotFoundError,
    FNGitCreateBranchFromStashNoStashesError,
    FNGitCreateBranchFromStashUncommittedChangesError,
    FNGitCreateBranchInvalidNameError,
    FNGitCreateBranchInvalidObjectError,
    FNGitCreateBranchRefAlreadyExistsError,
    FNGitRenameBranchInvalidObjectError,
    FNGitRenameBranchRefAlreadyExistsError,
    FNGitTrackBranchInvalidObjectError,
    FNGitDeleteBranchNoSuchBranchError,
    FNGitDeleteCurrentBranchError,
    FNGitDeleteUnmergedBranchError,
    
    // git rm
    FNGitRemoveOperationNotPermittedError,
    FNGitRemoveFileWithLocalModificationsError,
    FNGitRemoveSubmoduleWithLocalModificationsError,
    
    // git stash
    FNGitSaveStashInitialCommitError,
    FNGitApplyStashMergeConflictsError,
    FNGitApplyStashNotFoundError,
    FNGitApplyStashNoStashesError,
    FNGitApplyStashUncommittedChangesError,
    FNGitDropStashNotFoundError,
    FNGitDropStashNoStashesError,
    
    // git submodule
    FNGitSubmoduleStatusMissingMappingError,
    FNGitSubmoduleStatusMissingGitDirError,
    FNGitAddSubmodulePathOutsideRepositoryError,
    FNGitAddSubmodulePathAlreadyExistsError,
    FNGitAddSubmoduleGitDirectoryAlreadyExistsError,
    
    // git ls-tree Errors
    FNGitTreeNotATreeObjectError,
    FNGitTreeNotFoundError,
    
    // git update-index Errors
    FNGitUpdateIndexNoSuchFileError,
};

@class FNGitCommand;
@interface NSError (FNGit)

+ (instancetype)gitErrorWithCode:(NSInteger)code userInfo:(NSDictionary *)userInfo;
+ (instancetype)gitErrorWithCommand:(FNGitCommand *)command userInfo:(NSDictionary *)userInfo;

@end
