//
//  GitHubAuthorization.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 04/05/15.
//  Copyright (c) 2015 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>

@class GitHubAPIApp;
@interface GitHubAPIAuthorization : FNRESTAPIModel
@property (nonatomic, readonly) NSInteger authorizationID;
@property (nonatomic) NSArray *scopes;
@property (nonatomic, readonly) NSURL *URL;
@property (nonatomic, readonly) NSString *token;
@property (nonatomic, readonly) NSString *hashedToken;
@property (nonatomic) GitHubAPIApp *app;
@property (nonatomic) NSString *clientID;
@property (nonatomic) NSString *clientSecret;
@property (nonatomic) NSString *note;
@property (nonatomic) NSURL *noteURL;
@property (nonatomic) NSString *fingerprint;

+ (instancetype)authorizationWithJSONObject:(NSDictionary *)JSONObject;
- (BOOL)isEqualToGitHubAPIAuthorization:(GitHubAPIAuthorization *)object;

@end
