//
//  GitHubAPIClient.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 19.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GitHubAPICredentials;
@class GitHubAPIRequest;
@class GitHubAPIResponse;
@class GitHubAPIRequestOperation;
@class GitHubAPIAccount;
@class GitHubAPIAuthorization;
@class GitHubAPIApp;
@class GitHubAPIRepository;
@class GitHubAPIPublicKey;
@interface GitHubAPIClient : NSObject
@property (nonatomic) GitHubAPICredentials *credentials;
@property (nonatomic) NSString *userAgentString;

+ (instancetype)clientWithCredentials:(GitHubAPICredentials *)credentials;
- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials;

/** @name Enqueuing and Executing API Requests */

- (GitHubAPIRequest *)enqueueRequest:(GitHubAPIRequestOperation *)request completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;

- (void)cancelAllRequests;
- (NSArray *)allRequests;

/** @name Executing Authorization API Requests */

- (GitHubAPIRequest *)fetchAllAuthorizationsWithOptions:(NSDictionary *)options completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)fetchOrCreateAuthorization:(GitHubAPIAuthorization *)authorization completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)resetAuthorizationForAppWithClientID:(NSString *)clientID accessToken:(NSString *)accessToken completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)deleteAuthorizationWithID:(NSUInteger)authorizationID completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;

/** @name Executing Account API Requests */

- (GitHubAPIRequest *)searchAllUsersWithKeyword:(NSString *)keyword options:(NSDictionary *)options completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)fetchCurrentUserWithCompletionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)fetchUserWithName:(NSString *)username completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)updateUser:(GitHubAPIAccount *)user completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;

/** @name Executing Organization API Requests */

- (GitHubAPIRequest *)fetchAllOrganizationsForCurrentUserWithOptions:(NSDictionary *)options completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)fetchAllOrganizationsForUserWithName:(NSString *)username options:(NSDictionary *)options completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)fetchOrganizationWithName:(NSString *)organizationName completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)updateOrganization:(GitHubAPIAccount *)organization completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;

/** @name Executing Repository API Requests */

- (GitHubAPIRequest *)fetchAllRepositoriesForCurrentUserWithOptions:(NSDictionary *)options completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)fetchAllRepositoriesForUserWithName:(NSString *)username options:(NSDictionary *)options completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)fetchAllRepositoriesForOrganizationWithName:(NSString *)organizationName options:(NSDictionary *)options completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;

- (GitHubAPIRequest *)fetchRepositoryForCurrentUserWithName:(NSString *)repositoryName completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)fetchRepositoryWithFullName:(NSString *)fullRepositoryName completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)fetchRepositoryWithName:(NSString *)repositoryName forUserWithName:(NSString *)username completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;

- (GitHubAPIRequest *)createRepository:(GitHubAPIRepository *)repository completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)createRepository:(GitHubAPIRepository *)repository inOrganizationWithName:(NSString *)organizationName completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;

- (GitHubAPIRequest *)updateRepository:(GitHubAPIRepository *)repository completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;

- (GitHubAPIRequest *)deleteRepositoryWithName:(NSString *)repositoryName completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)deleteRepositoryWithName:(NSString *)repositoryName inOrganizationWithName:(NSString *)organizationName completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;

/** @name Executing Public Key API Requests */

- (GitHubAPIRequest *)fetchAllPublicKeysForCurrentUserWithOptions:(NSDictionary *)options completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)fetchPublicKeyWithID:(NSInteger)publicKeyID completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)createPublicKey:(GitHubAPIPublicKey *)publicKey completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;
- (GitHubAPIRequest *)deletePublicKeyWithID:(NSInteger)publicKeyID completionHandler:(void (^)(GitHubAPIResponse *response))completionHandler;

@end
