//
//  GitHubFetchUserAPIRequestOperation.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 19.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import "GitHubAPIRequestOperation.h"

@class GitHubAPIAccount;
@interface GitHubAPIFetchUserRequestOperation : GitHubAPIRequestOperation
@property (nonatomic, readonly) NSString *username;
@property (nonatomic, readonly) GitHubAPIAccount *user;

+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials;
+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials username:(NSString *)username;
- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials username:(NSString *)username;

@end
