//
//  GitHubFetchAuthenticationTokenAPIRequestOperation.h
//  GitHubAPI
//
//  Created by jens bissinger on 21/05/14.
//  Copyright (c) 2014 Fournova GmbH. All rights reserved.
//

#import "GitHubAPIRequestOperation.h"

@class GitHubAPIApp;
@class GitHubAPIAuthorization;
@interface GitHubAPIGetOrCreateAuthorizationRequestOperation : GitHubAPIRequestOperation
@property (nonatomic, readonly) GitHubAPIAuthorization *authorization;
@property (nonatomic, readonly) GitHubAPIAuthorization *fetchedOrCreatedAuthorization;

+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials authorization:(GitHubAPIAuthorization *)authorization;
- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials authorization:(GitHubAPIAuthorization *)authorization;

@end
