//
//  GitHubAPIHelpers.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 08.02.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface GitHubAPIHelpers : NSObject

+ (NSURL *)apiRootURL;
+ (NSURL *)apiRootURLWithHost:(NSString *)host;
+ (NSString *)apiPath;

+ (NSURL *)apiURLWithResourcePath:(NSString *)resourcePath params:(NSDictionary *)params;
+ (NSURL *)apiURLWithHost:(NSString *)host resourcePath:(NSString *)resourcePath params:(NSDictionary *)params;

+ (NSURL *)userWebURLForAccount:(NSString *)accountName;
+ (NSURL *)repositoryWebURLForAccount:(NSString *)accountName repository:(NSString *)repositoryName;

+ (NSDictionary *)requestParamsFromOptions:(NSDictionary *)options defaultOptions:(NSDictionary *)defaultOptions;

+ (BOOL)isToken:(NSString *)token equalToHashedToken:(NSString *)hashedToken;

@end
