//
//  GitHubAPIRequestOperation.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 19.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>

@class GitHubAPIResponse;

typedef void (^GitHubAPIRequestCompletionHandler)(GitHubAPIResponse *response);

@class GitHubAPICredentials;
@interface GitHubAPIRequestOperation : FNRESTAPIRequestOperation
@property (nonatomic, readonly) GitHubAPICredentials *credentials;
@property (nonatomic, copy) GitHubAPIRequestCompletionHandler completionHandler;
@property (nonatomic) id result;
@property (nonatomic, readonly) NSDictionary *defaultOptions;
@property (nonatomic, readonly) GitHubAPIResponse *APIResponse;

- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials method:(NSString *)method path:(NSString *)path params:(NSDictionary *)params data:(id)jsonObject;

@end
