//
//  NSError+GitHubAPI.h
//  Tower
//
//  Created by Alexander Rinass on 12.04.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString *const GitHubAPIErrorDomain;

extern NSString *const GitHubAPIRequestURLErrorKey;
extern NSString *const GitHubAPIRequestPathErrorKey;
extern NSString *const GitHubAPIRequestBodyErrorKey;
extern NSString *const GitHubAPIRequestHeadersErrorKey;

extern NSString *const GitHubAPIResponseStatusCodeErrorKey;
extern NSString *const GitHubAPIResponseHeadersErrorKey;
extern NSString *const GitHubAPIResponseBodyErrorKey;

extern NSString *const GitHubAPIErrorMessageErrorKey;
extern NSString *const GitHubAPIErrorValidationInfoErrorKey;

enum {
    GitHubAPIGenericError = 1,
    GitHubAPIConnectionError,
    GitHubAPIParseError,
    
    GitHubAPIBadRequestError = 400,
    GitHubAPIAuthenticationError = 401,
    GitHubAPIAuthentication2FAError = 40102,
    GitHubAPILoginAttemptLimitExceededError = 403,
    GitHubAPIRateLimitExceededError = 40302,
    GitHubAPIResourceNotFoundError = 404,
    GitHubAPIUnprocessableEntityError = 422,
    GitHubAPIServerError = 500
};

@interface NSError (GitHubAPI)

+ (instancetype)gitHubAPIErrorWithCode:(NSInteger)code userInfo:(NSDictionary *)userInfo;
+ (instancetype)gitHubAPIConnectionErrorWithNSURLError:(NSError *)NSURLError userInfo:(NSDictionary *)userInfo;
+ (instancetype)gitHubAPIParseErrorWithError:(NSError *)error userInfo:(NSDictionary *)userInfo;

@end
