/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import thehippomaster.MutantCreatures.ChemicalXEntity;
import thehippomaster.MutantCreatures.CommonProxy;
import thehippomaster.MutantCreatures.CreeperMinion;
import thehippomaster.MutantCreatures.CreeperMinionEgg;
import thehippomaster.MutantCreatures.EnderBlock;
import thehippomaster.MutantCreatures.EndermanClone;
import thehippomaster.MutantCreatures.EndersoulFragment;
import thehippomaster.MutantCreatures.MCCreativeTab;
import thehippomaster.MutantCreatures.MCHandler;
import thehippomaster.MutantCreatures.MutantCreeper;
import thehippomaster.MutantCreatures.MutantEnderman;
import thehippomaster.MutantCreatures.MutantSkeleton;
import thehippomaster.MutantCreatures.MutantSnowGolem;
import thehippomaster.MutantCreatures.MutantZombie;
import thehippomaster.MutantCreatures.SGolemBlock;
import thehippomaster.MutantCreatures.SkeletonPart;
import thehippomaster.MutantCreatures.SkeletonShot;
import thehippomaster.MutantCreatures.SkullSpirit;
import thehippomaster.MutantCreatures.SpiderPig;
import thehippomaster.MutantCreatures.Zombie;
import thehippomaster.MutantCreatures.ZombieChunk;
import thehippomaster.MutantCreatures.client.FXEnder;
import thehippomaster.MutantCreatures.item.ChemicalX;
import thehippomaster.MutantCreatures.item.CreeperShard;
import thehippomaster.MutantCreatures.item.CreeperStats;
import thehippomaster.MutantCreatures.item.EndersoulHand;
import thehippomaster.MutantCreatures.item.HulkHammer;
import thehippomaster.MutantCreatures.item.ItemSkeletonPart;
import thehippomaster.MutantCreatures.item.MCSpawnEgg;
import thehippomaster.MutantCreatures.item.SkeletonArmor;
import thehippomaster.MutantCreatures.packet.PacketCMOptions;
import thehippomaster.MutantCreatures.packet.PacketEHandPos;
import thehippomaster.MutantCreatures.packet.PacketEnderAttack;
import thehippomaster.MutantCreatures.packet.PacketEnderBlock;
import thehippomaster.MutantCreatures.packet.PacketEnderTPlayer;
import thehippomaster.MutantCreatures.packet.PacketEnderTeleport;
import thehippomaster.MutantCreatures.packet.PacketSkeleAttack;
import thehippomaster.MutantCreatures.packet.PacketSnowGolemAttack;
import thehippomaster.MutantCreatures.packet.PacketSnowGolemOwner;
import thehippomaster.MutantCreatures.packet.PacketSpawnParticles;
import thehippomaster.MutantCreatures.packet.PacketZombieAttack;

@Mod(modid="MutantCreatures", name="Mutant Creatures", version="1.4.8")
public class MutantCreatures {
    @Mod.Instance(value="MutantCreatures")
    public static MutantCreatures instance;
    @SidedProxy(clientSide="thehippomaster.MutantCreatures.client.ClientProxy", serverSide="thehippomaster.MutantCreatures.CommonProxy")
    public static CommonProxy proxy;
    public static MCHandler mcHandler;
    public static SimpleNetworkWrapper wrapper;
    public static Item creeperShard;
    public static Item creeperStats;
    public static Item hulkHammer;
    public static Item chemicalX;
    public static Item endersoulHand;
    public static Item skeletonPart;
    public static Item spawnEgg;
    public static Item skeleArmorHead;
    public static Item skeleArmorChest;
    public static Item skeleArmorLegs;
    public static Item skeleArmorBoots;
    public static BiomeGenBase[] suitableBiomes;
    public static Random rand;
    public static final MCCreativeTab creativeTab;
    private static int spawnrate;
    private static boolean spawnCreeper;
    private static boolean spawnZombie;
    private static boolean spawnEnderman;
    private static boolean spawnEndermanEnd;
    private static boolean spawnSkeleton;
    public static final String[] fTimer;
    public static final String[] fThrower;
    public static final String[] fShowModel;
    public static final String[] fCubeList;
    public static final String[] fChildModels;
    public static final String[] fItemInUse;
    public static final String[] fItemInUseCount;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        Configuration cfg = new Configuration(e.getSuggestedConfigurationFile());
        cfg.load();
        spawnrate = cfg.get("general", "Spawnrate", 10).getInt();
        spawnCreeper = cfg.get("general", "SpawnMutantCreeper", true).getBoolean(true);
        spawnZombie = cfg.get("general", "SpawnMutantZombie", true).getBoolean(true);
        spawnEnderman = cfg.get("general", "SpawnMutantEnderman", true).getBoolean(true);
        spawnEndermanEnd = cfg.get("general", "SpawnMutantEndermanInTheEnd", true).getBoolean(true);
        spawnSkeleton = cfg.get("general", "SpawnMutantSkeleton", true).getBoolean(true);
        cfg.save();
        mcHandler = new MCHandler();
        MinecraftForge.EVENT_BUS.register((Object)mcHandler);
        FMLCommonHandler.instance().bus().register((Object)mcHandler);
        spawnEgg = new MCSpawnEgg().func_77655_b("mcSpawnEgg").func_111206_d("spawn_egg");
        creeperShard = new CreeperShard().func_77655_b("creeperShard");
        creeperStats = new CreeperStats().func_77655_b("creeperStats");
        hulkHammer = new HulkHammer().func_77655_b("hulkHammer");
        chemicalX = new ChemicalX().func_77655_b("chemicalX");
        endersoulHand = new EndersoulHand().func_77655_b("endersoulHand");
        skeletonPart = new ItemSkeletonPart().func_77655_b("skeletonPart");
        skeleArmorHead = new SkeletonArmor(3, 0).func_77655_b("skeleArmorHead");
        skeleArmorChest = new SkeletonArmor(3, 1).func_77655_b("skeleArmorChest");
        skeleArmorLegs = new SkeletonArmor(3, 2).func_77655_b("skeleArmorLegs");
        skeleArmorBoots = new SkeletonArmor(3, 3).func_77655_b("skeleArmorBoots");
        GameRegistry.registerItem((Item)spawnEgg, (String)spawnEgg.func_77658_a());
        GameRegistry.registerItem((Item)creeperShard, (String)creeperShard.func_77658_a());
        GameRegistry.registerItem((Item)creeperStats, (String)creeperStats.func_77658_a());
        GameRegistry.registerItem((Item)hulkHammer, (String)hulkHammer.func_77658_a());
        GameRegistry.registerItem((Item)chemicalX, (String)chemicalX.func_77658_a());
        GameRegistry.registerItem((Item)endersoulHand, (String)endersoulHand.func_77658_a());
        GameRegistry.registerItem((Item)skeletonPart, (String)skeletonPart.func_77658_a());
        GameRegistry.registerItem((Item)skeleArmorHead, (String)skeleArmorHead.func_77658_a());
        GameRegistry.registerItem((Item)skeleArmorChest, (String)skeleArmorChest.func_77658_a());
        GameRegistry.registerItem((Item)skeleArmorLegs, (String)skeleArmorLegs.func_77658_a());
        GameRegistry.registerItem((Item)skeleArmorBoots, (String)skeleArmorBoots.func_77658_a());
        GameRegistry.addRecipe((ItemStack)new ItemStack(creeperStats), (Object[])new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Blocks.field_150347_e, Character.valueOf('X'), Items.field_151016_H});
        GameRegistry.addRecipe((ItemStack)new ItemStack(chemicalX), (Object[])new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Blocks.field_150343_Z, Character.valueOf('X'), Items.field_151068_bn});
        GameRegistry.addRecipe((ItemStack)new ItemStack(skeletonPart, 1, 4), (Object[])new Object[]{"# #", "X X", "X X", Character.valueOf('#'), new ItemStack(skeletonPart, 1, 3), Character.valueOf('X'), new ItemStack(skeletonPart, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(skeletonPart, 1, 5), (Object[])new Object[]{"# #", "# #", "# #", Character.valueOf('#'), new ItemStack(skeletonPart, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(skeleArmorChest), (Object[])new Object[]{"#", "X", Character.valueOf('#'), new ItemStack(skeletonPart, 1, 4), Character.valueOf('X'), new ItemStack(skeletonPart, 1, 5)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(skeleArmorLegs), (Object[])new Object[]{" # ", "X X", Character.valueOf('#'), new ItemStack(skeletonPart, 1, 2), Character.valueOf('X'), new ItemStack(skeletonPart, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(skeleArmorBoots), (Object[])new Object[]{"# #", Character.valueOf('#'), new ItemStack(skeletonPart, 1, 0)});
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)mcHandler);
        wrapper = NetworkRegistry.INSTANCE.newSimpleChannel("MutantCreatures");
        wrapper.registerMessage(PacketSpawnParticles.Handler.class, PacketSpawnParticles.class, 0, Side.CLIENT);
        wrapper.registerMessage(PacketCMOptions.Handler.class, PacketCMOptions.class, 1, Side.SERVER);
        wrapper.registerMessage(PacketZombieAttack.Handler.class, PacketZombieAttack.class, 2, Side.CLIENT);
        wrapper.registerMessage(PacketSnowGolemAttack.Handler.class, PacketSnowGolemAttack.class, 3, Side.CLIENT);
        wrapper.registerMessage(PacketSnowGolemOwner.Handler.class, PacketSnowGolemOwner.class, 4, Side.CLIENT);
        wrapper.registerMessage(PacketEnderAttack.Handler.class, PacketEnderAttack.class, 5, Side.CLIENT);
        wrapper.registerMessage(PacketEnderBlock.Handler.class, PacketEnderBlock.class, 6, Side.CLIENT);
        wrapper.registerMessage(PacketEnderTeleport.Handler.class, PacketEnderTeleport.class, 7, Side.CLIENT);
        wrapper.registerMessage(PacketEnderTPlayer.Handler.class, PacketEnderTPlayer.class, 8, Side.CLIENT);
        wrapper.registerMessage(PacketEHandPos.Handler.class, PacketEHandPos.class, 9, Side.SERVER);
        wrapper.registerMessage(PacketSkeleAttack.Handler.class, PacketSkeleAttack.class, 10, Side.CLIENT);
        EntityRegistry.registerModEntity(MutantCreeper.class, (String)"MutantCreeper", (int)1, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(CreeperMinion.class, (String)"CreeperMinion", (int)2, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(CreeperMinionEgg.class, (String)"CreeperMinionEgg", (int)3, (Object)this, (int)160, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(MutantZombie.class, (String)"MutantZombie", (int)4, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(Zombie.class, (String)"ZombieMinion", (int)5, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(MutantEnderman.class, (String)"MutantEnderman", (int)6, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(ChemicalXEntity.class, (String)"Chemical X", (int)7, (Object)this, (int)160, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(SkullSpirit.class, (String)"SkullSpirit", (int)8, (Object)this, (int)160, (int)20, (boolean)false);
        EntityRegistry.registerModEntity(MutantSnowGolem.class, (String)"MutantSnowGolem", (int)9, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(SGolemBlock.class, (String)"SnowGolemBlock", (int)10, (Object)this, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(EnderBlock.class, (String)"EnderBlock", (int)11, (Object)this, (int)64, (int)100, (boolean)true);
        EntityRegistry.registerModEntity(EndermanClone.class, (String)"EndermanClone", (int)12, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EndersoulFragment.class, (String)"EndersoulFragment", (int)13, (Object)this, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(MutantSkeleton.class, (String)"MutantSkeleton", (int)14, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(SkeletonShot.class, (String)"SkeletonShot", (int)15, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(SkeletonPart.class, (String)"SkeletonPart", (int)16, (Object)this, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(SpiderPig.class, (String)"SpiderPig", (int)17, (Object)this, (int)80, (int)3, (boolean)true);
        MCSpawnEgg.addEgg(MutantCreeper.class, 5349438, 11013646);
        MCSpawnEgg.addEgg(CreeperMinion.class, 894731, 0xB7B7B7);
        MCSpawnEgg.addEgg(MutantZombie.class, 7969893, 44975);
        MCSpawnEgg.addEgg(MutantEnderman.class, 0x161616, 8860812);
        MCSpawnEgg.addEgg(MutantSnowGolem.class, 0xE5FFFF, 16753434);
        MCSpawnEgg.addEgg(MutantSkeleton.class, 0xC1C1C1, 6310217);
        MCSpawnEgg.addEgg(SpiderPig.class, 3419431, 15771042);
        if (spawnCreeper) {
            EntityRegistry.addSpawn(MutantCreeper.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])suitableBiomes);
        }
        if (spawnZombie) {
            EntityRegistry.addSpawn(MutantZombie.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])suitableBiomes);
        }
        if (spawnEnderman) {
            EntityRegistry.addSpawn(MutantEnderman.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])suitableBiomes);
        }
        if (spawnEndermanEnd) {
            EntityRegistry.addSpawn(MutantEnderman.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76779_k});
        }
        if (spawnSkeleton) {
            EntityRegistry.addSpawn(MutantSkeleton.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])suitableBiomes);
        }
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public static boolean isEffectiveClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static void onRenderTick() {
    }

    public static void onClientTick() {
    }

    public static void onServerTick() throws Exception {
        WorldServer[] worlds = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c;
        for (String name : HulkHammer.chunkList.keySet()) {
            ArrayList<ZombieChunk> chunkList = HulkHammer.chunkList.get(name);
            EntityPlayer player = null;
            WorldServer worldObj = null;
            for (int i = 0; i < worlds.length; ++i) {
                player = worlds[i].func_72924_a(name);
                if (player == null) continue;
                worldObj = worlds[i];
                break;
            }
            if (chunkList == null || chunkList.isEmpty()) continue;
            while (chunkList.size() > 16) {
                chunkList.remove(0);
            }
            ZombieChunk chunk = chunkList.remove(0);
            if (chunk.spawnParticles) {
                Block block = worldObj.func_147439_a(chunk.posX, chunk.posY, chunk.posZ);
                int data = worldObj.func_72805_g(chunk.posX, chunk.posY, chunk.posZ);
                worldObj.func_72926_e(2001, chunk.posX, chunk.posY + 1, chunk.posZ, Block.func_149682_b((Block)block) + (data << 12));
            }
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)chunk.posX, (double)(chunk.posY + 1), (double)chunk.posZ, (double)(chunk.posX + 1), (double)(chunk.posY + 2), (double)(chunk.posZ + 1));
            ArrayList<Entity> list = MutantCreatures.getCollidingEntities((Entity)player, (World)worldObj, box);
            for (Entity entity : list) {
                if (!(entity instanceof EntityLivingBase)) continue;
                EntityLivingBase living = (EntityLivingBase)entity;
                living.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), (float)(6 + rand.nextInt(3)));
            }
            if (!chunkList.isEmpty()) continue;
            HulkHammer.chunkList.remove(name);
        }
    }

    public static boolean getRandomSpawnChance() {
        int i = Math.max(1, spawnrate);
        return rand.nextInt(50 / (i = Math.min(20, i))) == 0;
    }

    public static void sendPacketToAll(EntityPlayer player, Packet packet) {
        if (MutantCreatures.isEffectiveClient()) {
            return;
        }
        ((EntityPlayerMP)player).field_71133_b.func_71203_ab().func_148540_a(packet);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean renderSmallEgg(RenderBlocks render, Block block, int x, int y, int z) {
        float fx = 0.0625f;
        float fy1 = 0.9375f;
        float fy2 = 1.0f;
        render.func_147782_a((double)(0.5f - fx), (double)fy1, (double)(0.5f - fx), (double)(0.5f + fx), (double)fy2, (double)(0.5f + fx));
        render.func_147784_q(block, x, y, z);
        fx = 0.125f;
        fy1 = 0.5f;
        fy2 = 0.9375f;
        render.func_147782_a((double)(0.5f - fx), (double)fy1, (double)(0.5f - fx), (double)(0.5f + fx), (double)fy2, (double)(0.5f + fx));
        render.func_147784_q(block, x, y, z);
        fx = 0.1875f;
        fy1 = 0.5625f;
        fy2 = 0.8125f;
        render.func_147782_a((double)(0.5f - fx), (double)fy1, (double)(0.5f - fx), (double)(0.5f + fx), (double)fy2, (double)(0.5f + fx));
        render.func_147784_q(block, x, y, z);
        render.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnParticlesAtEntity(Entity entity, String name, int amount) {
        for (int i = 0; i < amount; ++i) {
            double posX = entity.field_70165_t + (double)(rand.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N;
            double posY = entity.field_70163_u + 0.5 + (double)(rand.nextFloat() * entity.field_70131_O);
            double posZ = entity.field_70161_v + (double)(rand.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N;
            double x = rand.nextGaussian() * 0.02;
            double y = rand.nextGaussian() * 0.02;
            double z = rand.nextGaussian() * 0.02;
            entity.field_70170_p.func_72869_a(name, posX, posY, posZ, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnEnderParticles(Entity entity) {
        MutantCreatures.spawnEnderParticles(entity, 256, 1.8f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnEnderParticles(Entity entity, int amount, float speed) {
        EffectRenderer renderer = Minecraft.func_71410_x().field_71452_i;
        for (int i = 0; i < amount; ++i) {
            float f = (rand.nextFloat() - 0.5f) * speed;
            float f1 = (rand.nextFloat() - 0.5f) * speed;
            float f2 = (rand.nextFloat() - 0.5f) * speed;
            double tempX = entity.field_70165_t + (double)((rand.nextFloat() - 0.5f) * entity.field_70130_N);
            double tempY = entity.field_70163_u + (double)((rand.nextFloat() - 0.5f) * entity.field_70131_O) + 0.5;
            double tempZ = entity.field_70161_v + (double)((rand.nextFloat() - 0.5f) * entity.field_70130_N);
            renderer.func_78873_a((EntityFX)new FXEnder(entity.field_70170_p, tempX, tempY, tempZ, f, f1, f2, true));
        }
    }

    public static ArrayList<Entity> getCollidingEntities(Entity entity, World world, AxisAlignedBB box) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        List entities = world.func_72839_b(entity, box.func_72314_b(4.0, 4.0, 4.0));
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity1 = (Entity)entities.get(i);
            AxisAlignedBB box1 = entity1.field_70121_D;
            if (box1 == null || !box.func_72326_a(box1)) continue;
            list.add(entity1);
        }
        return list;
    }

    public static Vec3 getDirVector(float rotation, float scale) {
        float rad = rotation * ((float)Math.PI / 180);
        return Vec3.func_72443_a((double)(-MathHelper.func_76126_a((float)rad) * scale), (double)0.0, (double)(MathHelper.func_76134_b((float)rad) * scale));
    }

    public static boolean teleportTo(EntityLivingBase living, double x, double y, double z) {
        return MutantCreatures.teleportTo(living, x, y, z, true);
    }

    public static boolean teleportTo(EntityLivingBase living, double x, double y, double z, boolean changeY) {
        double oldX = living.field_70165_t;
        double oldY = living.field_70163_u;
        double oldZ = living.field_70161_v;
        int teleX = MathHelper.func_76128_c((double)x);
        int teleY = MathHelper.func_76128_c((double)y);
        int teleZ = MathHelper.func_76128_c((double)z);
        boolean success = false;
        if (living.field_70170_p.func_72899_e(teleX, teleY, teleZ)) {
            boolean temp = false;
            while (!temp && teleY > 0) {
                Block block = living.field_70170_p.func_147439_a(teleX, teleY - 1, teleZ);
                if (block != Blocks.field_150350_a && block.func_149688_o().func_76230_c()) {
                    temp = true;
                    continue;
                }
                if (!changeY) continue;
                --teleY;
            }
            if (temp || !changeY) {
                living.func_70107_b(x, (double)teleY, z);
                if (living.field_70170_p.func_72945_a((Entity)living, living.field_70121_D).isEmpty() && !living.field_70170_p.func_72953_d(living.field_70121_D)) {
                    success = true;
                }
            }
        }
        if (!success) {
            living.func_70107_b(oldX, oldY, oldZ);
            return false;
        }
        return true;
    }

    public static void removeAttackers(EntityLiving living) {
        List list = living.field_70170_p.func_72872_a(EntityLiving.class, living.field_70121_D.func_72314_b(16.0, 10.0, 16.0));
        for (int i = 0; i < list.size(); ++i) {
            EntityLiving attacker = (EntityLiving)list.get(i);
            if (attacker == living || attacker.func_70638_az() != living) continue;
            attacker.func_70624_b(null);
            attacker.func_70604_c(null);
        }
    }

    static {
        rand = new Random();
        creativeTab = new MCCreativeTab();
        suitableBiomes = new BiomeGenBase[]{BiomeGenBase.field_76772_c, BiomeGenBase.field_76769_d, BiomeGenBase.field_76770_e, BiomeGenBase.field_76767_f, BiomeGenBase.field_76768_g, BiomeGenBase.field_76780_h, BiomeGenBase.field_76781_i, BiomeGenBase.field_76776_l, BiomeGenBase.field_76777_m, BiomeGenBase.field_76774_n, BiomeGenBase.field_76775_o, BiomeGenBase.field_76787_r, BiomeGenBase.field_76786_s, BiomeGenBase.field_76785_t, BiomeGenBase.field_76784_u, BiomeGenBase.field_76783_v, BiomeGenBase.field_76782_w, BiomeGenBase.field_76792_x, BiomeGenBase.field_150574_L, BiomeGenBase.field_150576_N, BiomeGenBase.field_150576_N, BiomeGenBase.field_150583_P, BiomeGenBase.field_150582_Q, BiomeGenBase.field_150585_R, BiomeGenBase.field_150584_S, BiomeGenBase.field_150579_T, BiomeGenBase.field_150578_U, BiomeGenBase.field_150581_V, BiomeGenBase.field_150580_W, BiomeGenBase.field_150588_X, BiomeGenBase.field_150587_Y, BiomeGenBase.field_150589_Z, BiomeGenBase.field_150608_ab, BiomeGenBase.field_150607_aa};
        fTimer = new String[]{"field_71428_T", "S", "timer"};
        fThrower = new String[]{"field_70192_c", "g", "thrower"};
        fShowModel = new String[]{"field_78806_j", "j", "showModel"};
        fCubeList = new String[]{"field_78804_l", "l", "cubeList"};
        fChildModels = new String[]{"field_78805_m", "m", "childModels"};
        fItemInUse = new String[]{"field_71074_e", "f", "itemInUse"};
        fItemInUseCount = new String[]{"field_71072_f", "g", "itemInUseCount"};
    }
}

